/* **************************************************************************

  $Archive: /njcl_v2rmi/src/com/novell/service/jncpv2r/net/NetMemory.java $
  $Revision: 7 $
  $Modtime: 1/05/01 1:11p $

  Copyright (c) 1997 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/
package com.novell.service.jncpv2r.net;

import java.io.*;
import com.novell.service.jncp.*;
import com.novell.java.io.*;

/** @internal
 *
 */
public final class NetMemory implements Serializable
{
   private boolean validHandle;
   private int handle;
   private int size;

   public NetMemory (int size)
   {
      this.size = size;
      this.handle = allocMemory (size);
      this.validHandle = true;
   }


   /** @internal
    * WARNING: If you ever use this constructor, you must not pass a handle
    * in that is already used by another NetMemory instance.  If you do,
    * a page fault will occur in the finalize method, which will try to
    * free the handle that has most likely already been freed.
    */
   public NetMemory (int handle, int size)
   {
      this.size = size;
      this.handle = handle;
      this.validHandle = true;
   }


   /**
    *
    */
   public NetMemory (byte[] byteArray)
      throws NSIException
   {
      this.size = byteArray.length;
      this.handle = allocByteArray (byteArray);
      this.validHandle = true;

   } /* NetMemory */


   public void finalize ()
   {
      if (validHandle)
         freeMemory (handle);
   }


   /**
    *
    */
   public int getHandle ()
   {
     return (handle);
   }

   public int getSize ()
   {
     return (size);
   }

   /** @internal
    * When you call this method, the handle will be freed, and this
    * NetMemory instance will be unusable.
    */
   public native byte[] getByteArray ();

   private native void freeMemory (int handle);
   private native int allocMemory (int size);
   private native int allocByteArray (byte[] buf);

} /* NetMemory */


