/* **************************************************************************

  $Archive: /njcl_v2rmi/src/com/novell/service/jncpv2r/net/NetService.java $
  $Revision: 36 $
  $Modtime: 1/23/01 3:50p $

  Copyright (c) 1997 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/
package com.novell.service.jncpv2r.net;

import java.rmi.RemoteException;

import com.novell.java.lang.IntegerBuffer;
import com.novell.java.lang.BooleanBuffer;
import com.novell.service.toolkit.jcl.NWInteger;
import com.novell.service.toolkit.jcl.NWBoolean;
import com.novell.service.session.SessionService;
import com.novell.service.session.SessionException;

/** @internal
 * Object returned by Session.getService() that wraps all NWNET
 * native services (via NetJNI).
 */
public interface NetService extends SessionService
{
   /**
    * The key used to generate an object of this type via the
    * Session.getService() interface.
    */
// Please leave OLD versions here but commented out for the purpose of
// tracking unique identifiers.
//   public static final String KEY =
//"com.novell.service.jncpv2r.net.NetService.egbdfaceg";
   public static final String KEY =
"com.novell.service.jncpv2r.net.NetService.1029834512";

      /* maximum number of characters in names, not including terminator */
   public final static int  MAX_RDN_CHARS             = 128;
   public final static int  MAX_DN_CHARS              = 256;
   public final static int  MAX_SCHEMA_NAME_CHARS     =  32;
   public final static int  MAX_TREE_NAME_CHARS       =  32;
   public final static int  MAX_SAP_NAME_CHARS        =  47;
   public final static int  MAX_ASN1_NAME             =  32;

      /* Directory Services Large Packet Verb Numbers */
   public final static int  DSV_UNUSED_0                    =  0;    /*0x00*/
   public final static int  DSV_RESOLVE_NAME                =  1;    /*0x01*/
   public final static int  DSV_READ_ENTRY_INFO             =  2;    /*0x02*/
   public final static int  DSV_READ                        =  3;    /*0x03*/
   public final static int  DSV_COMPARE                     =  4;    /*0x04*/
   public final static int  DSV_LIST                        =  5;    /*0x05*/
   public final static int  DSV_SEARCH                      =  6;    /*0x06*/
   public final static int  DSV_ADD_ENTRY                   =  7;    /*0x07*/
   public final static int  DSV_REMOVE_ENTRY                =  8;    /*0x08*/
   public final static int  DSV_MODIFY_ENTRY                =  9;    /*0x09*/
   public final static int  DSV_MODIFY_RDN                  = 10;    /*0x0A*/
   public final static int  DSV_DEFINE_ATTR                 = 11;    /*0x0B*/
   public final static int  DSV_READ_ATTR_DEF               = 12;    /*0x0C*/
   public final static int  DSV_REMOVE_ATTR_DEF             = 13;    /*0x0D*/
   public final static int  DSV_DEFINE_CLASS                = 14;    /*0x0E*/
   public final static int  DSV_READ_CLASS_DEF              = 15;    /*0x0F*/
   public final static int  DSV_MODIFY_CLASS_DEF            = 16;    /*0x10*/
   public final static int  DSV_REMOVE_CLASS_DEF            = 17;    /*0x11*/
   public final static int  DSV_LIST_CONTAINABLE_CLASSES    = 18;    /*0x12*/
   public final static int  DSV_GET_EFFECTIVE_RIGHTS        = 19;    /*0x13*/
   public final static int  DSV_ADD_PARTITION               = 20;    /*0x14*/
   public final static int  DSV_REMOVE_PARTITION            = 21;    /*0x15*/
   public final static int  DSV_LIST_PARTITIONS             = 22;    /*0x16*/
   public final static int  DSV_SPLIT_PARTITION             = 23;    /*0x17*/
   public final static int  DSV_JOIN_PARTITIONS             = 24;    /*0x18*/
   public final static int  DSV_ADD_REPLICA                 = 25;    /*0x19*/
   public final static int  DSV_REMOVE_REPLICA              = 26;    /*0x1A*/
   public final static int  DSV_OPEN_STREAM                 = 27;    /*0x1B*/
   public final static int  DSV_SEARCH_FILTER               = 28;    /*0x1C*/

   public final static int  DSV_CHANGE_REPLICA_TYPE         = 31;    /*0x1F*/

   public final static int  DSV_SYNC_PARTITION              = 38;    /*0x26*/
   public final static int  DSV_SYNC_SCHEMA                 = 39;    /*0x27*/
   public final static int  DSV_READ_SYNTAXES               = 40;    /*0x28*/
   public final static int  DSV_GET_REPLICA_ROOT_ID         = 41;    /*0x29*/
   public final static int  DSV_BEGIN_MOVE_ENTRY            = 42;    /*0x2A*/
   public final static int  DSV_FINISH_MOVE_ENTRY           = 43;    /*0x2B*/
   public final static int  DSV_RELEASE_MOVED_ENTRY         = 44;    /*0x2C*/
   public final static int  DSV_BACKUP_ENTRY                = 45;    /*0x2D*/
   public final static int  DSV_RESTORE_ENTRY               = 46;    /*0x2E*/

   public final static int  DSV_CLOSE_ITERATION             = 50;    /*0x32*/

   public final static int  DSV_GET_SERVER_ADDRESS          = 53;    /*0x35*/
   public final static int  DSV_SET_KEYS                    = 54;    /*0x36*/
   public final static int  DSV_CHANGE_PASSWORD             = 55;    /*0x37*/
   public final static int  DSV_VERIFY_PASSWORD             = 56;    /*0x38*/
   public final static int  DSV_BEGIN_LOGIN                 = 57;    /*0x39*/
   public final static int  DSV_FINISH_LOGIN                = 58;    /*0x3A*/
   public final static int  DSV_BEGIN_AUTHENTICATION        = 59;    /*0x3B*/
   public final static int  DSV_FINISH_AUTHENTICATION       = 60;    /*0x3C*/
   public final static int  DSV_LOGOUT                      = 61;    /*0x3D*/
   public final static int  DSV_REPAIR_RING                 = 62;    /*0x3E*/
   public final static int  DSV_REPAIR_TIMESTAMPS           = 63;    /*0x3F*/

   public final static int  DSV_DESIGNATE_NEW_MASTER        = 69;    /*0x45*/

   public final static int  DSV_CHECK_LOGIN_RESTRICTIONS    = 72;    /*0x48*/

   public final static int  DSV_ABORT_PARTITION_OPERATION   = 76;    /*0x4C*/

   public final static int  DSV_READ_REFERENCES             = 79;    /*0x4F*/
   public final static int  DSV_INSPECT_ENTRY               = 80;    /*0x50*/

   /* values for DCK_CONFIDENCE key */
   public final static int  DCV_LOW_CONF             = 0;
   public final static int  DCV_MED_CONF             = 1;
   public final static int  DCV_HIGH_CONF            = 2;


   /**
    *
    */
   public void setConfidence (
         /*in*/   int level)
      throws SessionException, RemoteException;

   public void setNameCacheDepth (
         /*in*/   int depth)
      throws SessionException, RemoteException;

   /**
    *
    */
   public void setTypelessNames (
         /*in*/   boolean flag)
      throws SessionException, RemoteException;


   public String canonicalizeName (
         /*in*/   String objectName)
      throws SessionException, RemoteException;


   /**
    *    @deprecated    use addFilterToken() instead
    */
   public void addFilterToken (
         /*in*/   int cur,
         /*in*/   int tok,
         /*in*/   int val,
         /*in*/   int syntaxID)
      throws SessionException, RemoteException;

   /**
    *
    */
   public void addFilterToken (
         /*in*/   int cur,
         /*in*/   int tok,
         /*in*/   byte[] val,
         /*in*/   int syntaxID)
      throws SessionException, RemoteException;


   public void addObject (
         /*in*/   String objectName,
         /*in*/   NetIterationHandle iterationHandle,
         /*in*/   boolean more,
         /*in*/   int buf)
      throws SessionException, RemoteException;

   public int allocBuf (
         /*in*/   int size)
      throws SessionException, RemoteException;

   /**
    *
    */
   public NWInteger allocFilter (
         /*in*/   NWInteger cur)
      throws SessionException, RemoteException;

   public void dsBackupObject (
         /*in*/      String objectName,
         /*in/out*/  NetIterationHandle iterationHandle,
         /*out*/     int objectInfo)
      throws SessionException, RemoteException;

   public void beginClassItem (
         /*in*/   int buf)
      throws SessionException, RemoteException;

   public void compare (
         /*in*/   String         object,
         /*in*/   int            buf,
         /*in*/   BooleanBuffer  matched)
      throws SessionException, RemoteException;

   public void closeIteration (
         /*in*/   int            handle,
         /*in*/   int            operation)
      throws SessionException, RemoteException;

   public void freeBuf (
         /*in*/   int buf)
      throws SessionException, RemoteException;

   public int getAttrCount (
         /*in*/   int  buf)
      throws SessionException, RemoteException;

   public void getClassDefCount (
         /*in*/   int         buf,
         /*out*/  IntegerBuffer   classDefCount)
      throws SessionException, RemoteException;

   public void getAttrDef (
         /*in*/   int              buf,
         /*out*/  StringBuffer     attrName,
         /*out*/  NetAttributeInfo attrInfo)
      throws SessionException, RemoteException;

   public void getClassDef (
         /*in*/   int               buf,
         /*out*/  StringBuffer      className,
         /*out*/  NetClassInfo      classInfo)
      throws SessionException, RemoteException;

   public void getClassItemCount (
         /*in*/   int            buf,
         /*out*/  IntegerBuffer  itemCount)
      throws SessionException, RemoteException;

   public void getClassItem (
         /*in*/   int            buf,
         /*out*/  StringBuffer   itemName)
      throws SessionException, RemoteException;

   public void getObjectCount (
         /*in*/   int buf,
         /*out*/  NWInteger objectCount)
      throws SessionException, RemoteException;

   public void getObjectName (
         /*in*/   int buf,
         /*out*/  StringBuffer objectName,
         /*out*/  NWInteger attrCount,
         /*out*/  NetObjectInfo objectInfo)
      throws SessionException, RemoteException;

   public void getSyntaxCount (
         /*in*/   int            buf,
         /*out*/  NWInteger      syntaxCount)
      throws SessionException, RemoteException;

   public void getSyntaxDef (
         /*in*/   int            buf,
         /*out*/  StringBuffer   syntaxName,
         /*out*/  NetSyntaxInfo  syntaxDef)
      throws SessionException, RemoteException;

   public void initBuf (
         /*in*/   int operation,
         /*in*/   int buf)
      throws SessionException, RemoteException;


   /**
    *
    */
   public void list (
         /*in*/      String objectName,
         /*in/out*/  NetIterationHandle iterationHandle,
         /*out*/     NetListBuffer subordinates)
      throws SessionException, RemoteException;

   /**
    *
    */
   public void listContainers (
         /*in*/      String objectName,
         /*in/out*/  NetIterationHandle iterationHandle,
         /*out*/     NetListBuffer subordinates)
      throws SessionException, RemoteException;

   /**
    *
    */
   public void listByClassAndName (
         /*in*/      String               objectName,
         /*in*/      String               className,
         /*in*/      String               subordinateName,
         /*in/out*/  NetIterationHandle   iterationHandle,
         /*out*/     NetListBuffer        subordinates)  //out
      throws SessionException, RemoteException;

   /**
    *
    */
   NetEntryInfo[] listEntries (
         /*in*/   String         objectName,
         /*in*/   int            bufferSize)
      throws SessionException, RemoteException;


   public void putChange (
         /*in*/   int            buf,
         /*out*/  int            changeType,
         /*out*/  String         attrName)
      throws SessionException, RemoteException;

   public void putClassItem (
         /*in*/   int         buf,
         /*in*/   String      itemName)
      throws SessionException, RemoteException;


   /**
    *    @deprecated    use addFilterToken() instead
    */
   public void putFilter (
         /*in*/   int buf,
         /*in*/   int cur, // filter cursor
         /*in*/   int freeVal)
      throws SessionException, RemoteException;

   /**
    *
    */
   public void putFilter (
         /*in*/   int buf,
         /*in*/   int cur)
      throws SessionException, RemoteException;


   public void readObjectInfo (
         /*in*/   String         objectName,
         /*out*/  StringBuffer   distinguishedName,   // optional
         /*out*/  NetObjectInfo  objectInfo)         // optional
      throws SessionException, RemoteException;

   public void mapIDToName (
         /*in*/   int            objectID,
         /*out*/  StringBuffer   object)
      throws SessionException, RemoteException;

   public void mapNameToID (
         /*in*/   String         object,
         /*out*/  IntegerBuffer  objectID)
      throws SessionException, RemoteException;

   public void modifyObject (
        /*in*/       String               objectName,
        /*in/out*/   NetIterationHandle   iterationHandle,
        /*in*/       boolean              more,
        /*in*/       int                  changes)
      throws SessionException, RemoteException;

   public void modifyDN (
         /*in*/   String     objectName,
         /*in*/   String     newDN,
         /*in*/   boolean    deleteOldRDN)
      throws SessionException, RemoteException;

   public void modifyRDN (
         /*in*/   String     objectName,
         /*in*/   String     newDN,
         /*in*/   boolean    deleteOldRDN)
      throws SessionException, RemoteException;

   public void moveObject (
         /*in*/   String     objectName,
         /*in*/   String     destParentDN,
         /*in*/   String     destRDN)
      throws SessionException, RemoteException;

   public void openStream (
         /*in*/   String      objectName,
         /*in*/   String      attrName,
         /*in*/   int         flags,
         /*out*/  NWInteger   fileHandle)
      throws SessionException, RemoteException;

   public void read (
         /*in*/      String               object,
         /*in*/      int                  infoType,
         /*in*/      boolean              allAttrs,
         /*in*/      int                  attrNames,
         /*in/out*/  NetIterationHandle   iterationHandle,
         /*out*/     int                  objectInfo)
      throws SessionException, RemoteException;


   /**
    *
    */
   public NetAttrRecord[] readAttributes (
         /*in*/   String   objectName,
         /*in*/   int      infoType,
         /*in*/   int      attrNames,
         /*in*/   int      bufferSize)
      throws SessionException, RemoteException;


   /**
    *
    */
   public void readAttrDef (
         /*in*/      int                     infoType,
         /*in*/      boolean                 allAttrs,
         /*in*/      int                     attrNames,
         /*in/out*/  NetIterationHandle      iterationHandle,
         /*out*/     NetReadAttrDefBuffer    attrDefs)
      throws SessionException, RemoteException;

   /**
    *
    */
   public String getServerDN ()
      throws SessionException, RemoteException;


   public void removeObject (
         /*in*/   String     object)
      throws SessionException, RemoteException;

   public void resolveName (
         /*in*/   String      objectName,
         /*out*/  NWInteger   conn,                   // optional
         /*out*/  NWInteger   objectID)              // optional
      throws SessionException, RemoteException;

   public void restoreObject (
         /*in*/   String      objectName,
         /*in*/   NetIterationHandle    iterationHandle,
         /*in*/   boolean     more,
         /*in*/   int         size,
         /*in*/   int         objectInfo)
      throws SessionException, RemoteException;

   public void search (
         /*in*/      String      baseObjectName,
         /*in*/      int         scope,
         /*in*/      boolean     searchAliases,
         /*in*/      int         filter,    // a filter buffer.
         /*in*/      int         infoType,
         /*in*/      boolean     allAttrs,
         /*in*/      int         attrNames, // a buffer with the session attribute names.
         /*in/out*/  NetIterationHandle  iterationHandle,
         /*in*/      int         countObjectsToSearch,
         /*out*/     NWInteger   countObjectsSearched,
         /*out*/     int         objectInfo) // buffer to receive objects
      throws SessionException, RemoteException;

   public void auditGetObjectID (
         /*in*/   String         objectName,
         /*out*/  NWInteger      conn,
         /*out*/  NWInteger      objectID)
      throws SessionException, RemoteException;

   /**
    *
    */
   public void getEffectiveRights (
         /*in*/   String      subjectName,
         /*in*/   String      objectName,
         /*in*/   String      attrName,
         /*out*/  NWInteger   privileges)
      throws SessionException, RemoteException;

   /**
    *
    */
   public void listAttrsEffectiveRights (
         /*in*/      String               objectName,
         /*in*/      String               subjectName,
         /*in*/      boolean              allAttrs,
         /*in*/      int                  attrNames,
         /*in/out*/  NetIterationHandle   iterationHandle,
         /*out*/     int                  privilegeInfo)
      throws SessionException, RemoteException;

   public void computeAttrValSize (
         /*in*/   int         buf,
         /*in*/   int        syntaxID,
         /*out*/  NWInteger  attrValSize)
      throws SessionException, RemoteException;

   public void abbreviateName (
         /*in*/   String         inName,
         /*out*/  StringBuffer   abbreviatedName)
      throws SessionException, RemoteException;

   public String removeAllTypes (
         /*in*/   String         name)
      throws SessionException, RemoteException;


   public void cIStringsMatch (
         /*in*/   String      string1,
         /*in*/   String      string2,
         /*out*/  NWBoolean   matches)
      throws SessionException, RemoteException;

   public void getAttrName (
         /*in*/   int         buf,
         /*out*/  StringBuffer attrName,
         /*out*/  NWInteger   attrValCount,           // optional
         /*out*/  NWInteger   syntaxID)              // optional
      throws SessionException, RemoteException;

   /**
    *    @deprecated    use getAttributeValue() instead
    */
   public void getAttrVal (
         /*in*/   int         buf,
         /*in*/   int         syntaxID,
         /*out*/  NetMemory   attrVal)
      throws SessionException, RemoteException;


   /**
    *
    */
   public byte[] getAttributeValue (
         /*in*/   int                  buf,
         /*in*/   int                  syntaxID)
      throws SessionException, RemoteException;


   public void putAttrName (
         /*in*/   int         buf,
         /*in*/   String      attrName)
      throws SessionException, RemoteException;

   /**
    *    @deprecated    use putAttributeValue() instead
    */
   public void putAttrVal (
         /*in*/   int         buf,
         /*in*/   int         syntaxID,
         /*in*/   int         attrVal)
      throws SessionException, RemoteException;


   /**
    *
    */
   public void putAttributeValue (
         /*in*/   int               buf,
         /*in*/   int               syntaxID,
         /*in*/   byte[]            attributeValue)
      throws SessionException, RemoteException;


   public void getSyntaxID (
         /*in*/   String      attrName,
         /*out*/  NWInteger   syntaxID)
      throws SessionException, RemoteException;

   public void replaceAttrNameAbbrev (
         /*in*/   String         inStr,
         /*out*/  StringBuffer   outStr)
      throws SessionException, RemoteException;

   public void extSyncList (
         /*in*/      String               objectName,
         /*in*/      String               className,
         /*in*/      String               subordinateName,
         /*in/out*/  NetIterationHandle   iterationHandle,
         /*in*/      int                  timeStamp,
         /*in*/      boolean              onlyContainers,
         /*out*/     NetListBuffer        subordinates)
      throws SessionException, RemoteException;

   public void extSyncRead (
         String      objectName,
         int         infoType,
         boolean     allAttrs,
         int         attrNames,        //in, the request buffer
         NetIterationHandle  iterationHandle,   //in-out
         NetBuffer  objectInfo)
      throws SessionException, RemoteException;

   public void extSyncSearch (
         String      baseObjectName,
         int         scope,
         boolean     searchAliases,
         int         filter,    //a filter buffer.
//    NDSTimeStamp timeStamp,
         int         infoType,
         boolean     allAttrs,
         int         attrNames, //a buffer with the session attribute names.
         NetIterationHandle  iterationHandle,
         int         countObjectsToSearch,
         NWInteger   countObjectsSearched,
         NetBuffer   objectInfo)
      throws SessionException, RemoteException;

   /**
    *
    */
   public void readClassDef (
         /*in*/      int                     infoType,
         /*in*/      boolean                 allClasses,
         /*in*/      int                     classNames,
         /*in/out*/  NetIterationHandle      iterationHandle,
         /*out*/     NetReadClassDefBuffer   classDefs)
      throws SessionException, RemoteException;


   public void defineAttr (
         /*in*/   String            attrName,
         /*in*/   NetAttributeInfo  attrDef)
      throws SessionException, RemoteException;

   public void defineClass (
         /*in*/   String         className,
         /*in*/   NetClassInfo   classInfo,
         /*in*/   int            classItems)
      throws SessionException, RemoteException;

   public void removeClassDef (
         /*in*/   String         className)
      throws SessionException, RemoteException;

   public void modifyClassDef (
         /*in*/   String         className,
         /*in*/   int            optionalAttrs)
      throws SessionException, RemoteException;

   public void readSyntaxes (
         /*in*/      int                  infoType,
         /*in*/      boolean              allSyntaxes,
         /*in*/      int                  syntaxNames,
         /*in/out*/  NetIterationHandle   iterationHandle,
         /*out*/     int                  syntaxDefs)
      throws SessionException, RemoteException;

   public void removeAttrDef (
         /*in*/   String         attrName)
      throws SessionException, RemoteException;

   public void putSyntaxName (
         /*in*/   int            buf,
         /*in*/   String         syntaxName)
      throws SessionException, RemoteException;

   public void putClassName (
         /*in*/   int            buf,
         /*in*/   String         itemName)
      throws SessionException, RemoteException;

   public void readSyntaxDef (
         /*in*/   int            syntaxID,
         /*out*/  NetSyntaxInfo  syntaxDef)
      throws SessionException, RemoteException;

   public void syncSchema (
         /*in*/   String         server,
         /*in*/   int            seconds)
      throws SessionException, RemoteException;

   // ******************** Partition methods ********************

   public void abortPartitionOperation (
      /*in*/   String         partitionRoot)
      throws SessionException, RemoteException;

   public void addPartition (
         /*in*/      String               server,
         /*in*/      String               partitionRoot,
         /*in/out*/  NetIterationHandle   iterationHandle,
         /*in*/      boolean              more,
         /*in*/      int                  objectInfo)
      throws SessionException, RemoteException;

   public void addReplica (
         /*in*/      String         server,
         /*in*/      String         partitionRoot,
         /*in*/      int            replicaType)
      throws SessionException, RemoteException;

   public void changeReplicaType (
         /*in*/      String         replicaName,
         /*in*/      String         server,
         /*in*/      int            newReplicaType)
      throws SessionException, RemoteException;

   public void getPartitionExtInfo (
         /*in*/      int                 infoPtr,
         /*in*/      int                 limit,
         /*in*/      int                 infoFlag,
         /*out*/     IntegerBuffer       length,   /* this is different than the C API */
         /*out*/     NetPartitionExtInfo data)
      throws SessionException, RemoteException;

   public void getPartitionExtInfoPtr (
         /*in*/      int            buf,
         /*out*/     IntegerBuffer  infoPtr,       /* this is different than the C API */
         /*out*/     IntegerBuffer  infoPtrEnd)
      throws SessionException, RemoteException;

   public void getPartitionInfo (
         /*in*/      int            buf,
         /*out*/     StringBuffer   partitionName,
         /*out*/     IntegerBuffer  replicaType)
      throws SessionException, RemoteException;

   public void getPartitionRoot (
         /*in*/   String         objectName,
         /*out*/  StringBuffer   partitionRoot)
      throws SessionException, RemoteException;

   public void getServerName (
         /*in*/      int            buf,
         /*out*/     StringBuffer   serverName,
         /*out*/     IntegerBuffer  partitionCount)
      throws SessionException, RemoteException;

   public void joinPartitions (
         /*in*/   String         subordinatePartition,
         /*in*/   int            flags)
      throws SessionException, RemoteException;

   public void listPartitions (
         /*in/out*/  NetIterationHandle   iterationHandle,
         /*in*/      String               server,
         /*out*/     int                  partitions)
      throws SessionException, RemoteException;

   public void listPartitionsExtInfo (
         /*in/out*/  NetIterationHandle   iterationHandle,
         /*in*/      String               server,
         /*in*/      int                  DSPFlags,
         /*in*/      int                  partitions)
      throws SessionException, RemoteException;

   public void partitionReceiveAllUpdates (
         /*in*/      String         partitionRoot,
         /*in*/      String         serverName)
      throws SessionException, RemoteException;

   public void partitionSendAllUpdates (
         /*in*/      String         partitionRoot,
         /*in*/      String         serverName)
      throws SessionException, RemoteException;

   public void removePartition (
         /*in*/      String         partitionRoot)
      throws SessionException, RemoteException;

   public void removeReplica (
         /*in*/      String         server,
         /*in*/      String         partitionRoot)
      throws SessionException, RemoteException;

   public void splitPartition (
         /*in*/   String         subordinatePartition,
         /*in*/   int            flags)
      throws SessionException, RemoteException;

   public void syncPartition (
         /*in*/      String         server,
         /*in*/      String         partition,
         /*in*/      int            seconds)
      throws SessionException, RemoteException;

   public void syncReplicaToServer (
         /*in*/   String         serverName,
         /*in*/   String         partitionRootName,
         /*in*/   String         destServerName,
         /*in*/   int            actionFlags,
         /*in*/   int            delaySeconds)
      throws SessionException, RemoteException;


   /**
    *
    */
   public void reloadDS (
         /*in*/      String serverName)
      throws SessionException, RemoteException;


    // ******************** Nds server methods ********************
/*
   public void openConnToNDSServer (
         in      String         serverName,
         out     IntegerBuffer  connHandle)
      throws SessionException;
*/
   public void getServerAddresses (
         /*out*/     IntegerBuffer  countNetAddresses,
         /*out*/     int            netAddresses)
      throws SessionException, RemoteException;

   // ******************** Object Info methods ********************

   /**
    *    @deprecated    use readEntry() instead
    */
   public void readObjectDSIInfo (
         /*in*/   String      object,
         /*out*/  NetMemory   objectInfo)
      throws SessionException, RemoteException;

   /**
    *    @deprecated    use readEntry() instead
    */
   public void getDSIInfo (
         /*in*/   NetMemory   buf,
         /*in*/   int         infoFlag,
         /*out*/  NetMemory   data)
      throws SessionException, RemoteException;


   /**
    *
    */
   public NetEntryInfo readEntry (
         /*in*/   String            object,
         /*in*/   int               bufferSize)
      throws SessionException, RemoteException;


   public void getNWNetVersion (
         /*out*/  IntegerBuffer   majorVersion,
         /*out*/  IntegerBuffer   minorVersion,
         /*out*/  IntegerBuffer   revisionLevel,
         /*out*/  IntegerBuffer   betaReleaseLevel)
      throws SessionException, RemoteException;

   /**
    *
    */
   public int getFileServerUTCTime ()
      throws SessionException, RemoteException;


   // ******************** SKADS methods ********************

   public void itrCreateSearch (
         /*in*/   String   baseObjectName,
         /*in*/   int      scope,
         /*in*/   boolean   searchAliases,
         /*in*/   int      filter,      // a filter buffer
         /*in*/   int      timeFilter,   // a time filter
         /*in*/   int      infoType,
         /*in*/   boolean   allAttrs,
         /*in*/   int      attrNames,   // a buffer with the attribute names
         /*in*/   String   indexSelect,
         /*in*/   String   sortKey,
         /*in*/   int      scalability,
         /*in*/   int      timeout,
         /*out*/  int[]      iterator)
      throws SessionException, RemoteException;

   public void itrCreateList (
         /*in*/   String   baseObjectName,
         /*in*/   String   className,
         /*in*/   String   subordinateName,
         /*in*/   int      scalability,
         /*in*/   int      timeout,
         /*out*/  int[]    iterator)
      throws SessionException, RemoteException;

   public void itrDestroy (
         /*in*/   int   iterator)
      throws SessionException, RemoteException;

   public void itrClone (
         /*in*/   int   iterator,
         /*out*/   int[]   newIterator)
      throws SessionException, RemoteException;


   public boolean itrAtFirst (
         /*in*/   int   iterator)
      throws SessionException, RemoteException;

   public boolean itrAtEOF (
         /*in*/   int   iterator)
      throws SessionException, RemoteException;

   public void itrGetInfo (
         /*in*/   int   iterator,
         /*out*/  boolean[] isScalable,
         /*out*/  boolean[] isPositionable)
      throws SessionException, RemoteException;


   public void itrGetPosition (
         /*in*/   int   iterator,
         /*out*/   int[]   position,
         /*in*/   int   timeout)
      throws SessionException, RemoteException;

   public void itrSetPosition (
         /*in*/   int   iterator,
         /*in*/   int   position,
         /*in*/   int   timeout)
      throws SessionException, RemoteException;

   public void itrSetPositionFromIterator (
         /*in*/   int   iterator,
         /*in*/   int   srcIterator,
         /*in*/   int   timeout)
      throws SessionException, RemoteException;

   public void itrTypeDown (
         /*in*/   int      iterator,
         /*in*/   String   attribute,
         /*in*/   String   value,
         /*in*/   int   timeout)
      throws SessionException, RemoteException;

   public void itrSkip (
         /*in*/   int     iterator,
         /*in*/   int     numToSkip,
         /*in*/   int     timeout,
         /*out*/   int[]   numSkipped)
      throws SessionException, RemoteException;

   public void itrGetNext (
         /*in*/      int                  iterator,
         /*in*/      int                  numEntries,
         /*in*/      int                  timeout,
         /*in/out*/  NetIterationHandle   iterationHandle,
         /*out*/      int                  data)
      throws SessionException, RemoteException;

   public void itrGetPrev (
         /*in*/      int                  iterator,
         /*in*/      int                  numEntries,
         /*in*/      int                  timeout,
         /*in/out*/  NetIterationHandle   iterationHandle,
         /*out*/      int                  data)
      throws SessionException, RemoteException;

   public void itrGetCurrent (
         /*in*/      int                  iterator,
         /*in/out*/  NetIterationHandle   iterationHandle,
         /*out*/      int                  data)
      throws SessionException, RemoteException;

   public void itrCount (
         /*in*/   int      iterator,
         /*in*/   int      timeout,
         /*in*/   int      maxCount,
         /*in*/   boolean   updatePosition,
         /*out*/   int[]      count)
      throws SessionException, RemoteException;

} /* NetService */

