/* **************************************************************************

  $Archive: /njcl/src/com/novell/service/ncpext/NCPExtensionInfo.java $
  $Revision: 5 $
  $Modtime: 7/28/99 10:26a $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.service.ncpext;

import com.novell.service.ncpext.NCPExtensionStrings;

/**
 * Provides an attribute of an NCPExtension with a single value
 * that is an instance of NCPExtensionInfoImpl.
 *
 * @see NCPExtensionInfoImpl
 */
public interface NCPExtensionInfo
{
  /**
   *  The attribute ID of this attribute.
   *
   * (attrID = NCPExtensionStrings.NCPEXTENSION_ATTRIBUTE_ID)
   */
   static final String attrID = NCPExtensionStrings.NCPEXTENSION_ATTRIBUTE_ID;

  /**
   * The length of the query data requested and returned.
   *
   * (queryDataLength = 32)
   */
   static final int queryDataLength = 32;

   /**
    * Returns the NCP Extension ID.
    *
    * @return The NCP Extension ID.
    */
   public int getExtensionID();

   /**
    * Returns the NCP Extension name.
    *
    * @return The NCP Extension Name.
    */
   public String getExtensionName();

   /**
    * Returns the NCP Extension major version.
    *
    * @return The NCP Extension major version.
    */
   public int getMajorVersion();

   /**
    * Returns the NCP Extension minor version.
    *
    * @return The NCP Extension minor version.
    *
    */
   public int getMinorVersion();

   /**
    * Returns the NCP Extension revision.
    *
    * @return  The NCP Extension revision.
    */
   public int getRevision();

   /**
    * Returns the NCP Extension query data.
    *
    * @return The NCP Extension query data in a byte array.
    */
   public byte[] getQueryData();

   /**
    * Sets the NCP Extension ID.
    *
    * @param id The NCP Extension ID.
    */
   public void setExtensionID(int id);

   /**
    * Sets the NCP Extension name.
    *
    * @param name The NCP Extension name as a String.
    */
   public void setExtensionName(String name);

   /**
    * Sets the NCP Extension major version.
    *
    * @param ver The NCP Extension major verion.
    */
   public void setMajorVersion(int ver);

   /**
    * Sets the NCP Extension minor version.
    *
    * @param ver The NCP Extension minor verion.
    */
   public void setMinorVersion(int ver);

   /**
    * Sets the NCP Extension revision.
    *
    * @param ver The NCP Extension revision.
    */
   public void setRevision(int ver);

   /**
    * Sets the NCP Extension query data.
    *
    * @param data The NCP Extension query data as a byte array.
    */
   public void setQueryData(byte[] data);
}