/* **************************************************************************

  $Archive: /njcl_v2rmi/src/com/novell/service/ncpext/NCPExtensionInfoImpl.java $
  $Revision: 10 $
  $Modtime: 11/28/00 2:55p $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.service.ncpext;

import javax.naming.*;
import javax.naming.directory.*;
import com.novell.utility.naming.directory.StaticAttributeValue;
import com.novell.service.rfc1960.SearchStringComponent;

/**
 * Provides the value for attribute NCPExtensionInfo, and methods for
 * getting information about the NCP Extension loaded on the server.
 *
 * @see NCPExtensionInfo
 */
public class NCPExtensionInfoImpl implements
com.novell.utility.naming.directory.StaticAttributeValue,
com.novell.service.ncpext.NCPExtensionInfo,
java.io.Serializable
{
   private int          extensionID;
   private String       extensionName;
   private int          majorVersion;
   private int          minorVersion;
   private int          revision;
   private byte[]       queryData;

   /**
    * Creates an NCPExtensionInfoImpl object using the passed in name.
    *
    * @param name The NCP Extension name.
    */
   public NCPExtensionInfoImpl(
         String name)
   {
      extensionName = name;
      queryData = new byte[queryDataLength];
   }

   /**
    * Creates an NCPExtensionInfoImpl object using the passed in
    * extensionID.
    *
    * @param id The NCP Extension ID.
    */
   public NCPExtensionInfoImpl(
         int id)
   {
      extensionID = id;
      queryData = new byte[queryDataLength];
   }

   /**
    * Returns the NCP Extension ID.
    *
    * @return The NCP Extension ID.
    */
   public int getExtensionID()
   {
      return extensionID;
   }

   /**
    * Returns the NCP Extension name.
    *
    * @return The NCP Extension Name.
    */
   public String getExtensionName()
   {
      return extensionName;
   }

   /**
    * Returns the NCP Extension major version.
    *
    * @return The NCP Extension major version.
    */
   public int getMajorVersion()
   {
      return majorVersion;
   }

   /**
    * Returns the NCP Extension minor version.
    *
    * @return The NCP Extension minor version.
    *
    */
   public int getMinorVersion()
   {
      return minorVersion;
   }

   /**
    * Returns the NCP Extension revision.
    *
    * @return The NCP Extension revision.
    */
   public int getRevision()
   {
      return revision;
   }

   /**
    * Returns the NCP Extension query data.
    *
    * @return The NCP Extension query data in a byte array.
    */
   public byte[] getQueryData()
   {
      return queryData;
   }

   /**
    * Sets the NCP Extension ID.
    *
    * @param id The NCP Extension ID.
    */
   public void setExtensionID(int id)
   {
      extensionID = id;
   }

   /**
    * Sets the NCP Extension name.
    *
    * @param name The NCP Extension name as a String.
    */
   public void setExtensionName(String name)
   {
      extensionName = name;
   }

   /**
    * Sets the NCP Extension major version.
    *
    * @param ver The NCP Extension major verion.
    */
   public void setMajorVersion(int ver)
   {
      majorVersion = ver;
   }

   /**
    * Sets the NCP Extension minor version.
    *
    * @param ver The NCP Extension minor verion.
    */
   public void setMinorVersion(int ver)
   {
      minorVersion = ver;
   }

   /**
    * Sets the NCP Extension revision.
    *
    * @param ver The NCP Extension revision.
    */
   public void setRevision(int ver)
   {
      revision = ver;
   }

   /**
    * Sets the NCP Extension query data.
    *
    * @param data The NCP Extension query data in a byte array.
    */
   public void setQueryData(byte[] data)
   {
      for(int x=0; x<queryData.length; x++)
         queryData[x] = (x < data.length) ? data[x] : (byte)0;
   }

  /**
   * @internal
   */
   public Attribute buildAttribute() throws NamingException
   {
      return new BasicAttribute(attrID, this);
   }

  /**
   * @internal
   */
   public String getID()
   {
      return attrID;
   }

   // NCPExtensions does not support search, schema or modifying attributes
   // so all of the following methods are not supported.
  /**
   * @internal
   */
   public void addAttribute(
         Attribute attr)
   throws NamingException
   {
      throw new javax.naming.directory.AttributeModificationException();
   }

  /**
   * @internal
   */
   public void deleteAttribute(
         Attribute attr)
   throws NamingException
   {
      throw new javax.naming.directory.AttributeModificationException();
   }

  /**
   * @internal
   */
   public void modifyAttribute(
         Attribute attr)
   throws NamingException
   {
      throw new javax.naming.directory.AttributeModificationException();
   }

  /**
   * @internal
   */
   public boolean compare(
         SearchStringComponent ssc)
      throws NamingException
   {
      throw new OperationNotSupportedException();
   }

  /**
   * @internal
   */
   public boolean hasMoreElements()
   {
      return false;
   }

  /**
   * @internal
   */
   public Object nextElement()
   {
      throw new java.util.NoSuchElementException();
   }

  /**
   * @internal
   */
   public Object getStaticInterface()
   {
      return this;
   }

  /**
   * @internal
   * Copies the CallsServiceRemote from object into this object
   */
   public void copy(NCPExtensionInfoImpl from)
   {
      extensionID = from.extensionID;
      extensionName = from.extensionName;
      majorVersion = from.majorVersion;
      minorVersion = from.minorVersion;
      revision = from.revision;
      queryData = from.queryData;
   }
}