/* **************************************************************************

  $Archive: /njcl_v2rmi/src/com/novell/service/nds/NdsLong.java $
  $Revision: 11 $
  $Modtime: 11/15/00 3:43p $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.service.nds;

//##begin module.additionalImports preserve=no
//##end module.additionalImports

//##begin module.imports preserve=yes
//##end module.imports

import java.io.Serializable;

import com.novell.service.schema.SchemaNumber;


// ==================================================================

//##begin module.declarations preserve=no
//##end module.declarations

//##begin module.additionalDeclarations preserve=yes
//##end module.additionalDeclarations

/**
 * Provides access to values of the Long attribute.
 * It is used for attributes whose values are signed integers.
 * The attributes for two longs match for equality if they are
 * the same. The comparison for ordering uses signed integer
 * rules. Attributes using this syntax can set size limits.
 * 
 * <p>Matching Rules: Equality and Ordering</p>
 *
 * @see NdsSyntaxId
 */
public class NdsLong implements SchemaNumber, Serializable {
    //##begin NdsLong.initialDeclarations preserve=yes
    //##end NdsLong.initialDeclarations

  /**
   * @internal
   */
    protected long value;

  /**
   * @internal
   */
    protected String name;

  /**
   * Constructs an NdsLong object based on the specified
   * name and value parameters.
   *
   * @param name  The String name to be stored.
   * @param value The long value to be stored.
   */
    protected NdsLong(String name, long value) {
    //##begin NdsLong::NdsLong%3399E0B20000.body preserve=yes
      this.name = name;
      this.value = value;
    //##end NdsLong::NdsLong%3399E0B20000.body

    }

  /**
   * Compares two objects for ordering, or compares two strings
   * lexicographically. For the Long syntax, the compareTo
   * method compares this NDS Object with a reference NDS Object
   * contained in the anObject parameter. The comparison is done
   * according to the Ordering matching rule for this syntax.
   * 
   * @param anObject The reference NDS Object with which
   *                 to compare.
   *
   * @return An int set to 0 if the reference Object is equal
   *         to this Object; an int <0 if the reference Object
   *         is less than this Object; an int >0 if the reference
   *         Object is greater than this Object.
   *
   * @exception IllegalArgumentException The passed-in object is of
   *            a different type than this NDS Object.
   */
    public int compareTo(Object anObject)throws Exception
 {
    //##begin NdsLong::compareTo%3399E0F300EA.body preserve=yes
      if (anObject instanceof NdsLong)
      {
         long value;

         value = ((NdsLong) anObject).value;
         return (this.value > value ? 1 : this.value < value ? -1 : 0);
      }
      throw (new IllegalArgumentException ());
    //##end NdsLong::compareTo%3399E0F300EA.body

    }

  /**
   * Compares two Objects for equality. The equals method compares
   * this object value with the value of the reference object in
   * the anObject parameter.
   *
   * <p>The equals method implements the most discriminating possible
   * equivalence relation on objects; that is, for any reference values
   * X and Y, this method returns TRUE if and only if X and Y refer to
   * the same object (X==Y has the value TRUE).</p>
   * 
   * @param anObject The reference object with which to compare.
   *
   * @return A boolean set to TRUE if and only if the argument is not
   *         NULL and is an NDS integer object that contains the
   *         same value as this object, otherwise set to FALSE.
   */
    public boolean equals(Object anObject) {
    //##begin NdsLong::equals%3399E0F30119.body preserve=yes
      if ((anObject != null) && (anObject instanceof NdsLong))
      {
         return (value == ((NdsLong) anObject).value);
      }
      return (false);
    //##end NdsLong::equals%3399E0F30119.body

    }

  /**
   * @internal
   */
    public String getName() {
    //##begin NdsLong::getName%3399E0F30138.body preserve=yes
      return (name);
    //##end NdsLong::getName%3399E0F30138.body

    }

  /**
   * @internal
   */
    public String getSyntaxId() {
    //##begin NdsLong::getSyntaxId%3399E0F30157.body preserve=yes
      return ("Long");
    //##end NdsLong::getSyntaxId%3399E0F30157.body

    }

   /**
    * Returns the value of this NDS object as an int.
    * 
    * @return The int value of this NDS object.
    */
    public int intValue() {
    //##begin NdsLong::intValue%3399E0F30177.body preserve=yes
      return ((int) value);
    //##end NdsLong::intValue%3399E0F30177.body

    }

   /**
    * Returns the value of this NDS object as a long.
    * 
    * @return The long value of this NDS object.
    */
    public long longValue() {
    //##begin NdsLong::longValue%3399E0F301A5.body preserve=yes
      return (value);
    //##end NdsLong::longValue%3399E0F301A5.body

    }

   /**
    * Returns the value of this NDS object as a float.
    * 
    * @return The float value of this NDS object.
    */
    public float floatValue() {
    //##begin NdsLong::floatValue%3399E0F301C5.body preserve=yes
      return ((float) value);
    //##end NdsLong::floatValue%3399E0F301C5.body

    }

   /**
    * Returns the value of this NDS object as a double.
    * 
    * @return The double value of this NDS object.
    */
    public double doubleValue() {
    //##begin NdsLong::doubleValue%3399E0F301E4.body preserve=yes
      return ((double) value);
    //##end NdsLong::doubleValue%3399E0F301E4.body

    }

   /**
    * Returns the value of this NDS object as a byte.
    * 
    * @return The byte value of this NDS object.
    */
    public byte byteValue() {
    //##begin NdsLong::byteValue%3399E0F30213.body preserve=yes
      return ((byte) value);
    //##end NdsLong::byteValue%3399E0F30213.body

    }

   /**
    * Returns the value of this NDS object as a short.
    * 
    * @return The short value of this NDS object.
    */
    public short shortValue() {
    //##begin NdsLong::shortValue%3399E0F30232.body preserve=yes
      return ((short) value);
    //##end NdsLong::shortValue%3399E0F30232.body

    }

  /**
   * Generates a string representation of the object. It
   * returns a string that textually represents the object.
   * The result should be a concise but informative
   * representation that is easy to read.
   *
   * @return The String representation of the object.
   */
    public String toString() {
    //##begin NdsLong::toString%3399E25903D8.body preserve=yes
      String strValue = String.valueOf (value);

      if (null == name)
         return (getSyntaxId () + " " + strValue);
      else
         return (getSyntaxId () + " " + name + " = " + strValue);
    //##end NdsLong::toString%3399E25903D8.body

    }

    //##begin NdsLong.additionalDeclarations preserve=yes
    //##end NdsLong.additionalDeclarations

}

