/* **************************************************************************

  $Archive: /njcl_v2rmi/src/com/novell/service/nds/NdsPartition.java $
  $Revision: 7 $
  $Modtime: 11/15/00 3:43p $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/
package com.novell.service.nds;

import javax.naming.*;

import com.novell.service.nds.naming.NdsPartitionOperationException;

/**
* Defines methods for aborting partition operations.
*
* <p>Implemented by the NdsPartitionTreeRootContext class for the
* NDS namespace.
*/

public interface NdsPartition
{
   /** Aborts all pending Partition operations.
    *
    * @param name String containing the name of the partition
    *             whose pending operations are to be aborted.
    *
    * @exception PartitionOperationException Wrapper for error returns
    *                                        by the NWDS calls
    */
    public void abortOperations(
            String name)
        throws NdsPartitionOperationException;

   /** Aborts all pending Partition operations.
    *
    * @param name Name object containing the name of the partition
    *             whose pending operations are to be aborted.
    *
    * @exception PartitionOperationException Wrapper for error returns
    *                                        by the NWDS calls
    */
    public void abortOperations(
            Name name)
        throws NdsPartitionOperationException;

}
