
/* **************************************************************************

  $Archive: /njcl_v2rmi/src/com/novell/service/nds/NdsUnknown.java $
  $Revision: 9 $
  $Modtime: 11/15/00 3:43p $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.service.nds;


import java.io.Serializable;

import java.util.Enumeration;
import java.util.Vector;

import com.novell.service.schema.SchemaValue;
import com.novell.service.schema.SchemaComposite;


/**
 * Provides access to values of the Unknown attribute.
 * It is used for attributes that represents strings
 * of binary information. Attributes whose attribute definition
 * has been deleted from the schema use the Unknown syntax.
 * 
 * <p>Matching Rules: (none)</p>
 * 
 * @see NdsSyntaxId
 */
public class NdsUnknown
   implements NdsAttributeValue, SchemaComposite, Cloneable, Serializable
{
   private static final int matchingRules = none;

   private static String[] compositeIds;

   static {
      compositeIds = new String[4];
      compositeIds[0] = "attributeName";
      compositeIds[1] = "syntaxId";
      compositeIds[2] = "valueLength";
      compositeIds[3] = "value";
   }

  /**
   * @internal
   */
   protected String attributeName;

  /**
   * @internal
   */
   protected int syntaxId;

  /**
   * @internal
   */
   protected byte[] value;

   private String name;


   /**
   * Constructs an NdsUnknown object based on the specified
   * attributeName, syntaxId, and value parameters.
   * 
   * @param attributeName The attribute name stored as a String value.
   * @param syntaxId      The syntax ID stored as an int value.
   * @param value         The values stored as a byte array.
   */
   protected NdsUnknown (
         String attributeName,
         int syntaxId,
         byte[] value)
   {
      this ("", attributeName, syntaxId, value);
   }

  /**
   * @internal
   */
   protected NdsUnknown ()
   {
      this.syntaxId = -1;
   }

   /*
    * Private constructor; not documented!
    */
   private NdsUnknown (
         String name,
         String attributeName,
         int syntaxId,
         byte[] value)
   {
      this.attributeName = attributeName;
      this.syntaxId = syntaxId;
      this.value = (byte[]) value.clone ();
      this.name = name;
   }

  /**
   * @internal
   */
   protected NdsUnknown (
         NdsUnknown anUnknown)
   {
      this.attributeName = anUnknown.attributeName;
      this.syntaxId = anUnknown.syntaxId;
      this.value = anUnknown.value;
      this.name = anUnknown.name;
   }


   // ******************** SchemaValue Interface ********************

  /**
   * Compares two objects for ordering, or compares two strings
   * lexicographically.
   *
   * The compareTo method does not apply to the Unknown
   * syntax because this syntax does not support the ordering
   * and substrings matching rules.
   */
   public int compareTo (
         Object anObject)
      throws Exception
   {
      throw (new Exception ());
   }

  /**
   * Compares two Objects for equality. The equals method compares
   * this object value with the value of the reference object in
   * the anObject parameter.
   *
   * The equals method does not apply to the Unknown syntax
   * because this syntax does not support the equality
   * matching rule.
   */
   public boolean equals (
         Object anObject)
   {
      return (false);
   }

  /**
   * @internal
   */
   public String getName ()
   {
      return (attributeName);
   }

  /**
   * @internal
   */
   public String getSyntaxId ()
   {
      return (NdsSyntaxId.UNKNOWN);
   }


   // ******************** SchemaComposite Interface ********************

   /**
    * Returns the number of elements in this sequence.
    *
    * @return The number of elements in this sequence as an int.
    */
   public int count ()
   {
      return (compositeIds.length);
   }

   /**
   * Returns a SchemaValue object based on the given passed-in
   * string containing the element value. The SchemaValue object
   * is a Java language data type.
   *
   * @param compositeId The passed-in string containing the element
   *                    value.
   *
   * @return The SchemaValue object containing the attributeName,
   *         syntaxId, and valueLength, or NULL.
   */
   public SchemaValue getValue (
         String compositeId)
   {
      if (compositeId.equalsIgnoreCase (compositeIds[0]))
      {
         // getAttributeName ();
         return (new NdsString (compositeIds[0], attributeName));
      }
      else if (compositeId.equalsIgnoreCase (compositeIds[1]))
      {
         // getSyntaxId ();
         return (new NdsInteger (compositeIds[1], syntaxId));
      }
      else if (compositeId.equalsIgnoreCase (compositeIds[2]))
      {
         // getValueLength ();
         return (new NdsInteger (compositeIds[2], value.length));
      }
      else if (compositeId.equalsIgnoreCase (compositeIds[2]))
      {
         // getValue ();
/*
         return (new SchemaElement (
                        compositeIds[2],
                        address.clone (),
                        "byte[]"));
*/
      }
      return (null);
   }

  /**
   * Returns an enumeration of composit IDs.
   *
   * @return An enumeration of composite IDs.
   */
   public Enumeration getValueIds ()
   {
      Vector vector = new Vector ();

      for (int i = 0; i < compositeIds.length; i++)
         vector.addElement (compositeIds[i]);
      return (vector.elements ());
   }

   /**
    * Returns an enumeration of the elements in this composite.
    *
    * @return An enumeration of the composite elements
    *         (attributeName, syntaxId, and value.length).
    */
   public Enumeration getValues ()
   {
      Vector values = new Vector ();

      values.addElement (new NdsString (compositeIds[0], attributeName));
      values.addElement (new NdsInteger (compositeIds[1], syntaxId));
      values.addElement (new NdsInteger (compositeIds[2], value.length));
/*
      values.addElement (new SchemaElement (
                                    compositeIds[2],
                                    address.clone (),
                                    "byte[]"));
*/
      return (values.elements ());
   }


   // ******************** NdsAttributeValue Interface ********************

  /**
   * Compares two Objects using the approximate matching rule.
   * 
   * The approximate method does not apply to the Unknown syntax
   * because this syntax does not support the approximate equals
   * matching rule.
   */
   public boolean approximate (
         Object anObject)
      throws Exception
   {
      throw (new Exception ());
   }

  /**
   * Returns the int that represents the NDS syntax ID.
   *
   * @return The syntax ID as an int.
   */
   public int getNdsSyntaxId ()
   {
      return (NdsSyntaxId.UNKNOWN_ID);
   }

  /**
   * Checks to see if this object supports the specified
   * matching rules. The Unknown syntax does not supports any
   * of the matching rules.
   *
   * @param matchingRules The set of matching rules to check.
   *
   * @return A Boolean set to TRUE if the matching rules for this
   *         object are equal to the matchingRules parameter.
   */
   public boolean supportsMatchingRules (
         int matchingRules)
   {
      if ((matchingRules & this.matchingRules) == matchingRules)
      {
         return (true);
      }
      return (false);
   }


   // ******************** Object Class ********************

  /**
   * Creates a new object of the same class as this object. It
   * then initializes each of the new object's fields by assigning
   * them the same value as the corresponding fields in this object.
   * No constructor is called.
   *
   * @return A clone of this object instance containing the cloned
   *         syntax.
   */
   public Object clone ()
   {
      try
      {
         NdsUnknown unknown = (NdsUnknown) super.clone ();

         unknown.attributeName = this.attributeName;
         unknown.syntaxId = this.syntaxId;
         unknown.value = (byte[]) this.value.clone ();

         unknown.name = this.name;

         return (unknown);
      }
      catch (CloneNotSupportedException e)
      {
         // this shouldn't happen, since we are Cloneable
         throw (new InternalError ());
      }

   } /* clone () */

  /**
   * Generates a string representation of the object. It
   * returns a string that textually represents the object.
   * The result should be a concise but informative
   * representation that is easy to read.
   *
   * @return The String representation of the object.
   */
   public String toString ()
   {
      return (
         attributeName + ";" +
         String.valueOf (syntaxId) + ";" +
         String.valueOf (value.length) + ";"
         );
   }


   // ******************** NdsUnknown Class ********************

  /**
   * Returns the attribute name stored as a String value in
   * the object data member.
   * 
   * @return The attribute name as a String value.
   */
   public String getAttributeName ()
   {
      return (attributeName);
   }

  /**
   * Returns the attribute syntax ID stored as an int value
   * in the object data member.
   * 
   * @return The attribute syntax ID as an int value.
   */
   public int getAttributeSyntaxId ()
   {
      return (syntaxId);
   }

  /**
   * Returns the value length stored as an int value in the
   * object data member.
   * 
   * @return The value length as an int value.
   */
   public int getValueLength ()
   {
      return (value.length);
   }

  /**
   * Returns the value stored as a byte array in the
   * object data member.
   * 
   * @return The byte array of values.
   */
   public byte[] getValue ()
   {
      return (value);
   }

} /* NdsUnknown */

