
/* **************************************************************************

  $Archive: /njcl_v2rmi/src/com/novell/service/nds/SchemaAttribute.java $
  $Revision: 12 $
  $Modtime: 1/05/01 3:59p $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.service.nds;


import com.novell.service.jncpv2r.net.NetJNI;


/**
 * Defines the attribute types and constraints (flags).
 *
 * <p> Each attribute may have one or more constraints (attribute
 * flags) that restrict the attribute value. An attribute definition
 * includes:
 * <ul>
 * <li> Syntax ID - An integer used to identify attribute values.
 * <li> Lower Limit - The lower limit value for the attribute.
 * <li> Upper Limit - The upper limit value for the attribute.
 * <li> ASN1Name - The unique identifier for the attribute definition.
 * </ul>
 */
public interface SchemaAttribute
{
  /**
   * Represents the flags attribute ID for attribute definitions.
   * The flags attribute constant contains a value that is a
   * combination of the following constraints that restrict the
   * attribute value:
   * <ul><li>DS_HIDDEN_ATTR
   * <li>DS_NONREMOVABLE_ATTR
   * <li>DS_READ_ONLY_ATTR
   * <li>DS_PUBLIC_READ
   * <li>DS_SERVER_READ
   * <li>DS_PER_REPLICA
   * <li>DS_SYNC_IMMEDIATE
   * <li>DS_STRING_ATTR
   * <li>DS_SIZED_ATTR
   * <li>DS_SINGLE_VALUED_ATTR
   * <li)DS_WRITE_MANAGED
   * </ul>
   *
   * <p>(ATTR_FLAGS = "Flags")</p>
   */
   public static final String ATTR_FLAGS = "Flags";

  /**
   * An integer used to identify attribute values.
   *
   * <p>This is a String constant for attribute names.
   *
   * <p>(ATTR_SYNTAX_ID = "Syntax ID")
   */
   public static final String ATTR_SYNTAX_ID = "Syntax ID";

  /**
   * The lower limit for the attribute value.
   *
   * <p>This is a String constant for attribute names, and
   * is only valid when the SIZED flag is set.
   *
   * <p>(ATTR_LOWER_LIMIT = "Lower Limit")
   */
   public static final String ATTR_LOWER_LIMIT = "Lower Limit";

  /**
   * The upper limit for the attribute value.
   *
   * <p>This is a String constant for attribute names, and
   * is only valid when the SIZED flag is set.
   *
   * <p>(ATTR_UPPER_LIMIT = "Upper Limit")
   */
   public static final String ATTR_UPPER_LIMIT = "Upper Limit";

  /**
   * The unique identifier for the class definition based on the 
   * international standard for representing data types and
   * structures.
   *
   * <p>The ASN.1 name, which is a String constant for attribute
   * names provides a machine-independent syntax for specifying
   * application layer protocols and information on open systems.
   *
   * <p>(ATTR_ASN1NAME = "ASN1Name")
   */
   public static final String ATTR_ASN1NAME = "ASN1Name";

   // Values stored in the Flags attribute
  /**
   * Constant that constrains the attribute to a single value
   * only with no order implied.
   *
   * <p>(DS_SINGLE_VALUED_ATTR = NetJNI.DS_SINGLE_VALUED_ATTR)
   */
   public final static int  DS_SINGLE_VALUED_ATTR =
                                 NetJNI.DS_SINGLE_VALUED_ATTR;

  /**
   * Constant that constrains the attribute to an upper and a
   * lower bound.
   * <p> This can be the length for strings or the value 
   * for integers.
   *
   * <p>(DS_SIZED_ATTR = NetJNI.DS_SIZED_ATTR)
   */
   public final static int  DS_SIZED_ATTR =
                                 NetJNI.DS_SIZED_ATTR;

  /**
   * Constant that constrains the attribute from being removed
   * from an object class definition.
   * <p>The client cannot set or modify this constraint flag,
   * and thus cannot modify the attribute.
   *
   * <p>(DS_NONREMOVABLE_ATTR = NetJNI.DS_NONREMOVABLE_ATTR)
   */
   public final static int  DS_NONREMOVABLE_ATTR =
                                 NetJNI.DS_NONREMOVABLE_ATTR;

  /**
   * Constant that constrains the user from modifying the attribute
   * because a name server has created the attribute and must maintain
   * it.
   *
   * <p>(DS_READ_ONLY_ATTR = NetJNI.DS_READ_ONLY_ATTR)
   */
   public final static int  DS_READ_ONLY_ATTR =
                                 NetJNI.DS_READ_ONLY_ATTR;

  /**
   * Constant that constrains the client from modifying the attribute
   * because it is for NDS server use only.
   * <p>The client cannot set or modify this constraint flag, and
   * thus cannot see or modify the attribute.
   *
   * <p>(DS_HIDDEN_ATTR = NetJNI.DS_HIDDEN_ATTR)
   */
   public final static int  DS_HIDDEN_ATTR =
                                 NetJNI.DS_HIDDEN_ATTR;

  /**
   * Constant that constrains the attribute to a String type so it
   * can be used as a naming attribute.
   *
   * <p>(DS_STRING_ATTR = NetJNI.DS_STRING_ATTR)
   */
   public final static int  DS_STRING_ATTR =
                                 NetJNI.DS_STRING_ATTR;

  /**
   * Constant that constrains the synchronization of modifications
   * to an attribute with other replicas containing the object to
   * take place immediately rather than at the next synchronization
   * interval.
   *
   * <p>(DS_SYNC_IMMEDIATE = NetJNI.DS_SYNC_IMMEDIATE)
   */
   public final static int  DS_SYNC_IMMEDIATE =
                                 NetJNI.DS_SYNC_IMMEDIATE;

  /**
   * Constant that places a constraint on the attribute so that
   * anyone can read the attribute without read privileges being 
   * assigned.
   * <p>With this constraint set, inheritance masks cannot be used
   * to prevent an object from reading attributes.
   *
   * <p>(DS_PUBLIC_READ = NetJNI.DS_PUBLIC_READ)
   */
   public final static int  DS_PUBLIC_READ =
                                 NetJNI.DS_PUBLIC_READ;

  /**
   * Constant that constrains the attribute so that the Server class
   * objects can read the attribute even though the privilege to read
   * has not been inherited or explicitly granted.
   * <p>Inheritance masks cannot be used to restrict servers from
   * reading attributes with this constraint set. The client cannot 
   * set or modify this constraint flag, and thus cannot modify the
   * attribute.
   *
   * <p>(DS_SERVER_READ = NetJNI.DS_SERVER_READ)
   */
   public final static int  DS_SERVER_READ =
                                 NetJNI.DS_SERVER_READ;

  /**
   * Constant that constrains the users so that they must have
   * managed rights on the object that contains the attribute
   * before changing the attribute's value.
   *
   * <p>(DS_WRITE_MANAGED = NetJNI.DS_WRITE_MANAGED)
   */
   public final static int  DS_WRITE_MANAGED =
                                 NetJNI.DS_WRITE_MANAGED;

  /**
   * Constant that constrains the attribute so that attribute information
   * is not synchronized on other  replicas.
   * <p>The client cannot set or modify this constraint flag, and
   * thus cannot modify the attribute.
   *
   * <p>(DS_PER_REPLICA = NetJNI.DS_PER_REPLICA)
   */
   public final static int  DS_PER_REPLICA =
                                 NetJNI.DS_PER_REPLICA;

} /* SchemaAttribute */


