/* **************************************************************************

  $Archive: /njcl_v2rmi/src/com/novell/service/nds/ldap/LdapNumericString.java $
  $Revision: 4 $
  $Modtime: 11/15/00 3:43p $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/
package com.novell.service.nds.ldap;

import com.novell.service.nds.*;

/**
@internal
LdapNumericString is an Adapter for NdsNumericString.
*/
public final class LdapNumericString
   extends NdsNumericString
   implements LdapAttributeValue
{

   /**
   * Constructs an LdapNumericString adapter for an NdsNumericString.
   *
   * @param   value     Ldap string representation of NumericString.
   */
   protected LdapNumericString (
         String value)
   {
      this.value = new String(value);
   }

   /**
   * Constructs an LdapNumericString adapter for an NdsNumericString.
   *
   * @param   value     an NdsNumericString object.
   */
   protected LdapNumericString (NdsNumericString value)
   {
      super (value);
   }

   /**
   * Returns an Ldap string representation of NumericString.
   *
   * @return   String containing Ldap string representation of NumericString.
   */
   public String toString ()
   {
      return this.value;
   }
}

