/* **************************************************************************

  $Archive: /njcl_v2rmi/src/com/novell/service/nds/ldap/LdapOctetString.java $
  $Revision: 4 $
  $Modtime: 11/15/00 3:43p $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/
package com.novell.service.nds.ldap;

import com.novell.service.nds.*;

/**
@internal
LdapOctetString is an Adapter for NdsOctetString.
*/
public final class LdapOctetString
   extends NdsOctetString
   implements LdapAttributeValue
{

   /**
   * Constructs an LdapOctetString adapter for an NdsOctetString.
   *
   * @param   value     Ldap string representation of OctetString.
   */
   protected LdapOctetString (
         String value)
      throws Exception
   {
      super (value.getBytes ());
   }

   /**
   * Constructs an LdapOctetString adapter for an NdsOctetString.
   *
   * @param   value     an NdsOctetString object.
   */
   protected LdapOctetString (NdsOctetString value)
   {
      super (value);
   }

   /**
   * Returns an Ldap string representation of OctetString.
   *
   * @return   String containing Ldap string representation of OctetString.
   */
   public String toString ()
   {
      return null;
   }
}

