/* **************************************************************************

  $Archive: /njcl_v2rmi/src/com/novell/service/nds/naming/NdsNamingExceptionFactory.java $
  $Revision: 13 $
  $Modtime: 11/15/00 3:43p $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.service.nds.naming;


import javax.naming.*;
import javax.naming.directory.*;

import com.novell.service.jncp.*;


/** @internal
 *
 */
public class NdsNamingExceptionFactory
{
   /* 
   Naming Exceptions:

     1  AuthenticationException 
     2  AuthenticationNotSupportedException 
     3  CannotProceedException 
     4  CommunicationException 
     5  ConfigurationException 
     6  ContextNotEmptyException 
     7  InsufficientResourcesException 
     8  InterruptedNamingException 
     9  InvalidNameException 
     10 LimitExceededException 
     11 LinkException 
     12 LinkLoopException 
     13 MalformedLinkException 
     14 NameAlreadyBoundException 
     15 NameNotFoundException 
     16 NamingException 
     17 NamingSecurityException 
     18 NoInitialContextException 
     19 NoPermissionException 
     20 NotContextException 
     21 OperationNotSupportedException 
     22 PartialResultException 
     23 ReferralException 
     24 ServiceUnavailableException 
     25 SizeLimitExceededException 
     26 TimeLimitExceededException 

   Directory Exceptions:

     27 AttributeInUseException
     28 AttributeModificationException
     29 InvalidAttributeIdentifierException
     30 InvalidAttributeValueException
     31 InvalidAttributesException
     32 InvalidSearchControlsException
     33 InvalidSearchFilterException
     34 NoSuchAttributeException
     35 SchemaViolationException

   Suggested Exceptions to add:
        PartitionViolationException
        SynchronizationException (schema, replica)
        TimeStampException

   Native Errors:

      -001 to -255 are OS Errors returned through directory services

      DSERR_INSUFFICIENT_SPACE         -001  InsufficientResourcesException
      DSERR_BUFFER_TOO_SMALL           -119  LimitExceededException
      DSERR_VOLUME_FLAG_NOT_SET        -120
      DSERR_NO_ITEMS_FOUND             -121
      DSERR_CONN_ALREADY_TEMPORARY     -122
      DSERR_CONN_ALREADY_LOGGED_IN     -123
      DSERR_CONN_NOT_AUTHENTICATED     -124
      DSERR_CONN_NOT_LOGGED_IN         -125
      DSERR_NCP_BOUNDARY_CHECK_FAILED  -126
      DSERR_LOCK_WAITING               -127
      DSERR_LOCK_FAIL                  -128
      DSERR_OUT_OF_HANDLES             -129
      DSERR_NO_OPEN_PRIVILEGE          -130
      DSERR_HARD_IO_ERROR              -131
      DSERR_NO_CREATE_PRIVILEGE        -132
      DSERR_NO_CREATE_DELETE_PRIV      -133
      DSERR_R_O_CREATE_FILE            -134
      DSERR_CREATE_FILE_INVALID_NAME   -135
      DSERR_INVALID_FILE_HANDLE        -136
      DSERR_NO_SEARCH_PRIVILEGE        -137  NoPermissionException
      DSERR_NO_DELETE_PRIVILEGE        -138  NoPermissionException
      DSERR_NO_RENAME_PRIVILEGE        -139  NoPermissionException
      DSERR_NO_SET_PRIVILEGE           -140  NoPermissionException
      DSERR_SOME_FILES_IN_USE          -141
      DSERR_ALL_FILES_IN_USE           -142
      DSERR_SOME_READ_ONLY             -143
      DSERR_ALL_READ_ONLY              -144
      DSERR_SOME_NAMES_EXIST           -145
      DSERR_ALL_NAMES_EXIST            -146
      DSERR_NO_READ_PRIVILEGE          -147  NoPermissionException
      DSERR_NO_WRITE_PRIVILEGE         -148  NoPermissionException
      DSERR_FILE_DETACHED              -149
      DSERR_NO_ALLOC_SPACE             -150
      DSERR_TARGET_NOT_A_SUBDIR        -150
      DSERR_NO_SPOOL_SPACE             -151
      DSERR_INVALID_VOLUME             -152
      DSERR_DIRECTORY_FULL             -153
      DSERR_RENAME_ACROSS_VOLUME       -154
      DSERR_BAD_DIR_HANDLE             -155
      DSERR_INVALID_PATH               -156
      DSERR_NO_SUCH_EXTENSION          -156
      DSERR_NO_DIR_HANDLES             -157
      DSERR_BAD_FILE_NAME              -158
      DSERR_DIRECTORY_ACTIVE           -159
      DSERR_DIRECTORY_NOT_EMPTY        -160
      DSERR_DIRECTORY_IO_ERROR         -161
      DSERR_IO_LOCKED                  -162
      DSERR_TRANSACTION_RESTARTED      -163
      DSERR_RENAME_DIR_INVALID         -164
      DSERR_INVALID_OPENCREATE_MODE    -165
      DSERR_ALREADY_IN_USE             -166
      DSERR_INVALID_RESOURCE_TAG       -167
      DSERR_ACCESS_DENIED              -168  NoPermissionException
      DSERR_INVALID_DATA_STREAM        -190
      DSERR_INVALID_NAME_SPACE         -191
      DSERR_NO_ACCOUNTING_PRIVILEGES   -192  NoPermissionException
      DSERR_NO_ACCOUNT_BALANCE         -193
      DSERR_CREDIT_LIMIT_EXCEEDED      -194
      DSERR_TOO_MANY_HOLDS             -195
      DSERR_ACCOUNTING_DISABLED        -196
      DSERR_LOGIN_LOCKOUT              -197
      DSERR_NO_CONSOLE_RIGHTS          -198
      DSERR_Q_IO_FAILURE               -208
      DSERR_NO_QUEUE                   -209
      DSERR_NO_Q_SERVER                -210
      DSERR_NO_Q_RIGHTS                -211  NoPermissionException
      DSERR_Q_FULL                     -212
      DSERR_NO_Q_JOB                   -213
      DSERR_NO_Q_JOB_RIGHTS            -214  NoPermissionException
      DSERR_UNENCRYPTED_NOT_ALLOWED    -214
      DSERR_Q_IN_SERVICE               -215
      DSERR_DUPLICATE_PASSWORD         -215
      DSERR_Q_NOT_ACTIVE               -216
      DSERR_PASSWORD_TOO_SHORT         -216
      DSERR_Q_STN_NOT_SERVER           -217
      DSERR_MAXIMUM_LOGINS_EXCEEDED    -217
      DSERR_Q_HALTED                   -218
      DSERR_BAD_LOGIN_TIME             -218
      DSERR_Q_MAX_SERVERS              -219
      DSERR_NODE_ADDRESS_VIOLATION     -219
      DSERR_LOG_ACCOUNT_EXPIRED        -220
      DSERR_BAD_PASSWORD               -222
      DSERR_PASSWORD_EXPIRED           -223
      DSERR_NO_LOGIN_CONN_AVAILABLE    -224
      DSERR_WRITE_TO_GROUP_PROPERTY    -232
      DSERR_MEMBER_ALREADY_EXISTS      -233
      DSERR_NO_SUCH_MEMBER             -234
      DSERR_PROPERTY_NOT_GROUP         -235
      DSERR_NO_SUCH_VALUE_SET          -236
      DSERR_PROPERTY_ALREADY_EXISTS    -237
      DSERR_OBJECT_ALREADY_EXISTS      -238
      DSERR_ILLEGAL_NAME               -239
      DSERR_ILLEGAL_WILDCARD           -240
      DSERR_BINDERY_SECURITY           -241
      DSERR_NO_OBJECT_READ_RIGHTS      -242  NoPermissionException
      DSERR_NO_OBJECT_RENAME_RIGHTS    -243  NoPermissionException
      DSERR_NO_OBJECT_DELETE_RIGHTS    -244  NoPermissionException
      DSERR_NO_OBJECT_CREATE_RIGHTS    -245  NoPermissionException
      DSERR_NO_PROPERTY_DELETE_RIGHTS  -246  NoPermissionException
      DSERR_NO_PROPERTY_CREATE_RIGHTS  -247  NoPermissionException
      DSERR_NO_PROPERTY_WRITE_RIGHTS   -248  NoPermissionException
      DSERR_NO_PROPERTY_READ_RIGHTS    -249  NoPermissionException
      DSERR_TEMP_REMAP                 -250
      DSERR_UNKNOWN_REQUEST            -251
      DSERR_NO_SUCH_PROPERTY           -251
      DSERR_MESSAGE_QUEUE_FULL         -252
      DSERR_TARGET_ALREADY_HAS_MSG     -252
      DSERR_NO_SUCH_OBJECT             -252
      DSERR_BAD_STATION_NUMBER         -253
      DSERR_BINDERY_LOCKED             -254
      DSERR_DIR_LOCKED                 -254
      DSERR_SPOOL_DELETE               -254
      DSERR_TRUSTEE_NOT_FOUND          -254
      DSERR_HARD_FAILURE               -255
      DSERR_FILE_NAME                  -255
      DSERR_FILE_EXISTS                -255
      DSERR_CLOSE_FCB                  -255
      DSERR_IO_BOUND                   -255
      DSERR_NO_SPOOL_FILE              -255
      DSERR_BAD_SPOOL_PRINTER          -255
      DSERR_BAD_PARAMETER              -255
      DSERR_NO_FILES_FOUND             -255
      DSERR_NO_TRUSTEE_CHANGE_PRIV     -255
      DSERR_TARGET_NOT_LOGGED_IN       -255
      DSERR_TARGET_NOT_ACCEPTING_MSGS  -255
      DSERR_MUST_FORCE_DOWN            -255


    errors from the file system, IPX, NCP, and other OS services are one byte
    and are mapped to -1 to -256 when returned as a directory services error

      ERR_INSUFFICIENT_MEMORY          -150  InsufficientResourcesException
      ERR_REQUEST_UNKNOWN              -251
      ERR_OF_SOME_SORT                 -255

   -301 to -399 are returned by the directory services client library

      ERR_NOT_ENOUGH_MEMORY            -301
      ERR_BAD_KEY                      -302
      ERR_BAD_CONTEXT                  -303
      ERR_BUFFER_FULL                  -304
      ERR_LIST_EMPTY                   -305
      ERR_BAD_SYNTAX                   -306
      ERR_BUFFER_EMPTY                 -307
      ERR_BAD_VERB                     -308
      ERR_EXPECTED_IDENTIFIER          -309
      ERR_EXPECTED_EQUALS              -310
      ERR_ATTR_TYPE_EXPECTED           -311
      ERR_ATTR_TYPE_NOT_EXPECTED       -312
      ERR_FILTER_TREE_EMPTY            -313
      ERR_INVALID_OBJECT_NAME          -314
      ERR_EXPECTED_RDN_DELIMITER       -315
      ERR_TOO_MANY_TOKENS              -316
      ERR_INCONSISTENT_MULTIAVA        -317
      ERR_COUNTRY_NAME_TOO_LONG        -318
      ERR_SYSTEM_ERROR                 -319
      ERR_CANT_ADD_ROOT                -320
      ERR_UNABLE_TO_ATTACH             -321
      ERR_INVALID_HANDLE               -322
      ERR_BUFFER_ZERO_LENGTH           -323
      ERR_INVALID_REPLICA_TYPE         -324
      ERR_INVALID_ATTR_SYNTAX          -325
      ERR_INVALID_FILTER_SYNTAX        -326
      ERR_CONTEXT_CREATION             -328
      ERR_INVALID_UNION_TAG            -329
      ERR_INVALID_SERVER_RESPONSE      -330
      ERR_NULL_POINTER                 -331
      ERR_NO_SERVER_FOUND              -332
      ERR_NO_CONNECTION                -333
      ERR_RDN_TOO_LONG                 -334
      ERR_DUPLICATE_TYPE               -335
      ERR_DATA_STORE_FAILURE           -336
      ERR_NOT_LOGGED_IN                -337
      ERR_INVALID_PASSWORD_CHARS       -338
      ERR_FAILED_SERVER_AUTHENT        -339
      ERR_TRANSPORT                    -340
      ERR_NO_SUCH_SYNTAX               -341
      ERR_INVALID_DS_NAME              -342
      ERR_ATTR_NAME_TOO_LONG           -343
      ERR_INVALID_TDS                  -344
      ERR_INVALID_DS_VERSION           -345
      ERR_UNICODE_TRANSLATION          -346
      ERR_SCHEMA_NAME_TOO_LONG         -347
      ERR_UNICODE_FILE_NOT_FOUND       -348
      ERR_UNICODE_ALREADY_LOADED       -349
      ERR_NOT_CONTEXT_OWNER            -350
      ERR_ATTEMPT_TO_AUTHENTICATE_0    -351
      ERR_NO_WRITABLE_REPLICAS         -352
      ERR_DN_TOO_LONG                  -353  InvalidNameException
      ERR_RENAME_NOT_ALLOWED           -354

      -601 to -699 are returned by the directory services agent in the server 

      ERR_NO_SUCH_ENTRY                -601  NameNotFoundException
      ERR_NO_SUCH_VALUE                -602  InvalidAttributeValueException 
      ERR_NO_SUCH_ATTRIBUTE            -603  NoSuchAttributeException
      ERR_NO_SUCH_CLASS                -604  NameNotFoundException
      ERR_NO_SUCH_PARTITION            -605
      ERR_ENTRY_ALREADY_EXISTS         -606  NameAlreadyBoundException
      ERR_NOT_EFFECTIVE_CLASS          -607
      ERR_ILLEGAL_ATTRIBUTE            -608  InvalidAttributesException
      ERR_MISSING_MANDATORY            -609  InvalidAttributesException
      ERR_ILLEGAL_DS_NAME              -610  InvalidNameException 
      ERR_ILLEGAL_CONTAINMENT          -611  InvalidNameException
!     ERR_CANT_HAVE_MULTIPLE_VALUES    -612  InvalidAttributeValueException
!     ERR_SYNTAX_VIOLATION             -613  InvalidAttributeValueException
      ERR_DUPLICATE_VALUE              -614  InvalidAttributesException
!     ERR_ATTRIBUTE_ALREADY_EXISTS     -615  AttributeInUseException
!     ERR_MAXIMUM_ENTRIES_EXIST        -616  LimitExceededException
      ERR_DATABASE_FORMAT              -617
      ERR_INCONSISTENT_DATABASE        -618
      ERR_INVALID_COMPARISON           -619
      ERR_COMPARISON_FAILED            -620
      ERR_TRANSACTIONS_DISABLED        -621  ServiceUnavailableException
      ERR_INVALID_TRANSPORT            -622  CommunicationException 
!     ERR_SYNTAX_INVALID_IN_NAME       -623  InvalidNameException
      ERR_REPLICA_ALREADY_EXISTS       -624  NameAlreadyBoundException
!     ERR_TRANSPORT_FAILURE            -625  CommunicationException 
      ERR_ALL_REFERRALS_FAILED         -626  NameNotFoundException 
      ERR_CANT_REMOVE_NAMING_VALUE     -627  AttributeModificationException
      ERR_OBJECT_CLASS_VIOLATION       -628  SchemaViolationException
      ERR_ENTRY_IS_NOT_LEAF            -629  ContextNotEmptyException 
      ERR_DIFFERENT_TREE               -630
      ERR_ILLEGAL_REPLICA_TYPE         -631
      ERR_SYSTEM_FAILURE               -632  ServiceUnavailableException
      ERR_INVALID_ENTRY_FOR_ROOT       -633
      ERR_NO_REFERRALS                 -634  NameNotFoundException 
      ERR_REMOTE_FAILURE               -635  CommunicationException
      ERR_UNREACHABLE_SERVER           -636
      ERR_PREVIOUS_MOVE_IN_PROGRESS    -637
      ERR_NO_CHARACTER_MAPPING         -638
      ERR_INCOMPLETE_AUTHENTICATION    -639  AuthenticationException
      ERR_INVALID_CERTIFICATE          -640
      ERR_INVALID_REQUEST              -641
      ERR_INVALID_ITERATION            -642
      ERR_SCHEMA_IS_NONREMOVABLE       -643  SchemaViolationException
      ERR_SCHEMA_IS_IN_USE             -644  SchemaViolationException
      ERR_CLASS_ALREADY_EXISTS         -645  NameAlreadyBoundException
      ERR_BAD_NAMING_ATTRIBUTES        -646
      ERR_NOT_ROOT_PARTITION           -647
      ERR_INSUFFICIENT_STACK           -648  InsufficientResourcesException
      ERR_INSUFFICIENT_BUFFER          -649  SizeLimitExceededException
      ERR_AMBIGUOUS_CONTAINMENT        -650
      ERR_AMBIGUOUS_NAMING             -651
      ERR_DUPLICATE_MANDATORY          -652  SchemaViolationException
      ERR_DUPLICATE_OPTIONAL           -653  SchemaViolationException
      ERR_PARTITION_BUSY               -654
      ERR_MULTIPLE_REPLICAS            -655
      ERR_CRUCIAL_REPLICA              -656
      ERR_SCHEMA_SYNC_IN_PROGRESS      -657
      ERR_SKULK_IN_PROGRESS            -658
?     ERR_TIME_NOT_SYNCHRONIZED        -659  TimeStampException
      ERR_RECORD_IN_USE                -660
      ERR_DS_VOLUME_NOT_MOUNTED        -661
      ERR_DS_VOLUME_IO_FAILURE         -662
      ERR_DS_LOCKED                    -663
?     ERR_OLD_EPOCH                    -664  TimeStampException
?     ERR_NEW_EPOCH                    -665  TimeStampException
      ERR_INCOMPATIBLE_DS_VERSION      -666
      ERR_PARTITION_ROOT               -667
      ERR_ENTRY_NOT_CONTAINER          -668
      ERR_FAILED_AUTHENTICATION        -669  AuthenticationException
      ERR_INVALID_CONTEXT              -670
      ERR_NO_SUCH_PARENT               -671
      ERR_NO_ACCESS                    -672  NoPermissionException 
      ERR_REPLICA_NOT_ON               -673
      ERR_INVALID_NAME_SERVICE         -674
      ERR_INVALID_TASK                 -675
      ERR_INVALID_CONN_HANDLE          -676
      ERR_INVALID_IDENTITY             -677
      ERR_DUPLICATE_ACL                -678
      ERR_PARTITION_ALREADY_EXISTS     -679  NameAlreadyBoundException
      ERR_TRANSPORT_MODIFIED           -680
      ERR_ALIAS_OF_AN_ALIAS            -681
      ERR_AUDITING_FAILED              -682
      ERR_INVALID_API_VERSION          -683
      ERR_SECURE_NCP_VIOLATION         -684
      ERR_MOVE_IN_PROGRESS             -685
      ERR_NOT_LEAF_PARTITION           -686
      ERR_CANNOT_ABORT                 -687
      ERR_CACHE_OVERFLOW               -688
      ERR_INVALID_SUBORDINATE_COUNT    -689
      ERR_INVALID_RDN                  -690
      ERR_MOD_TIME_NOT_CURRENT         -691
      ERR_INCORRECT_BASE_CLASS         -692
      ERR_MISSING_REFERENCE            -693
      ERR_LOST_ENTRY                   -694
      ERR_AGENT_ALREADY_REGISTERED     -695
      ERR_DS_LOADER_BUSY               -696
      ERR_DS_CANNOT_RELOAD             -697
      ERR_REPLICA_IN_SKULK             -698
      ERR_FATAL                        -699
      ERR_OBSOLETE_API                 -700
      ERR_SYNCHRONIZATION_DISABLED     -701
      ERR_INVALID_PARAMETER            -702
      ERR_DUPLICATE_TEMPLATE           -703
      ERR_NO_MASTER_REPLICA            -704
      ERR_DUPLICATE_CONTAINMENT        -705
      ERR_NOT_SIBLING                  -706
      ERR_INVALID_SIGNATURE            -707
      ERR_INVALID_RESPONSE             -708
      ERR_INSUFFICIENT_SOCKETS         -709
      ERR_DATABASE_READ_FAIL           -710
      ERR_INVALID_CODE_PAGE            -711
      ERR_INVALID_ESCAPE_CHAR          -712
      ERR_INVALID_DELIMITERS           -713
      ERR_NOT_IMPLEMENTED              -714
      ERR_CHECKSUM_FAILURE             -715
      ERR_CHECKSUMMING_NOT_SUPPORTED   -716
      ERR_CRC_FAILURE                  -717

   */
   
   public NdsNamingExceptionFactory ()
   {
   }

   /**
    *
    */
   public NamingException getNamingException (
      NSIException nsiException)
   {
      int ccode = nsiException.getCCode ();
      NamingException ne;

      // map NDS error to appropriate Naming Exception
      // NOTE: all fall throughs are intentional
      switch (ccode)
      {
         // Naming Exceptions
         case NDSErrors.ERR_FAILED_AUTHENTICATION:
         case NDSErrors.ERR_FAILED_SERVER_AUTHENT:
         case NDSErrors.ERR_INCOMPLETE_AUTHENTICATION:
            ne = new AuthenticationException (); 
            break;
         case NDSErrors.ERR_ATTEMPT_TO_AUTHENTICATE_0:
            ne = new AuthenticationNotSupportedException (); 
            break;
         case NDSErrors.ERR_INVALID_TRANSPORT:
         case NDSErrors.ERR_TRANSPORT_FAILURE:
            ne = new CommunicationException (); 
            break;
         case NDSErrors.ERR_ENTRY_IS_NOT_LEAF:
            ne = new ContextNotEmptyException (); 
            break;
         case NDSErrors.ERR_INSUFFICIENT_MEMORY:
         case NDSErrors.ERR_INSUFFICIENT_STACK:
         case NDSErrors.ERR_NOT_ENOUGH_MEMORY:
            ne = new InsufficientResourcesException ();
            break;
         case NDSErrors.ERR_CANT_HAVE_MULTIPLE_VALUES:
         case NDSErrors.ERR_SYNTAX_VIOLATION:
            ne = new InvalidAttributeValueException ();
            break;
         case NDSErrors.ERR_DUPLICATE_VALUE:
         case NDSErrors.ERR_ILLEGAL_ATTRIBUTE:
         case NDSErrors.ERR_MISSING_MANDATORY:
            ne = new InvalidAttributesException ();
            break;
         case NDSErrors.ERR_DN_TOO_LONG:
         case NDSErrors.ERR_ILLEGAL_DS_NAME:
         case NDSErrors.ERR_ILLEGAL_CONTAINMENT:
         case NDSErrors.ERR_SYNTAX_INVALID_IN_NAME: 
            ne = new InvalidNameException ();
            break;
         case NDSErrors.ERR_CLASS_ALREADY_EXISTS:
         case NDSErrors.ERR_ENTRY_ALREADY_EXISTS:
         case NDSErrors.ERR_PARTITION_ALREADY_EXISTS:
            ne = new NameAlreadyBoundException ();
            break;
         case NDSErrors.ERR_NO_SUCH_CLASS:
         case NDSErrors.ERR_NO_SUCH_ENTRY:
         case NDSErrors.ERR_ALL_REFERRALS_FAILED:
         case NDSErrors.ERR_NO_REFERRALS:
            ne = new NameNotFoundException ();
            break;
         case NDSErrors.ERR_NO_ACCESS:
            ne = new NoPermissionException ();
            break;
         case NDSErrors.ERR_INSUFFICIENT_BUFFER:
            ne = new SizeLimitExceededException ();
            break;
         case NDSErrors.ERR_OF_SOME_SORT:
            ne = new NamingException ();
            break;
         default:
            ne = new NamingException ();
      } // switch

      ne.setRootCause (nsiException);
      return ne;
   } // getNamingException

} // NdsNamingExceptionFactory


