
/* **************************************************************************

  $Archive: /njcl_v2rmi/src/com/novell/service/nds/naming/NdsPartitionNameParser.java $
  $Revision: 5 $
  $Modtime: 11/15/00 3:43p $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.service.nds.naming;


import java.util.*;

import javax.naming.*;

import com.novell.utility.naming.Syntax;


/** @internal
 * Name parser for Partition name space
 */
public class NdsPartitionNameParser
   implements NameParser, NdsPartitionStrings
{
   private static Properties syntax = new Properties();

   static
   {
      syntax.put (Syntax.DIRECTION, PARTITION_SYNTAX_DIRECTION);
      syntax.put (Syntax.SEPARATOR, PARTITION_SYNTAX_SEPARATOR);
      syntax.put (Syntax.ESCAPE, PARTITION_SYNTAX_ESCAPE);
      syntax.put (Syntax.BEGIN_QUOTE, PARTITION_SYNTAX_BEGIN_QUOTE);
      syntax.put (Syntax.BEGIN_QUOTE2, PARTITION_SYNTAX_BEGIN_QUOTE2);
   }

   /**
    * constructs a Partition name space parser with direction =
    * PARTITION_SYNTAX_DIRECTION, separator = PARTITION_SYNTAX_SEPARATOR,
    * escape = PARTITION_SYNTAX_ESCAPE,
    * beginquote = PARTITION_SYNTAX_BEGIN_QUOTE,
    * beginquote2 = PARTITION_SYNTAX_BEGIN_QUOTE2
    */
   public NdsPartitionNameParser ()
   {

   }

   public Name parse (
         String name)
      throws NamingException
   {
      return new CompoundName (name, syntax);
   }

} /* NdsPartitionNameParser */