
/* **************************************************************************

  $Archive: /njcl_v2rmi/src/com/novell/service/nds/naming/NetSyntax.java $
  $Revision: 6 $
  $Modtime: 11/15/00 3:43p $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.service.nds.naming;


import java.util.Properties;

import com.novell.utility.naming.BasicSyntax;


/** @internal
 *
 */
public class NetSyntax extends BasicSyntax
{
   public final static String direction = "right_to_left";
   public final static String separator = ".";
//   public final static String separator2;
   public final static boolean ignoreCase = true;
   public final static boolean trimBlanks = true;
   public final static String escape = "\\";
   public final static String beginQuote = "\"";
   public final static String endQuote = "\"";
//   public final static String syntaxBeginQuote2;
//   public final static String syntaxEndQuote2;
   public final static String separatorAva = "+";
   public final static String separatorTypeval = "=";

   /**
    *
    */
   public NetSyntax ()
   {
      put (DIRECTION, direction);
      put (SEPARATOR, separator);
      put (ESCAPE, escape);
      put (IGNORE_CASE, String.valueOf (ignoreCase));
      put (TRIM_BLANKS, String.valueOf (trimBlanks));
      put (BEGIN_QUOTE, beginQuote);
      put (END_QUOTE, endQuote);
      put (AVA_SEPARATOR, separatorAva);
      put (TYPEVAL_SEPARATOR, separatorTypeval);
   }

   public Properties getProperties ()
   {
      return (this);
   }

   public String getDirection ()
   {
      return (direction);
   }

   public String getSeparator ()
   {
      return (separator);
   }

   public String getSeparator2 ()
   {
      return (null);
   }

   public boolean getIgnoreCase ()
   {
      return (ignoreCase);
   }

   public boolean getTrimBlanks ()
   {
      return (trimBlanks);
   }

   public String getEscape ()
   {
      return (escape);
   }

   public String getBeginQuote ()
   {
      return (beginQuote);
   }

   public String getEndQuote ()
   {
      return (endQuote);
   }

   public String getBeginQuote2 ()
   {
      return (null);
   }

   public String getEndQuote2 ()
   {
      return (null);
   }

   public String getAvaSeparator ()
   {
      return (separatorAva);
   }

   public String getTypevalSeparator ()
   {
      return (separatorTypeval);
   }

} /* NetSyntax */



