
/* **************************************************************************

  $Archive: /njcl_v2rmi/src/com/novell/service/nds/naming/WrapperContextFactoryBuilder.java $
  $Revision: 5 $
  $Modtime: 11/15/00 3:43p $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.service.nds.naming;


import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

import java.util.Hashtable;
import java.util.Properties;

import javax.naming.NamingException;
import javax.naming.spi.ObjectFactory;

import com.novell.utility.naming.Environment;
import com.novell.utility.naming.spi.ContextFactory;
import com.novell.utility.naming.spi.ContextFactoryBuilder;


/** @internal
 *
 */
public class WrapperContextFactoryBuilder implements ContextFactoryBuilder
{
   private static String defaultFactory;
   private static Properties protocolFactories;

   static
   {
      defaultFactory = 
         "com.novell.service.nds.naming.local.NdsContextFactory";
      protocolFactories = new Properties ();

      protocolFactories.put (
               Environment.NCP_PROTOCOL,
               "com.novell.service.nds.naming.local.NdsContextFactory");
      protocolFactories.put (
               Environment.RMI_PROTOCOL,
               "com.novell.service.nds.naming.remote.NdsContextFactory");
   }


   /**
    *
    */
   public WrapperContextFactoryBuilder (NdsEnvironment environment)
   {

   }

   /**
    *
    */
   public ObjectFactory createObjectFactory (
         Object object,
         Hashtable environment)
   {
      try
      {
         return (createContextFactory (
                     object, 
                     new NdsEnvironment (environment)));
      }
      catch (NamingException e)
      {
         return (null);
      }

   } /* createObjectFactory () */

   /**
    *
    */
   public ContextFactory createContextFactory (
         Object object,
         Environment environment)
      throws NamingException
   {
      NdsEnvironment ndsEnvironment = getEnvironmentInstance (environment);

      try
      {
         Class cls;
         Class[] argTypes = new Class [1];
         Constructor ctor;
         Object[] args = new Object [1];

         cls = Class.forName (getClassName (
                                 ndsEnvironment.getTransportProtocol ()));

         argTypes [0] = Class.forName (
            "com.novell.service.nds.naming.NdsEnvironment");
         ctor = cls.getDeclaredConstructor (argTypes);

         args [0] = ndsEnvironment;

         return ((ContextFactory) ctor.newInstance (args));
      }
      catch (ClassNotFoundException e)
      {
         NamingException ne = new NamingException ();

         ne.setRootCause (e);
         throw (ne);
      }
      catch (SecurityException e)
      {
         NamingException ne = new NamingException ();
         ne.setRootCause (e);
         throw (ne);
      }
      catch (NoSuchMethodException e)
      {
         NamingException ne = new NamingException ();
         ne.setRootCause (e);
         throw (ne);
      }
      catch (InstantiationException e)
      {
         NamingException ne = new NamingException ();

         ne.setRootCause (e);
         throw (ne);
      }
      catch (IllegalAccessException e)
      {
         NamingException ne = new NamingException ();

         ne.setRootCause (e);
         throw (ne);
      }
      catch (IllegalArgumentException e)
      {
         NamingException ne = new NamingException ();
         ne.setRootCause (e);
         throw (ne);
      }
      catch (InvocationTargetException e)
      {
         NamingException ne = new NamingException ();
         ne.setRootCause (e);
         throw (ne);
      }

   } /* createContextFactory () */

   /**
    *
    */
   public String getClassName (
         String protocol)
   {
      protocol = protocol.toLowerCase ();
      return (protocolFactories.getProperty (protocol, defaultFactory));

   } /* getClassName () */

   /**
    *
    */
   private NdsEnvironment getEnvironmentInstance (
         Environment environment)
      throws NamingException
   {
      if (environment instanceof NdsEnvironment)
      {
         return ((NdsEnvironment) environment);
      }
      return (new NdsEnvironment (environment));

   } /* getEnvironmentInstance () */

} /* WrapperContextFactoryBuilder */


