
/* **************************************************************************

  $Archive: /njcl_v2rmi/src/com/novell/service/nds/naming/local/PartitionDirContextWrapper.java $
  $Revision: 8 $
  $Modtime: 11/15/00 3:43p $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.service.nds.naming.local;


import java.io.Serializable;

import java.util.NoSuchElementException;

import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.Binding;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;

import com.novell.service.nds.NdsObject;
import com.novell.service.nds.NdsObjectRights;
import com.novell.service.nds.NdsAttributeRights;
import com.novell.service.nds.naming.NdsEnvironment;
import com.novell.service.nds.naming.PartitionDirContextWrappable;
import com.novell.service.nds.naming.NdsNamingEnumeratorWrappable;

import com.novell.service.jncp.NSIException;

import com.novell.utility.naming.ContextWrappable;
import com.novell.utility.naming.directory.DirContextWrapper;
import com.novell.utility.naming.spi.ContextFactory;


/** @internal
 *
 */
public class PartitionDirContextWrapper
   extends DirContextWrapper
   implements /*PartitionObject, */Referenceable, Serializable
{
   protected static ContextFactory factory = new PartitionContextFactory ();

   protected NdsEnvironment environment;

   /**
    *
    */
   protected PartitionDirContextWrapper (
         PartitionDirContextWrappable impl,
         NdsEnvironment environment)
      throws NamingException
   {
      super (impl);

      this.environment = environment;

   } /* NdsDirContext () */


   // ******************** Context Interface ********************

   /**
    *
    */
   public Object lookup (
         Name name)
      throws NamingException
   {
      Object object = ((Context) impl).lookup (name);

      if (object instanceof PartitionDirContextWrappable)
      {
         return (factory.getContextInstance ((Context) object));
      }
      return (object);

   } /* lookup () */

   /**
    *
    */
   public NamingEnumeration list (
         Name name)
      throws NamingException
   {
      NamingEnumeration namingEnumeration = ((Context) impl).list (name);

      if (namingEnumeration instanceof NdsNamingEnumeratorWrappable)
      {
         return (new NdsNameClassEnumerator (namingEnumeration));
      }
      return (namingEnumeration);

   } /* list () */

   /**
    *
    */
   public NamingEnumeration listBindings (
         Name name)
      throws NamingException
   {
      NamingEnumeration namingEnumeration;

      namingEnumeration = ((Context) impl).listBindings (name);

      if (namingEnumeration instanceof NdsNamingEnumeratorWrappable)
      {
         return (new NdsBindingEnumerator (namingEnumeration, environment));
      }
      return (namingEnumeration);

   } /* listBindings () */

   /**
    *
    */
   public Context createSubcontext (
         Name name)
      throws NamingException
   {
      Context context = ((Context) impl).createSubcontext (name);

      if (context instanceof PartitionDirContextWrappable)
      {
         return (factory.getContextInstance (context));
      }
      return (context);

   } /* createSubcontext () */

   /**
    *
    */
   public Object lookupLink (
         Name name)
      throws NamingException
   {
      Object object = ((Context) impl).lookupLink (name);

      if (object instanceof PartitionDirContextWrappable)
      {
         return (factory.getContextInstance ((Context) object));
      }
      return (object);

   } /* lookupLink () */


   // ******************** DirContext Interface ********************

   /**
    *
    */
   public DirContext createSubcontext (
         Name name,
         Attributes attrs)
      throws NamingException
   {
      DirContext context;

      context = ((DirContext) impl).createSubcontext (name, attrs);

      if (context instanceof PartitionDirContextWrappable)
      {
         return ((DirContext) factory.getContextInstance (context));
      }
      return (context);

   } /* createSubcontext () */

   /**
    *
    */
   public DirContext getSchema (
         Name name)
      throws NamingException
   {
      return (((DirContext) impl).getSchema (name));
   }

   /**
    *
    */
   public DirContext getSchemaClassDefinition (
         Name name)
      throws NamingException
   {
      return (((DirContext) impl).getSchemaClassDefinition (name));
   }

   /**
    *
    */
   public NamingEnumeration search (
         Name name,
         Attributes matchingAttributes,
         String[] attributesToReturn)
      throws NamingException
   {
      return (((DirContext) impl).search (
                                       name, 
                                       matchingAttributes, 
                                       attributesToReturn));
   }

   /**
    *
    */
   public NamingEnumeration search (
         Name name,
         String filter,
         SearchControls cons)
      throws NamingException
   {
      return (((DirContext) impl).search (name, filter, cons));
   }

   /**
    *
    */
   public NamingEnumeration search (
         Name name,
         String filterExpr,
         Object [] filterArgs,
         SearchControls cons)
      throws NamingException
   {
      return (((DirContext) impl).search (
                                       name,
                                       filterExpr,
                                       filterArgs,
                                       cons));
   }


   // ******************** Referenceable Interface ********************

   /**
    * Retrieves the Reference of this object.
    *
    * @return the Reference of this object.
    */
   public Reference getReference ()
      throws NamingException
   {
      return (((Referenceable) impl).getReference ());

   } /* getReference () */

} /* PartitionDirContextWrapper */


/* *********************************************************************** */

/** @internal
 *
 *
class NdsNameClassEnumerator implements NamingEnumeration
{
   protected static NdsContextFactory factory = new NdsContextFactory ();

   private NamingEnumeration impl;

   / **
    *
    * /
   protected NdsNameClassEnumerator (NamingEnumeration impl)
   {
      this.impl = impl;
   }

   / **
    *
    * /
   public boolean hasMoreElements ()
   {
      return (impl.hasMoreElements ());
   }

   / **
    *
    * /
   public boolean hasMore ()
      throws NamingException
   {
      return (impl.hasMore ());
   }

   / **
    *
    * /
   public Object nextElement ()
   {
      NameClassPair pair = (NameClassPair) impl.nextElement ();

      return (new NameClassPair (
                     pair.getName (), 
                     factory.getClassName (pair.getClassName ())));
   }

   / **
    *
    * /
   public Object next ()
      throws NamingException
   {
      NameClassPair pair = (NameClassPair) impl.next ();

      return (new NameClassPair (
                     pair.getName (), 
                     factory.getClassName (pair.getClassName ())));
   }

} * NdsNameClassEnumerator */


/* *********************************************************************** */

/** @internal
 *
 *
class NdsBindingEnumerator implements NamingEnumeration
{
   protected static NdsContextFactory factory = new NdsContextFactory ();

   private NamingEnumeration impl;
   private NdsEnvironment environment;

   / **
    *
    * /
   protected NdsBindingEnumerator (
         NamingEnumeration impl,
         NdsEnvironment environment)
   {
      this.impl = impl;
      this.environment = environment;
   }

   / **
    *
    * /
   public boolean hasMoreElements ()
   {
      return (impl.hasMoreElements ());
   }

   / **
    *
    * /
   public boolean hasMore ()
      throws NamingException
   {
      return (impl.hasMore ());
   }

   / **
    *
    * /
   public Object nextElement ()
   {
      try
      {
         Binding binding = (Binding) impl.nextElement ();

         return (new Binding (
                        binding.getName (), 
                        factory.getContextInstance (
                                    (Context) binding.getObject (),
                                    environment)));
      }
      catch (NamingException e)
      {
         throw (new NoSuchElementException ());
      }

   }

   / **
    *
    * /
   public Object next ()
      throws NamingException
   {
      Binding binding = (Binding) impl.next ();

      return (new Binding (
                     binding.getName (), 
                     factory.getContextInstance (
                                 (Context) binding.getObject (),
                                 environment)));
   }

} * NdsBindingEnumerator */


