
/* **************************************************************************

  $Archive: /njcl_v2rmi/src/com/novell/service/nds/naming/net/NetFilter.java $
  $Revision: 10 $
  $Modtime: 1/05/01 3:59p $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.service.nds.naming.net;

import java.rmi.RemoteException;
import java.io.*;

import java.util.Vector;

import com.novell.java.io.*;

import com.novell.service.jncp.*;

import com.novell.service.session.SessionException;
import com.novell.service.jncpv2r.net.*;

import com.novell.service.toolkit.jcl.NWInteger;


/** @internal
 *
 * Represents a request buffer for NDS search filter operations.
 *
 */
public class NetFilter
{
   private int curHandle;
   private NetService service;

   private Vector vector;

   /**
    * Constructs an NetFilter using an NetContext.
    *
    * @param contextHandle       NetContext associated with the buffer.
    *
    * @return                    An NetFilter.
    *
    * @exception NSIException    Generic, source-unknown exception.
    */
   public NetFilter (
         NetService service)
      throws NSIException
   {
      vector = new Vector ();

      try
      {
         NWInteger handle = new NWInteger ();

         this.service = service;

         service.allocFilter (handle);

         this.curHandle = handle.getValue ();
      }
      catch (SessionException e)
      {
         NSIException ne = new NSIException ();

         ne.setRootCause (e);
         throw (ne);
      }
      catch (RemoteException e)
      {
         NSIException ne = new NSIException ();

         ne.setRootCause (e);
         throw (ne);
      }

   } /* NetFilter () */


   /**
    *
    */
   public void addFilterToken (int tok)
      throws NSIException
   {
      try
      {
         service.addFilterToken (curHandle, tok, null, 0);
      }
      catch (SessionException e)
      {
         NSIException ne = new NSIException ();

         ne.setRootCause (e);
         throw (ne);
      }
      catch (RemoteException e)
      {
         NSIException ne = new NSIException ();

         ne.setRootCause (e);
         throw (ne);
      }

   } /* addFilterToken () */

   /**
    *
    */
   public void addFilterToken (
         int token,
         String attrName,
         int syntaxId)
      throws NSIException
   {
      try
      {
         ByteArrayOutputStream baos = new ByteArrayOutputStream ();
         EndianOutputStream eos = new EndianOutputStream (baos);

         eos.writeLoHiChars (attrName);

         service.addFilterToken (
                  curHandle,
                  token,
                  baos.toByteArray (),
                  syntaxId);
      }
      catch (IOException e)
      {
         NSIException ne = new NSIException ();

         ne.setRootCause (e);
         throw (ne);
      }
      catch (SessionException e)
      {
         NSIException ne = new NSIException ();

         ne.setRootCause (e);
         throw (ne);
      }

   } /* addFilterToken () */


   /**
    *
    */
   public void addFilterToken (
         int token,
         byte[] value,
         int syntaxId)
      throws NSIException
   {
      try
      {
         service.addFilterToken (curHandle, token, value, syntaxId);
      }
      catch (SessionException e)
      {
         NSIException ne = new NSIException ();

         ne.setRootCause (e);
         throw (ne);
      }
      catch (RemoteException e)
      {
         NSIException ne = new NSIException ();

         ne.setRootCause (e);
         throw (ne);
      }

   } /* addFilterToken () */

   /**
    *
    */
   public void putFilter (
         NetBuffer filterBuffer)
      throws NSIException
   {
      try
      {
         service.putFilter (
                     filterBuffer.getHandle (),
                     this.curHandle);
      }
      catch (SessionException e)
      {
         NSIException ne = new NSIException ();

         ne.setRootCause (e);
         throw (ne);
      }
      catch (RemoteException e)
      {
         NSIException ne = new NSIException ();

         ne.setRootCause (e);
         throw (ne);
      }

   }

} /* NetFilter */


