
/* **************************************************************************

  $Archive: /njcl_v2rmi/src/com/novell/service/nds/naming/net/NetPartitionAttribute.java $
  $Revision: 6 $
  $Modtime: 11/15/00 3:43p $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/
package com.novell.service.nds.naming.net;

import java.util.*;
import javax.naming.*;
import javax.naming.directory.*;

import com.novell.service.nds.naming.NdsPartitionStrings;
import com.novell.service.nds.NdsInteger;

/** @internal
 *  Defines the class for NdsPartitionDirContext Object's attributes.
 */

public class NetPartitionAttribute extends BasicAttribute
{

   /*
    * Constructs a new instance of an attribute.
    *
    * @param partnName (in)Name of the partition.
    * @param netEnv    (in)NetEnvironment.
    * @param id        (in)The attribute's id.
    * @param psyi      (in)Reference to the NetPartitionSyncInfo object.
    */
   public NetPartitionAttribute (
         String partnName,
         NetEnvironment netEnv,
         String id,
         NetPartitionSyncInfo psyi
         )
      throws NamingException
   {
      super (id);
      PartitionFunctions pf = new PartitionFunctions(netEnv);

      if(id.equalsIgnoreCase(NdsPartitionStrings.PARTITION_ATTRID_NAME))
      {
         // Add this value to the attribute
//         add(partnName);
         add(psyi.getEntryName());
      }
      else if(id.equalsIgnoreCase(
                NdsPartitionStrings.PARTITION_ATTRID_SERVER_READ))
      {
         add(psyi.getServerRead());
      }
      else if(id.equalsIgnoreCase(
              NdsPartitionStrings.PARTITION_ATTRID_LAST_SUCCESSFUL_SYNC_TIME))
      {
         add(new NdsInteger(psyi.getLastSuccessfulSyncTime()));
      }
      else if(id.equalsIgnoreCase(
               NdsPartitionStrings.PARTITION_ATTRID_LAST_ATTEMPTED_SYNC_TIME))
      {
         add(new NdsInteger(psyi.getLastAttemptedSyncTime()));
      }
      else
         throw new InvalidAttributeIdentifierException(id);
   }

} /* NdsPartitionAttribute */



