
/* **************************************************************************

  $Archive: /njcl_v2rmi/src/com/novell/service/nds/naming/net/NetPartitionAttributes.java $
  $Revision: 8 $
  $Modtime: 11/15/00 3:43p $

  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.service.nds.naming.net;


import javax.naming.*;
import javax.naming.directory.*;
import java.util.*;

import com.novell.service.nds.naming.NdsPartitionStrings;

import com.novell.utility.naming.directory.NAttributes;


/** @internal
 *
 * public class NdsPartitionAttributes
 *     extends Attributes
 *
 */

public class NetPartitionAttributes extends NAttributes
{
    /*
    * Array of attribute ids of the NdsPartitionDirContext object
    */
    private static String[] attrNames =
           { NdsPartitionStrings.PARTITION_ATTRID_NAME,
             NdsPartitionStrings.PARTITION_ATTRID_SERVER_READ,
             NdsPartitionStrings.PARTITION_ATTRID_LAST_SUCCESSFUL_SYNC_TIME,
             NdsPartitionStrings.PARTITION_ATTRID_LAST_ATTEMPTED_SYNC_TIME };

    /*
    * Hashtable for storing mapping of attribute ids to the backend objects
    * which provide the values for those ids.
    */
    private static Hashtable mapAttrset = null;

    /*
    * Handle to invoke wrapper methods to native NWDS and other related
    * functions.
    */
    private PartitionFunctions pf;



   //* **********************************************************************
   // Protected Constructors
   //************************************************************************

   /**
    * xxx.
    * @param partnName  Partition Name
    * @param netEnv     Net Environment
    * @param attrIDs    Array of attribute ids.
    */
   public NetPartitionAttributes (
            String partnName,
            NetEnvironment netEnv,
            String[] attrIDs)
        throws AttributeInUseException, NamingException
   {
      super();

      if(mapAttrset == null)
      {
          // Prepare the mapping table
          mapAttrset = new Hashtable();
          mapAttrset.put(
            NdsPartitionStrings.PARTITION_ATTRID_NAME.toUpperCase (),
            NdsPartitionStrings.REPLICA_SYNC_INFO);
          mapAttrset.put(
            NdsPartitionStrings.PARTITION_ATTRID_SERVER_READ.toUpperCase (),
            NdsPartitionStrings.REPLICA_SYNC_INFO);
          mapAttrset.put(
            NdsPartitionStrings.PARTITION_ATTRID_LAST_SUCCESSFUL_SYNC_TIME.toUpperCase (),
            NdsPartitionStrings.REPLICA_SYNC_INFO);
          mapAttrset.put(
            NdsPartitionStrings.PARTITION_ATTRID_LAST_ATTEMPTED_SYNC_TIME.toUpperCase (),
            NdsPartitionStrings.REPLICA_SYNC_INFO);
      }

      NetPartitionSyncInfo psyi = null;

      pf = new PartitionFunctions(netEnv);

      // Create an attribute set for the attribute IDs passed in
      if(null != attrIDs)
      {
         // Go over the attrs hash table to determine which all objects
         // need to be retrieved
         for(int i = 0; i < attrIDs.length; i++)
         {
            String set = (String)mapAttrset.get(attrIDs[i].toUpperCase ());

            if(set != null)
            {
               if(set.equals(NdsPartitionStrings.REPLICA_SYNC_INFO))
               {
                  if(psyi == null)
                  {
                     psyi = pf.getPartitionSyncInfo(partnName);
                  }
               }

               put(new NetPartitionAttribute(
                                                partnName,
                                                netEnv,
                                                attrIDs[i],
                                                psyi));
            }
         }
      }
      else
      {
         psyi = pf.getPartitionSyncInfo(partnName);

         // Add all the attributes
         for(int i = 0; i < attrNames.length; i++)
         {
            put(new NetPartitionAttribute(
                    partnName,
                    netEnv,
                    attrNames[i],
                    psyi));
         }
      }
   }

   public boolean IsCaseIgnored()
   {
        return true;
   }
}
