/* **************************************************************************

  $Archive: /njcl_v2rmi/src/com/novell/service/nds/naming/net/NetPartitionSyncInfo.java $
  $Revision: 5 $
  $Modtime: 11/15/00 3:43p $

  Copyright (c) 1999 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.service.nds.naming.net;

import java.util.*;
import java.io.*;

/**
 * This class is used by getPartitionSyncInfo() in PartitionFunctions.
 */
public class NetPartitionSyncInfo {
   /**
    * The name of the server the partition sync info was read from.
	*/
   private String serverRead = "";
   /**
    * The name of the entry which contains the "partition status" attribute.
	*/
   private String entryName = "";
   /**
    * The last time a successful synchronization across all replicas took
	* place.
	*/
   private int lastSuccessfulSyncTime = 0;
   /**
    * The last time an attempted synchronization across all replicas took
	* place.
	*/
   private int lastAttemptedSyncTime = 0;

   public NetPartitionSyncInfo()
   {
	  // no need to do anything since all variable are initialized.
   }

   public String getServerRead() {
	  return serverRead;
   }

   public void setServerRead(String name) {
	  serverRead = name;
   }

   public String getEntryName() {
	  return entryName;
   }

   public void setEntryName(String name) {
	  entryName = name;
   }

   public int getLastSuccessfulSyncTime() {
	  return lastSuccessfulSyncTime;
   }

   public void setLastSuccessfulSyncTime(int time) {
	  lastSuccessfulSyncTime = time;
   }

   public int getLastAttemptedSyncTime() {
	  return lastAttemptedSyncTime;
   }

   public void setLastAttemptedSyncTime(int time) {
	  lastAttemptedSyncTime = time;
   }

}
