
/* **************************************************************************

  $Archive: /njcl_v2rmi/src/com/novell/service/nds/naming/net/NetReplicaBindingEnumerator.java $
  $Revision: 11 $
  $Modtime: 11/15/00 3:43p $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.service.nds.naming.net;


import javax.naming.*;
import java.util.*;

import com.novell.service.jncp.*;
import com.novell.service.nds.*;
import com.novell.service.nds.naming.NdsNamingExceptionFactory;
import com.novell.service.nds.net.NetAttributeValueFactory;


/** @internal
 *
 *  Partition's replica ring enumeration class.
 */
public final class NetReplicaBindingEnumerator implements NamingEnumeration {

   protected NetAttributeValueEnumerator replicaRing;

   private NetEnvironment netEnv;
   private String partnName;
   private static NdsNamingExceptionFactory exceptionFactory =
       new NdsNamingExceptionFactory ();

    /**
     * Constructs a NdsReplicaBindingEnumerator object.
     *
     *  @param env          NetEnvironment
     *  @param partition    Partition's FDN
     *
     *  @param NamingException
     */
   public NetReplicaBindingEnumerator(
                   NetEnvironment env,
                   String partition)
      throws NamingException
   {
      try   {
          this.replicaRing = new NetAttributeValueEnumerator(
                        env.getService (),
                        partition, "Replica");
      }
      catch(NSIException e) {
			NamingException ne = exceptionFactory.getNamingException (e);
         throw ne;
      }

      this.partnName = partition;
      this.netEnv = env;
   }

    /**
     * Tests if this enumeration contains more elements.
     */
   public boolean hasMoreElements()
   {
      return this.replicaRing.hasMoreElements();
   }

   /**
    * Returns the next element of this enumeration.
    *
    * @exception NoSuchElementException
    */
   public Object nextElement ()
       throws NoSuchElementException
   {
      NdsReplicaPointer replicaPointer = null;

      try 
      {
         replicaPointer = (NdsReplicaPointer)
             NetAttributeValueFactory.createValue (
                    NdsSyntaxId.REPLICA_POINTER_ID,
                    (byte[]) this.replicaRing.nextElement(),
                    null,
                    null,
                    partnName,
                    "Replica");
      }
      catch (NSIException e)
      {
         throw (new NoSuchElementException(e.getMessage ()));
      }

      Binding binding = null;

      try 
      {
         binding = new Binding (replicaPointer.getServerName (),
                                new NetReplicaDirContext (
                                    replicaPointer.getServerName (),
                                    partnName, netEnv));
      }
      catch (NamingException e) 
      {
         throw (new NoSuchElementException (e.getMessage ()));
      }
      return binding;

   } /* nextElement () */

    /**
     * Tests if this enumeration contains more elements.
     */
   public boolean hasMore()
   {
      return this.hasMoreElements();
   }

   /**
    * Returns the next element of this enumeration.
    *
    * @exception NamingException
    */
   public Object next ()
       throws NamingException
   {
      return (this.nextElement ());
   }

   /**
    *
    */
   public void close ()
      throws NamingException
   {
		replicaRing.closeIteration ();
   }

}


