
/* **************************************************************************

  $Archive: /njcl_v2rmi/src/com/novell/service/nds/naming/net/NetReplicaServerInfo.java $
  $Revision: 10 $
  $Modtime: 1/05/01 3:59p $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.service.nds.naming.net;

import java.rmi.RemoteException;
import java.util.*;

import javax.naming.*;

import com.novell.service.jncp.NSIException;

import com.novell.service.nds.*;
import com.novell.service.nds.net.NetAttributeValueFactory;

import com.novell.service.jncpv2r.net.NetService;
import com.novell.service.session.SessionException;


/** @internal
 *
 */
public class NetReplicaServerInfo 
{
   private String partitionName;
   private NetEnvironment netEnv;

//    protected String osName;
//    protected String hardwareName;
//    protected String vendorName;
//    protected String directoryName;
//    protected String directoryVersion;
    protected String serverName;
    protected String serverRead;
//    protected String serverVersion;
//    protected String licenseID;
    protected int timeInSync;
    protected Vector netAddresses;
//    protected Vector replicaInfo;
    protected NdsTimestamp modTime = null;
    protected boolean busyState;

    protected NetReplicaServerInfo(
            NetEnvironment netEnv,
            String partitionDN,
            String serverDN)
        throws NSIException
    {
        this.serverName = serverDN;
        this.partitionName = partitionDN;
        this.netEnv = netEnv;

        NetService service;

        try {
            service = netEnv.getService ();
        }
        catch (NamingException e)
        {
           throw new NSIException (e.getMessage());
        }

        /* get all addresses of a server and put them in an array */
        //NDSBuffer netAddresses = new NDSBuffer(ndsContext);
        //IntegerBuffer connHandle = new IntegerBuffer();
        //int ccode;
        //
        //ccode = NdsNatives.NWDSOpenConnToNDSServer(ndsContext,
        //                                 serverDN, connHandle);
        //if (ccode != 0)
        //    throw NSIExceptionBuilder.build(ccode);
        //
        //IntegerBuffer addrCount = new IntegerBuffer();
        //
        //ccode = NdsNatives.NWDSGetServerAddresses(ndsContext,
        //                    connHandle.intValue(), addrCount,
        //                    netAddresses.getHandle());
        //if (ccode != 0)
        //    throw NSIExceptionBuilder.build(ccode);
        //
        //int count = addrCount.intValue();
        //
        //this.netAddresses = new Vector();
        //
        //while (count-- != 0) {
        //   NWInteger valSize = new NWInteger();
        //
        //   netAddresses.computeAttrValSize(NdsSyntaxId.NET_ADDRESS_ID, valSize);
        //
        //   byte[] value = new byte[valSize.get()];
        //
        //   netAddresses.getAttrVal(NdsSyntaxId.NET_ADDRESS_ID, value);
        //
        //   this.netAddresses.addElement(NetAttributeValueFactory.
        //            createValue(NdsSyntaxId.NET_ADDRESS_ID, value));
        //}
        NetAttributeValueEnumerator netAddress = new
                NetAttributeValueEnumerator(service,
                        serverDN, "Network Address");

        this.netAddresses = new Vector();

        while (netAddress.hasMoreElements()) {
            this.netAddresses.addElement(
                NetAttributeValueFactory.createValue(
                            NdsSyntaxId.NET_ADDRESS_ID,
                            (byte[])netAddress.nextElement(),
                            null,
                            null,
                            partitionName,
                            "Network Address"));
        }

        /* get all partition info and put them in the array */
//        this.replicaInfo = new Vector();

        NetReplicaInfoEnumerator riEnum = new
                 NetReplicaInfoEnumerator(service, serverDN);

        while (riEnum.hasMoreElements())
        {
            NetReplicaInfo info = (NetReplicaInfo)riEnum.nextElement ();

            if (info.getPartitionName ().equalsIgnoreCase(partitionDN))
            {
                this.modTime = info.getModificationTime ();
                this.busyState = info.getPartitionBusyStatus ();
                // this.serverRead = info.getServerRead ();
            }
        }

		  /* Get the name of the server that we talk to by default. If the user
		   * wants to talk to a different server, then he should direct his
		   * reads to that server.
			*/
		  try
		  {
			  this.serverRead = service.getServerDN();
		  }
		  catch (SessionException e)
		  {
           throw new NSIException (e.getMessage());
		  }
		  catch (RemoteException e)
		  {
           throw new NSIException (e.getMessage());
		  }


//        while (repInfo.hasMoreElements())
//           this.replicaInfo.addElement(repInfo.nextElement());
    }

//    public String getOSName() {
//        return "";
//    }

//    public String getHardwareName() {
//        return "";
//    }

//    public String getVendorName() {
//        return "";
//    }

//    public String getDirectoryName() {
//        return "";
//    }

//    public String getDirectoryVersion() {
//        return "";
//    }

    public String getServerName() {
        return serverName;
    }

    public String getServerRead() {
        return serverRead;
    }

//    public String getServerVersion() {
//        return "";
//    }

//    public String getLicenseID() {
//        return "";
//    }

    public int getTimeInSync() {
        return 0;
    }

    public Vector getNetAddresses() {
        return netAddresses;
    }

//    public Vector getReplicaInfo() {
//        return replicaInfo;
//    }

    public NdsTimestamp getModificationTime () {
        return modTime;
    }

    public NdsBoolean getBusyState () {
        return new NdsBoolean (busyState);
    }
}
