
/* **************************************************************************

  $Archive: /njcl_v2rmi/src/com/novell/service/nds/naming/net/NetReplicaSyncInfo.java $
  $Revision: 6 $
  $Modtime: 11/15/00 3:43p $

  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.service.nds.naming.net;


import java.util.*;
import java.io.*;

import com.novell.java.io.*;

/**
 * Parses a "Partition Status" attribute value into its constituent 
 * components.
 */
public class NetReplicaSyncInfo
{
    protected int statusFlags;
    protected int lastSyncTime;
    protected int replicaNumber;
    protected int errorCode;
    protected String serverName;
    protected String entryName;

    protected int lastAttemptedSyncTime;

    public NetReplicaSyncInfo(
            byte[] octetString)
        throws IOException
    {
        EndianInputStream edis;

        edis = new EndianInputStream (octetString);


        /* because the octetString passed in is in C octet string
        ** format, we need to skip byte 4 - byte 7.
        */

        int length = edis.readLoHiInt (); // octet string length

        //edis.skipBytes (4);  // skip the octet string pointer

        /*
            Partition Status Attribute Octet String Format:

         32 bits     - Version number
         32 bits     - Partition Status Flag (0=marker,1=Local error,2=ok)
         32 bits     - Time stamp (seconds since 1/1/70)
         32 bits     - Replica number
         32 bits     - Error number
         32 bits     - Number of 8 bit chunks in server name unicode string
         n*8 bits    - Server unicode string, 16 bit characters
         n*8 bits    - Alignment to get us back on 32 bit word boundary
         32 bits     - Number of 8 bit chunks in entry name unicode string
         n*8 bits    - Entry unicode string, 16 bit characters
         n*8 bits    - Alignment to get us back on 32 bit word boundary
         32 bits     - Number of 8 bit chunks in Debug Information
         n*8 bits    - Debug Information

         Notes:
         1) A server name is only available if this particular Partition
         Status attribute value represents a failed synchronization attempt
         to the replica on the server named in the server name field.

         2) The Entry may also be absent.

         3) The Entry ID is present in the debug information.

         4) If the status flag is 0 (marker) AND the replica number is non-
         zero, then this partition status value represents a remote error.

         5) The last successful synchronization time will be the
         synchronization time stamp associated with the partition status
         value which has a status flag value of 2 (ok).

        */

        edis.readLoHiInt(); // version number - ignore

        this.statusFlags = edis.readLoHiInt();  // status flags
        this.lastSyncTime = edis.readLoHiInt(); // sync time
        this.replicaNumber = edis.readLoHiInt();// replica number
        this.errorCode = edis.readLoHiInt();    // error code

        length = edis.readLoHiInt(); // length of server name in bytes
        if (length > 0)
        {
           serverName = edis.readLoHiChars();  // server name
        }
//        edis.skipBytes(length);             // alignment - ignored
        edis.align32();

        length = edis.readLoHiInt(); // length of entry name in bytes
        if (length > 0) {
           entryName = edis.readLoHiChars();   // entry name
        }
        //edis.skipBytes(length);             // alignment - ignored
        edis.align32();

        // debug info follows

        this.lastAttemptedSyncTime = this.lastSyncTime;
    }

    public int getStatusFlags() {
        return this.statusFlags;
    }

    public int getLastSyncTime() {
        return this.lastSyncTime;
    }

    public int getReplicaNumber() {
        return this.replicaNumber;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public String getServerName() {
        return this.serverName;
    }

    public String getEntryName() {
        return this.entryName;
    }

    public int getLastAttemptedSyncTime() {
        return this.lastAttemptedSyncTime;
    }

    public void setLastSyncTime(int lastSyncTime)
    {
      this.lastSyncTime = lastSyncTime;
    }

    public void setReplicaNumber(int replicaNumber) {
        this.replicaNumber = replicaNumber;
    }

}
