
/* **************************************************************************

  $Archive: /njcl_v2rmi/src/com/novell/service/nds/naming/net/NetSyntaxDefinitionDirContext.java $
  $Revision: 10 $
  $Modtime: 1/05/01 3:59p $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.service.nds.naming.net;

import java.rmi.RemoteException;
import java.util.*;

import javax.naming.*;
import javax.naming.directory.*;

import  com.sun.jndi.toolkit.ctx.*;

import com.novell.service.session.*;
import com.novell.service.jncpv2r.net.*;
import com.novell.service.jncp.*;
import com.novell.service.nds.*;
import com.novell.service.nds.naming.NdsNamingExceptionFactory;


/** @internal
* Represents a single NSD Syntax Definition.
* <p> Attributes include:
* <p> ID
* <p> Flags (this may contain one or more of the following)
* <p>
* <p>DS_STRING
* <p>DS_SINGLE_VALUED
* <p>DS_SUPPORTS_ORDER
* <p>DS_SUPPORTS_EQUAL
* <p>DS_IGNORE_CASE
* <p>DS_IGNORE_SPACE
* <p>DS_IGNORE_DASH
* <p>DS_ONLY_DIGITS
* <p>DS_ONLY_PRINTABLE
* <p>DS_SIZEABLE
*/
public class NetSyntaxDefinitionDirContext
   extends NetSchemaDefinitionDirContext
   implements SchemaSyntax
{
   private static Vector syntaxItemsAttrIDs = new Vector ();
   private static NdsNamingExceptionFactory exceptionFactory =
       new NdsNamingExceptionFactory ();

   static
   {
      syntaxItemsAttrIDs.addElement (ATTR_ID);
      syntaxItemsAttrIDs.addElement (ATTR_FLAGS);
   }


   protected String atomicName;


   /**
    * Constructor.
    *
    * @param objectName    Distinguished name of this object
    * @param baseClass     NDS class name
    * @param netEnvironment properties to be set in this objects environment
    */
   protected NetSyntaxDefinitionDirContext (
         String objectName,
         String baseClass,
         NetEnvironment netEnvironment)
      throws NamingException
   {
      super (objectName, baseClass, netEnvironment);

      Name name = getNameInstance ();

      this.atomicName = name.get (name.size () - 1);
   }

   /* ***********************************************************************
    * protected Toolkit DirContext methods
    ************************************************************************/

   /**
    * Can't modify syntax def's
    */
   protected void schema_modifyAttributes (
         ModificationItem[] mods,
         Continuation cont)
      throws NamingException
   {
      cont.setError (this, "");
      throw cont.fillInException (new OperationNotSupportedException ());
   }

   /**
    * Can't modify syntax def's
    */
   protected void schema_modifyAttributes (
         int mod_op,
         Attributes attrs,
         Continuation cont)
      throws NamingException
   {
      cont.setError (this, "");
      throw cont.fillInException (new OperationNotSupportedException ());
   }

   /* ***********************************************************************
    * Utility methods
    ************************************************************************/

   /**
    * Returns a hashtable of attribute id's / attributes
    * This is called by NetSchemaDirContext.a_getAttributes
    */
   protected Hashtable getAttrItems ()
      throws NamingException
   {
      Hashtable ret = new Hashtable ();
      Attribute attr;
      int itemCount;
      int cCode;

      NetService service = environment.getService ();
      NetIterationHandle iterationHandle = new NetIterationHandle (
                                             service,
                                             NetJNI.DSV_READ_SYNTAXES);

      try
      {
         NetBuffer syntaxNames = new NetBuffer (service,
                                NetJNI.DSV_READ_SYNTAXES,
                                NetJNI.MAX_MESSAGE_LEN);
         NetBuffer syntaxDefs = new NetBuffer (service);

         // NWDSReadSyntaxes can't handle SN=, strip it
         int index;
         if ((index = atomicName.indexOf ('=')) != -1)
         {
            atomicName = atomicName.substring (index + 1);
         }

         syntaxNames.putSyntaxName (atomicName);

         service.readSyntaxes (
                        NetJNI.DS_SYNTAX_DEFS,
                        false,
                        syntaxNames.getHandle (),
                        iterationHandle,
                        syntaxDefs.getHandle ());

         syntaxDefs.getSyntaxCount ();

         // Get syntaxInfo
         StringBuffer syntaxDefName = new StringBuffer ();
         NetSyntaxInfo syntaxInfo = new NetSyntaxInfo ();
         syntaxDefs.getSyntaxDef (syntaxDefName, syntaxInfo);

         // Build ID attribute
         attr = new BasicAttribute (ATTR_ID,
               new NdsInteger (syntaxInfo.getID ()));
         ret.put (ATTR_ID.toUpperCase (), attr);

         // Build FLAGS attribute
         attr = new BasicAttribute (ATTR_FLAGS,
               new NdsInteger (syntaxInfo.getFlags ()));
         ret.put (ATTR_FLAGS.toUpperCase (), attr);
      }
      catch (NSIException e)
      {
			NamingException ne = exceptionFactory.getNamingException (e);
         throw ne;
      }
      catch (SessionException e)
      {
         NamingException ne = new NamingException ();

         ne.setRootCause (e);
         throw ne;
      }
      catch (RemoteException e)
      {
         NamingException ne = new NamingException ();

         ne.setRootCause (e);
         throw ne;
      }
      return ret;

   } /* getAttrItems () */

} /* NetSyntaxDefinitionDirContext */


