/* **************************************************************************

  $Archive: /njcl_v2rmi/src/com/novell/service/nds/naming/net/NetVolumeDirContext.java $
  $Revision: 17 $
  $Modtime: 1/05/01 3:59p $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.service.nds.naming.net;

import java.rmi.RemoteException;
import java.util.Hashtable;

import javax.naming.*;
import javax.naming.directory.*;
import javax.naming.spi.*;

import com.novell.service.file.nw.naming.FSEnvironment;

import com.novell.service.nds.*;
import com.novell.service.nds.naming.*;

import com.novell.service.jncp.*;
import com.novell.service.jncpv2r.net.*;

import com.novell.service.schema.SchemaString;

import com.novell.service.session.*;

import com.novell.utility.naming.Environment;
import com.novell.utility.naming.spi.ReferenceFactory;


/** @internal
 *
 */
public class NetVolumeDirContext extends NetDirContext
{
   private Object nnsp;

   /**
    *
    */
   protected NetVolumeDirContext (
         String objectName,
         NdsObjectInfo objectInfo,
         NetEnvironment netEnvironment)
      throws NamingException
   {
      super (objectName, objectInfo, netEnvironment);

   }


   // ******************** NDSComponentDirContext methods ********************

   /**
    *
    */
   protected Object getNNSP ()
      throws NamingException
   {
      if (null == nnsp)
      {
         try
         {
            Class cls;
            Hashtable environment;
            StringBuffer providerURL = new StringBuffer (1024);
            ReferenceFactory referenceFactory;
            Reference reference;

            // Guarantee NDS server session
            Session session = getHostServerSession ();

            cls = Class.forName ("com.novell.service.file.nw.naming.ReferenceFactoryImpl");
            referenceFactory = (ReferenceFactory) cls.newInstance ();

            environment = this.environment.getEnvironment ();

            // set INITIAL_CONTEXT_FACTORY to FileSystemInitialContextFactory
            environment.put (
                                 Context.INITIAL_CONTEXT_FACTORY,
                                 Environment.FS_INITIAL_CONTEXT_FACTORY);

            // set PROVIDER_URL to <ServerName>/<VolumeName>
            providerURL.append (getServerName ());
            providerURL.append ("/");
            providerURL.append (getHostResourceName ());

            environment.put (Context.PROVIDER_URL, new String (providerURL));

            // set SESSION_OBJECT to NDS Server Session
            environment.put (Environment.SESSION_OBJECT, session);

            reference = referenceFactory.createReference (environment);

            nnsp = NamingManager.getObjectInstance (reference, null, null, environment);
         }
         catch (Exception e)
         {
            // nnsp remains null
         }
      }
      return (nnsp);
   }


   // ******************** NetServerDirContext class ********************

   /**
    *
    */
   String getHostResourceName ()
      throws NamingException
   {
      Attributes attrs;
      SchemaString hostResourceName;

      attrs = getAttributes ("", new String[] {"Host Resource Name"});
      hostResourceName = (SchemaString) attrs.get ("Host Resource Name").get ();
      return (hostResourceName.stringValue ());
   }

   /**
    *
    * The server name is the last component of the "Host Server" attribute
    * value.  The component has also had types removed.
    */
   private String getServerName ()
      throws NamingException
   {
      Name target;

      target = ((NdsName) nameParser.parse (getHostServer ())).getTypelessName ();
      return (target.get (target.size () - 1));

   } /* getServerName () */

   /**
    *
    */
   private String getHostServer ()
      throws NamingException
   {
      Attributes attrs;
      SchemaString hostServer;

      attrs = getAttributes ("", new String[] {"Host Server"});
      hostServer = (SchemaString) attrs.get ("Host Server").get ();
      return (hostServer.stringValue ());
   }

   /**
    *
    */
   private Session getHostServerSession ()
      throws NamingException, SessionException, RemoteException
   {
      SessionManager manager = environment.getSessionManager ();
      Session session = manager.findSession (getTreeName ());

      return (session.getSession (getHostServer ()));
   }

} /* NetVolumeDirContext */


