
/* **************************************************************************
  $Archive: /njcl_v2rmi/src/com/novell/service/nds/net/NetAttributeValueFactory.java $
  $Revision: 9 $
  $Modtime: 1/05/01 3:59p $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.service.nds.net;


import com.novell.service.jncpv2r.net.*;
import com.novell.service.nds.naming.net.*;

import com.novell.service.jncp.*;
import com.novell.service.nds.*;

import com.novell.service.session.Session;


/** @internal
 * The NetAttributeValueFactory will create NetAttributeValues from a byte[] 
 * and a syntaxId.  The factory will also convert an NdsAttributeValue
 * into a NetAttributeValue.
 */
public final class NetAttributeValueFactory
{
   /**
    * Create a specific NetAttributeValue using the syntaxId.  The byte
    * array contains the "API Data Structure" of the attribute value.
    */
   public static NdsAttributeValue createValue (
         int ndsSyntaxId,
         byte[] value,
         Session session,
         NetService service,
         String objectName,
         String attributeName)
      throws NSIException
   {
      NdsAttributeValue attrValue;

      switch (ndsSyntaxId)
      {
         case  NdsSyntaxId.UNKNOWN_ID:
         {
            return (new NetUnknown (value));
         }

         case  NdsSyntaxId.DISTINGUISHED_NAME_ID:
         {
            return (new NetDistinguishedName (value));
         }

         case  NdsSyntaxId.CASE_EXACT_STRING_ID:
         {
            return (new NetCaseExactString (value));
         }

         case  NdsSyntaxId.CASE_IGNORE_STRING_ID:
         {
            return (new NetCaseIgnoreString (value));
         }

         case  NdsSyntaxId.PRINTABLE_STRING_ID:
         {
            return (new NetPrintableString (value));
         }

         case  NdsSyntaxId.NUMERIC_STRING_ID:
         {
            return (new NetNumericString (value));
         }

         case  NdsSyntaxId.CASE_IGNORE_LIST_ID:
         {
            return (new NetCaseIgnoreList (value));
         }

         case  NdsSyntaxId.BOOLEAN_ID:
         {
            return (new NetBoolean (value));
         }

         case  NdsSyntaxId.INTEGER_ID:
         {
            return (new NetInteger (value));
         }

         case  NdsSyntaxId.OCTET_STRING_ID:
         {
            return (new NetOctetString (value));
         }

         case NdsSyntaxId.TELEPHONE_NUMBER_ID:
         {
            return (new NetTelephoneNumber (value));
         }

         case NdsSyntaxId.FAX_NUMBER_ID:
         {
            return (new NetFAXNumber (value));
         }

         case NdsSyntaxId.NET_ADDRESS_ID:
         {
            return (new NetNetAddress (value));
         }

         case NdsSyntaxId.OCTET_LIST_ID:
         {
            return (new NetOctetList (value));
         }

         case NdsSyntaxId.EMAIL_ADDRESS_ID:
         {
            return (new NetEMailAddress (value));
         }

         case NdsSyntaxId.PATH_ID:
         {
            return (new NetPath (value));
         }

         case NdsSyntaxId.REPLICA_POINTER_ID:
         {
            return (new NetReplicaPointer (value));
         }

         case NdsSyntaxId.OBJECT_ACL_ID:
         {
            return (new NetObjectACL (value));
         }

         case NdsSyntaxId.POSTAL_ADDRESS_ID:
         {
            return (new NetPostalAddress (value));
         }

         case NdsSyntaxId.TIMESTAMP_ID:
         {
            return (new NetTimestamp (value));
         }

         case NdsSyntaxId.CLASS_NAME_ID:
         {
            return (new NetClassName (value));
         }

         case NdsSyntaxId.STREAM_ID:
         {
            return (new NetStream (session, service, objectName, attributeName));
         }

         case NdsSyntaxId.COUNTER_ID:
         {
            return (new NetCounter (value));
         }

         case NdsSyntaxId.BACK_LINK_ID:
         {
            return (new NetBackLink (value));
         }

         case NdsSyntaxId.TIME_ID:
         {
            return (new NetTime (value));
         }

         case NdsSyntaxId.TYPED_NAME_ID:
         {
            return (new NetTypedName (value));
         }

         case NdsSyntaxId.HOLD_ID:
         {
            return (new NetHold (value));
         }

         case NdsSyntaxId.INTERVAL_ID:
         {
            return (new NetInterval (value));
         }

         default:
         {
            throw (new NSIException ());
         }

      } /* switch (syntaxID) */

   } /* createValue () */

   /**
    * Create a specific NetAttributeValue from a corresponding 
    * NdsAttributeValue.
    */
   public static NetAttributeValue createValue (
         NdsAttributeValue attrValue)
      throws NSIException
   {
      switch (attrValue.getNdsSyntaxId ())
      {
         case  NdsSyntaxId.UNKNOWN_ID:
         {
            return (new NetUnknown ((NdsUnknown) attrValue));
         }

         case  NdsSyntaxId.DISTINGUISHED_NAME_ID:
         {
            return (new NetDistinguishedName ((NdsDistinguishedName) attrValue));
         }

         case  NdsSyntaxId.CASE_EXACT_STRING_ID:
         {
            return (new NetCaseExactString ((NdsCaseExactString) attrValue));
         }

         case  NdsSyntaxId.CASE_IGNORE_STRING_ID:
         {
            return (new NetCaseIgnoreString ((NdsCaseIgnoreString) attrValue));
         }

         case  NdsSyntaxId.PRINTABLE_STRING_ID:
         {
            return (new NetPrintableString ((NdsPrintableString) attrValue));
         }

         case  NdsSyntaxId.NUMERIC_STRING_ID:
         {
            return (new NetNumericString ((NdsNumericString) attrValue));
         }

         case  NdsSyntaxId.CASE_IGNORE_LIST_ID:
         {
            return (new NetCaseIgnoreList ((NdsCaseIgnoreList) attrValue));
         }

         case  NdsSyntaxId.BOOLEAN_ID:
         {
            return (new NetBoolean ((NdsBoolean) attrValue));
         }

         case  NdsSyntaxId.INTEGER_ID:
         {
            return (new NetInteger ((NdsInteger) attrValue));
         }

         case  NdsSyntaxId.OCTET_STRING_ID:
         {
            return (new NetOctetString ((NdsOctetString) attrValue));
         }

         case NdsSyntaxId.TELEPHONE_NUMBER_ID:
         {
            return (new NetTelephoneNumber ((NdsTelephoneNumber) attrValue));
         }

         case NdsSyntaxId.FAX_NUMBER_ID:
         {
            return (new NetFAXNumber ((NdsFAXNumber) attrValue));
         }

         case NdsSyntaxId.NET_ADDRESS_ID:
         {
            return (new NetNetAddress ((NdsNetAddress) attrValue));
         }

         case NdsSyntaxId.OCTET_LIST_ID:
         {
            return (new NetOctetList ((NdsOctetList) attrValue));
         }

         case NdsSyntaxId.EMAIL_ADDRESS_ID:
         {
            return (new NetEMailAddress ((NdsEMailAddress) attrValue));
         }

         case NdsSyntaxId.PATH_ID:
         {
            return (new NetPath ((NdsPath) attrValue));
         }

         case NdsSyntaxId.REPLICA_POINTER_ID:
         {
            return (new NetReplicaPointer ((NdsReplicaPointer) attrValue));
         }

         case NdsSyntaxId.OBJECT_ACL_ID:
         {
            return (new NetObjectACL ((NdsObjectACL) attrValue));
         }

         case NdsSyntaxId.POSTAL_ADDRESS_ID:
         {
            return (new NetPostalAddress ((NdsPostalAddress) attrValue));
         }

         case NdsSyntaxId.TIMESTAMP_ID:
         {
            return (new NetTimestamp ((NdsTimestamp) attrValue));
         }

         case NdsSyntaxId.CLASS_NAME_ID:
         {
            return (new NetClassName ((NdsClassName) attrValue));
         }

         case NdsSyntaxId.STREAM_ID:
         {
            return (new NetStream ((NdsStream) attrValue));
         }

         case NdsSyntaxId.COUNTER_ID:
         {
            return (new NetCounter ((NdsCounter) attrValue));
         }

         case NdsSyntaxId.BACK_LINK_ID:
         {
            return (new NetBackLink ((NdsBackLink) attrValue));
         }

         case NdsSyntaxId.TIME_ID:
         {
            return (new NetTime ((NdsTime) attrValue));
         }

         case NdsSyntaxId.TYPED_NAME_ID:
         {
            return (new NetTypedName ((NdsTypedName) attrValue));
         }

         case NdsSyntaxId.HOLD_ID:
         {
            return (new NetHold ((NdsHold) attrValue));
         }

         case NdsSyntaxId.INTERVAL_ID:
         {
            return (new NetInterval ((NdsInterval) attrValue));
         }

         default:
         {
            throw (new NSIException ());
         }

      } /* switch (syntaxID) */

   } /* createValue () */

   /**
    *
    */
   public NetAttributeValue getValueInstance (
         Object object)
      throws NSIException
   {
      if (object instanceof NetAttributeValue)
      {
         return ((NetAttributeValue) object);
      }

      if (object instanceof NdsAttributeValue)
      {
         return (createValue ((NdsAttributeValue) object));
      }
      throw (new NSIException ());

   } /* getObjectInstance () */

   /**
    * @deprecated    the move to NdsJNI requires the use of NetMemory
    */
   public static NdsAttributeValue createValue (
         int ndsSyntaxId,
         byte[] value)
      throws NSIException
   {
      return (null);
   }

} /* NetAttributeValueFactory */


