
/* **************************************************************************
  $Archive: /njcl_v2rmi/src/com/novell/service/nds/net/NetCaseIgnoreList.java $
  $Revision: 9 $
  $Modtime: 11/15/00 3:43p $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.service.nds.net;


import java.io.*;

import com.novell.java.io.EndianInputStream;
import com.novell.java.io.EndianOutputStream;

import com.novell.service.jncp.NSIException;

import com.novell.service.nds.NdsCaseIgnoreList;


/** @internal
 * NetCaseIgnoreList is an Adapter for NdsCaseIgnoreList.
 *
 * This class converts to/from the NWNet CI_List_T.
 *
 * API Data Structure:
 *    typedef struct _ci_list
 *    {
 *       struct_ci_list   *next;
 *       pnchar            s;
 *
 *    } CI_List_T;
 */
public final class NetCaseIgnoreList
   extends NdsCaseIgnoreList implements NetAttributeValue, Serializable
{
   /**
    * Constructs a Case Ignore List from the "API Data Structure".
    *
    * @param   value   byte[] containing a CI_List_T.
    */
   protected NetCaseIgnoreList (
         byte[] value)
      throws NSIException
   {
      try
      {
         int count;
         EndianInputStream edis = new EndianInputStream (value);

         count = edis.readLoHiInt ();
         this.values = new String[count];
         for (int i = 0; i < count; i++)
         {
            this.values[i] = edis.readLoHiChars();
         }
      }
      catch (IOException e)
      {
         NSIException ne = new NSIException ();

         ne.setRootCause (e);
         throw (ne);
      }
   }

   /**
    * Constructs a NetCaseIgnoreList adapter for an NdsCaseIgnoreList.
    *
    * @param   value   an NdsCaseIgnoreList object.
    */
   protected NetCaseIgnoreList (
         NdsCaseIgnoreList value)
   {
      super (value);
   }

   /**
    * Returns a Case Ignore List "API Data Structure".
    *
    * @return   byte[] containing CI_List_T.
    */
   public byte[] toByte ()
      throws NSIException
   {
      try
      {
         int count = this.values.length;
         ByteArrayOutputStream baos = new ByteArrayOutputStream ();
         EndianOutputStream eos = new EndianOutputStream (baos);

         eos.writeLoHiInt (count);

         for (int i = 0; i < count; i++)
         {
            eos.writeLoHiChars ((String) this.values[i]);
         }
         return (baos.toByteArray ());
      }
      catch (IOException e)
      {
         NSIException ne = new NSIException ();

         ne.setRootCause (e);
         throw (ne);
      }
   }

} /* NetCaseIgnoreList */


