
/* **************************************************************************
  $Archive: /njcl_v2rmi/src/com/novell/service/nds/net/NetEMailAddress.java $
  $Revision: 8 $
  $Modtime: 11/15/00 3:43p $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.service.nds.net;


import java.io.*;

import com.novell.java.io.EndianInputStream;
import com.novell.java.io.EndianOutputStream;

import com.novell.service.jncp.NSIException;

import com.novell.service.nds.NdsEMailAddress;


/** @internal
 * NetEMailAddress is an Adapter for NdsEMailAddress.
 *
 * This class converts to/from the NWNet EMail_Address_T.
 *
 * API Data Structure:
 *    typedef struct
 *    {
 *       NWEMAIL_TYPE   type;
 *       pnchar         address;
 *
 *    } EMail_Address_T;
 */
public final class NetEMailAddress
   extends NdsEMailAddress implements NetAttributeValue, Serializable
{
   /**
    * Constructs a EMail Address from the "API Data Structure".
    *
    * @param   value   byte[] containing a EMail_Address_T
    */
   protected NetEMailAddress (
         byte[] value)
      throws NSIException
   {
      try
      {
         EndianInputStream edis = new EndianInputStream (value);

         this.type = edis.readLoHiInt ();
         this.address = edis.readLoHiChars ();
      }
      catch (IOException e)
      {
         NSIException ne = new NSIException ();

         ne.setRootCause (e);
         throw (ne);
      }
   }

   /**
    * Constructs a NetEMailAddress adapter for an NdsEMailAddress.
    *
    * @param   value   an NdsBackLink object.
    */
   protected NetEMailAddress (
         NdsEMailAddress value)
   {
      super (value);
   }

   /**
    * Returns a EMail Address "API Data Structure".
    *
    * @return   byte[] containing EMail_Address_TT.
    */
   public byte[] toByte ()
      throws NSIException
   {
      try
      {
         ByteArrayOutputStream baos = new ByteArrayOutputStream ();
         EndianOutputStream eos = new EndianOutputStream (baos);

         eos.writeLoHiInt (this.type);
         eos.writeLoHiChars (this.address);
         return(baos.toByteArray ());
      }
      catch (IOException e)
      {
         NSIException ne = new NSIException ();

         ne.setRootCause (e);
         throw (ne);
      }
   }

} /* NetEMailAddress */


