
/* **************************************************************************
  $Archive: /njcl_v2rmi/src/com/novell/service/nds/net/NetNetAddress.java $
  $Revision: 8 $
  $Modtime: 11/15/00 3:43p $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.service.nds.net;


import java.io.*;

import com.novell.java.io.EndianInputStream;
import com.novell.java.io.EndianOutputStream;

import com.novell.service.jncp.NSIException;

import com.novell.service.nds.NdsNetAddress;


/** @internal
 * NetNetAddress is an Adapter for NdsNetAddress.
 *
 * This class converts to/from the NWNet Net_Address_T.
 * 
 * API Data Structure:
 *    typedef struct
 *    {
 *       NWNET_ADDR_TYPE   addressType;
 *       NWNET_ADDR_LEN    addressLength;
 *       NWNET_ADDR       *address;
 * 
 * } Net_Address_T;
 */
public final class NetNetAddress
   extends NdsNetAddress implements NetAttributeValue, Serializable
{
   /**
    * Constructs a Net Address from the "API Data Structure".
    *
    * @param   value   byte[] containing a Net_Address_T
    */
   protected NetNetAddress (
         byte[] value)
      throws NSIException
   {
      try
      {
         int length;
         EndianInputStream edis = new EndianInputStream (value);

         this.type = edis.readLoHiInt ();
         length = edis.readLoHiInt ();
         this.address = new byte [length];
         edis.readFully (this.address);
      }
      catch (IOException e)
      {
         NSIException ne = new NSIException ();

         ne.setRootCause (e);
         throw (ne);
      }
   }

   /**
    * Constructs a NeNetAddress adapter for an NdsNetAddress.
    *
    * @param   value   an NdsNetAddress object.
    */
   protected NetNetAddress (
         NdsNetAddress value)
   {
      super (value);
   }

   /**
    * Returns a Net Address "API Data Structure".
    *
    * @return   byte[] containing Net_Address_T.
    */
   public byte[] toByte ()
      throws NSIException
   {
      try
      {
         ByteArrayOutputStream baos = new ByteArrayOutputStream ();
         EndianOutputStream eos = new EndianOutputStream (baos);

         eos.writeLoHiInt (this.type);
         eos.writeLoHiInt (this.address.length);
         eos.write (this.address);
         return (baos.toByteArray ());
      }
      catch (IOException e)
      {
         NSIException ne = new NSIException ();

         ne.setRootCause (e);
         throw (ne);
      }
   }

} /* NetNetAddress */


