
/* **************************************************************************
  $Archive: /njcl_v2rmi/src/com/novell/service/nds/net/NetPath.java $
  $Revision: 8 $
  $Modtime: 11/15/00 3:43p $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.service.nds.net;


import java.io.*;

import com.novell.java.io.EndianInputStream;
import com.novell.java.io.EndianOutputStream;

import com.novell.service.jncp.NSIException;

import com.novell.service.nds.NdsPath;


/** @internal
 * NetPath is an Adapter for NdsPath.
 *
 * This class converts to/from the NWNet Path_T.
 * 
 * API Data Structure:
 *    typedef struct
 *    {
 *       NWNAME_SPACE_TYPE    nameSpaceType;
 *       pnchar               volumeName;
 *       pnchar               path;
 *
 *    } Path_T;
 */
public final class NetPath
   extends NdsPath implements NetAttributeValue, Serializable
{
   /**
    * Constructs a Path from the "API Data Structure".
    * 
    * @param   value   byte[] containing a Path_T
    */
   protected NetPath (
         byte[] value)
      throws NSIException
   {
      try
      {
         EndianInputStream edis = new EndianInputStream (value);

         this.nameSpaceType = edis.readLoHiInt ();
         this.volumeName = edis.readLoHiChars ();
         this.path = edis.readLoHiChars ();
      }
      catch (IOException e)
      {
         NSIException ne = new NSIException ();

         ne.setRootCause (e);
         throw (ne);
      }
   }

   /**
    * Constructs a NetPath adapter for an NdsPath.
    * 
    * @param   value   an NdsPath object.
    */
   protected NetPath (
         NdsPath value)
   {
      super (value);
   }

   /**
    * Returns a Path "API Data Structure".
    * 
    * @return   byte[] containing Path_T.
    */
   public byte[] toByte ()
      throws NSIException
   {
      try
      {
         ByteArrayOutputStream baos = new ByteArrayOutputStream ();
         EndianOutputStream eos = new EndianOutputStream (baos);

         eos.writeLoHiInt (this.nameSpaceType);
         eos.writeLoHiChars (this.volumeName);
         eos.writeLoHiChars (this.path);
         return (baos.toByteArray ());
      }
      catch (IOException e)
      {
         NSIException ne = new NSIException ();

         ne.setRootCause (e);
         throw (ne);
      }
   }

} /* NetPath */


