/* **************************************************************************

  $Archive: /njcl_v2/src/com/novell/service/nw/BinderyTreeNamesEnumerator.java $
  $Revision: 4 $
  $Modtime: 1/28/00 12:43p $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/
package com.novell.service.nw;
import java.util.*;
import com.novell.service.jncp.*;
import com.novell.service.session.*;
import com.novell.service.session.xplat.CallsService;
import com.novell.service.session.xplat.*;
import com.novell.java.lang.IntegerBuffer;

class BinderyTreeNamesEnumerator implements Enumeration
{
   private CallsService service;
   private IntegerBuffer objID;
   private String treeName, oldTreeName;
   private boolean more;
   private Vector vec;

   /**
   * Performs a look-ahead scan of bindery sap table for tree names
   */
   public BinderyTreeNamesEnumerator(Hashtable h)
   {
      try
      {
         vec = new Vector();
         Session s = (Session)h.get(com.novell.utility.naming.Environment.SESSION_OBJECT);
         service = (CallsService)s.getService(CallsService.KEY);
         objID = new IntegerBuffer(0xFFFFFFFF);
         more = true;
         scanObject();
         vec.addElement(treeName);
      }
      catch(Exception e)
      {
         throw NSIExceptionBuilder.build(e);
      }
   }

   public boolean hasMoreElements()
   {
      return more;
   }

   /**
   * Returns next tree name. Strips out duplicate tree names returned from
   * scanObject
   */
   public Object nextElement()
   {
      if(!more)
         throw new NoSuchElementException();
      oldTreeName = treeName;
      do
      {
         scanObject();
      } while((true==more) && vec.contains(treeName));
      vec.addElement(treeName);
      return oldTreeName;
   }

   private void scanObject()
   {
      try
      {
         StringBuffer name = new StringBuffer();
         service.scanObject(
            "*",
            Xplat.NDS_TREE_TYPE,
            objID,
            name,
            (IntegerBuffer)null,    // unused. objType
            (IntegerBuffer)null,    // unused. hasPropertiesFlag
            (IntegerBuffer)null,    // unused. objFlags
            (IntegerBuffer)null);   // unused. objSecurity
         treeName = DomainName.strip(name.toString());
      }
      catch(NSIException ne)
      {
         more=false; //Expecting an exception when no more elements
      }
      catch(Exception e)
      {
         more=false;
         throw NSIExceptionBuilder.build(e);
      }
   }
}
