/* **************************************************************************

  $Archive: /njcl/src/com/novell/service/nw/NetWareNameParser.java $
  $Revision: 3 $
  $Modtime: 4/27/98 11:44a $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.service.nw;

import javax.naming.*;
import java.util.*;
import com.novell.utility.naming.Syntax;

/** @internal
 * Name parser for NetWare name space.
 */
public class NetWareNameParser
implements NameParser, com.novell.service.nw.NetWareStrings
{
   private static Properties syntax = new Properties();

   /*
    * constructs a NetWare name space parser with direction = 
    * NETWARE_SYNTAX_DIRECTION, separator = NETWARE_SYNTAX_SEPARATOR, escape =
    * NETWARE_SYNTAX_ESCAPE, beginquote = NETWARE_SYNTAX_BEGIN_QUOTE,
    * beginquote2 = NETWARE_SYNTAX_BEGIN_QUOTE2
    */
   static
   {
      syntax.put(Syntax.DIRECTION, NETWARE_SYNTAX_DIRECTION);
      syntax.put(Syntax.SEPARATOR, NETWARE_SYNTAX_SEPARATOR);
      syntax.put(Syntax.ESCAPE, NETWARE_SYNTAX_ESCAPE);
      syntax.put(Syntax.BEGIN_QUOTE, NETWARE_SYNTAX_BEGIN_QUOTE);
      syntax.put(Syntax.BEGIN_QUOTE2, NETWARE_SYNTAX_BEGIN_QUOTE2);
   }

   public Name parse (String name)
      throws NamingException
   {
      return new CompoundName(name, syntax);
   }

   public boolean equals (Object obj)
   {
      if (obj instanceof NetWareNameParser)
         return (true);

      return (false);
   }
}
