/* **************************************************************************

  $Archive: /njcl/src/com/novell/service/nw/NetWareObjectFactory.java $
  $Revision: 3 $
  $Modtime: 5/19/98 4:54p $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.service.nw;

import javax.naming.*;
import javax.naming.spi.*;
import java.util.*;

/** @internal
* Creates NetWare contexts depending on the parameter obj
* which is always a string for now.
*/
public class NetWareObjectFactory implements ObjectFactory
{
   /**
   * @param obj                  Should be a String containing the type of
   *                             context to create. 
   * @param h                    Properties for the context. Will be cloned
   * @return                     The object created or null.
   * @exception                  never actually thrown
   */
   public Object getObjectInstance(
         Object obj,
         Name name,  //NOTE: name needs to be implemented
         Context nameCtx,  //NOTE: name needs to be implemented
         Hashtable h)
      throws Exception
   {
      String type = (String)obj;
      if(h == null)
         h = new Hashtable();

      if(type.equals(NetWareStrings.ROOT))
         return new NetWareInitialContext((Hashtable)h.clone(), true);
      if(type.equals(NetWareStrings.TREES))
         return new NetWareTreesContext((Hashtable)h.clone());
      if(type.equals(NetWareStrings.SERVERS))
         return new NetWareServersContext((Hashtable)h.clone());
      return null;
   }
}
