/* **************************************************************************

  $Archive: /njcl_v2rmi/src/com/novell/service/nw/NetWareServersContext.java $
  $Revision: 17 $
  $Modtime: 8/17/01 12:43p $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.service.nw;

import java.util.*;

import javax.naming.*;
import javax.naming.spi.*;

import com.sun.jndi.toolkit.ctx.*;

import com.novell.service.jncp.*;

import com.novell.service.session.*;
import com.novell.service.session.xplat.*;

import com.novell.service.server.*;

/**
* Provides bindings to all NetWare servers. NetWareServersContext
* is one of two children of NetWareInitialContext.
*
* @see  NetWareInitialContext
*/
public class NetWareServersContext extends NetWareInitialContext
{
  /**
   * @internal
   *
   * Calls parent constructor - NetWareInitialContext(Hashtable)
   * @param h                    Parents properties
   */
   protected NetWareServersContext(
         Hashtable h)
   {
      super(h);
   }


   // ******************** Context Interface ********************

   /** @internal
    *
    */
   public String getNameInNamespace ()
      throws NamingException
   {
      return (NetWareStrings.SERVERS);
   }


  /**
   * @internal
   *
   * Place 1 component in the head, rest of name in the tail
   */
   protected HeadTail p_parseComponent(
         Name name,
         Continuation cont)
      throws NamingException
   {
	   if(name.size() < 2)  //Can contain 1 component
	      return new HeadTail(name, null);
	   else
	      return new HeadTail(name.getPrefix(1), name.getSuffix(1));
	}

  /**
   * @internal
   */
   protected Object a_lookup(
         String name,
         Continuation cont)
      throws NamingException
   {
      if(isEmpty(name))
      {
         cont.setSuccess();
         return this;
      }

      try
      {
         environment.put(Context.PROVIDER_URL, name);
         Object obj = NamingManager.getObjectInstance(     //Create server object
            new ReferenceFactoryImpl().createReference(environment),
            null, null, 
            getEnvironment());
         if(obj==null)
            throw new NameNotFoundException();
         cont.setSuccess();
         return obj;
      }
      catch(Exception e)
      {
         cont.setError(this, name);
         NameNotFoundException ex = new NameNotFoundException();
         ex.setRootCause(e);
         throw cont.fillInException(ex);
      }
   }

  /**
   * @internal
   */
   protected NamingEnumeration a_list(
         Continuation cont)
      throws NamingException
   {
      cont.setSuccess();
      return new NameClassEnumerator(getEnvironment());
   }

  /**
   * @internal
   */
   protected NamingEnumeration a_listBindings(
         Continuation cont)
      throws NamingException
   {
      cont.setSuccess();
      return new BindingEnumerator(getEnvironment());
   }


     /**
      * @internal
      *
   ********************************************************************
   *  Binding Enumeration of the NetWareServersContext Bindings.
   */
   class BindingEnumerator implements NamingEnumeration
   {
      private Enumeration names;
      private Hashtable env;

      public BindingEnumerator(Hashtable h)
      {
         names = NamesEnumeratorFactory.getNamesEnumerator(NamesEnumeratorFactory.SERVERS, h);
         env = h;
      }

      public boolean hasMoreElements()
      {
         return names.hasMoreElements();
      }

      public boolean hasMore()
      {
         return hasMoreElements();
      }

      public Object nextElement()
      {
         try
         {
            return next();
         }
         catch(Exception e)
         {
            throw new NoSuchElementException(e.getMessage());
         }
      }

      public Object next()
         throws NamingException
      {
         try
         {
            String name = (String)names.nextElement();
            env.put(Context.PROVIDER_URL, name);
            Object obj = NamingManager.getObjectInstance(     //Create server object
               new ReferenceFactoryImpl().createReference(env),
               null, null,
               env);
            if(obj==null)
               throw new NamingException();
            return new Binding(name, obj);
         }
         catch (NamingException e)
         {
            throw e;
         }
         catch(Exception e)
         {
            NamingException ex = new NamingException();
            ex.setRootCause(e);
            throw ex;
         }
      }

      public void close() throws NamingException
      {
         NamesEnumeratorFactory.closeEnumerator(names);
      }
   } /* BindingEnumerator */


   /**
   * @internal
   *
   ********************************************************************
   *  NameClassPair Enumeration of the NetWareServersContext Bindings.
   */
   class NameClassEnumerator implements NamingEnumeration
   {
      private Enumeration names;

      public NameClassEnumerator(Hashtable h)
      {
         names = NamesEnumeratorFactory.getNamesEnumerator(NamesEnumeratorFactory.SERVERS, h);
      }

      public boolean hasMoreElements()
      {
         return names.hasMoreElements();
      }

      public boolean hasMore()
      {
         return hasMoreElements();
      }

      public Object nextElement()
      {
         try
         {
            return next();
         }
         catch(Exception e)
         {
            throw new NoSuchElementException(e.getMessage());
         }
      }

      public Object next()
         throws NamingException
      {
         try
         {
            String name = (String)names.nextElement();
            return new NameClassPair(name, ServerStrings.SERVERDIRCONTEXT_FULLNAME);
         }
         catch(Exception e)
         {
            NamingException ex = new NamingException(e.getMessage());
            ex.setRootCause(e);
            throw ex;
         }
      }

      public void close() throws NamingException
      {
         NamesEnumeratorFactory.closeEnumerator(names);
      }
   } /* NameClassEnumerator */

} /* NetWareServersContext */


