/* **************************************************************************

  $Archive: /njcl/src/com/novell/service/security/BinderyIdentityScope.java $
  $Revision: 7 $
  $Modtime: 11/24/98 7:44p $

  Copyright (c) 1997-1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS AN UNPUBLISHED WORK AND CONTAINS CONFIDENTIAL PROPRIETARY
  AND TRADE SECRET INFORMATION OF NOVELL, INC. ACCESS  TO  THIS  WORK IS
  RESTRICTED TO (I) NOVELL, INC.  EMPLOYEES WHO HAVE A NEED TO  KNOW HOW
  TO  PERFORM  TASKS WITHIN  THE SCOPE  OF  THEIR   ASSIGNMENTS AND (II)
  ENTITIES OTHER  THAN  NOVELL, INC.  WHO  HAVE ENTERED INTO APPROPRIATE
  LICENSE   AGREEMENTS.  NO  PART  OF  THIS WORK MAY BE USED, PRACTICED,
  PERFORMED COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED, ABRIDGED,
  CONDENSED, EXPANDED, COLLECTED, COMPILED, LINKED,  RECAST, TRANSFORMED
  OR ADAPTED  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC.  ANY USE
  OR EXPLOITATION  OF  THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE
  PERPETRATOR  TO CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/
package com.novell.service.security;

import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;

import com.novell.java.security.Identity;
import com.novell.java.security.IdentityScope;
import com.novell.java.security.KeyManagementException;
import com.novell.java.security.PublicKey;
import com.novell.java.util.Debug;

/**
 * Represents an authenticatable container in a Bindery system, such
 * as a server. Every BinderyIdentity is associated with a server
 * identity scope which, in turn, is associated with the Bindery
 * administrative domain scope. The server domain scope is a child of
 * the administrative domain scope and a user identity is a child of
 * the server domain scope.
 *
 * <p>For example, to construct a user named Karah on a bindery
 * server called Jaeger you could do the following:
 * <code>
 * <pre>
 * IdentityScope administrativeDomain  = new BinderyIdentityScope();
 * IdentityScope server                = new BinderyIdentityScope("Jaeger",administrativeDomain);
 * Identity      user                  = new BinderyIdentity("Karah",server);
 * </pre>
 * </code>
 *
 * @see BinderyIdentity
 * @see com.novell.java.security.Identity
 * @see com.novell.java.security.IdentityScope
 * @see NdsIdentity
 * @see NdsIdentityScope
 *
 * @author Jan Sture Nielsen
 * @version 1.00.00 98/01/23
 */
public class BinderyIdentityScope extends XplatIdentityScope
{
	final static boolean DEBUG = false;

   /**
    * The administrative domain name.
    */
   public static String ADMINISTRATIVE_DOMAIN_NAME = "[BINDERY]";

   /**
    * Container of identities in this scope.
    */
   Vector identities = new Vector();

   /**
	 * Construct the root-most identity scope with the
	 * ADMINISTRATIVE_DOMAIN_NAME name.
	 */
   public BinderyIdentityScope()
   {
      this(ADMINISTRATIVE_DOMAIN_NAME);
   }
	
   /**
	 * Construct an identity scope with the specified name and no scope.
	 *
	 * @param name The name of the identity.
	 */
   public BinderyIdentityScope(String name)
   {
      super(name);
   }

   /**
	 * Construct an identity scope with the specified name and scope.
	 *
	 * @param name  The name of the IdentityScope.
	 * @param scope The scope of the IdentityScope.
	 *
	 * @exception com.novell.java.security.KeyManagementException
	 * Thrown when an IdentityScope cannot be constructed due to
	 * key management issues.
	 */
   public BinderyIdentityScope(String name, IdentityScope scope)
      throws KeyManagementException
   {
      super(name,scope);
   }

   /**
	 * Construct an identity scope from a scope.
	 *
	 * @param scope The scope to copy.
	 *
	 * @exception com.novell.java.security.KeyManagementException
	 * Thrown when an IdentityScope cannot be constructed due to
	 * key management issues.
	 */
	public BinderyIdentityScope(IdentityScope identity)
		throws KeyManagementException
	{
		this(identity.getName(),identity.getScope());
	}
}
