/* **************************************************************************

  $Archive: /njcl_v2/src/com/novell/service/security/NdsPasswordIdentity.java $
  $Revision: 9 $
  $Modtime: 10/18/99 10:54a $

  Copyright (c) 1997-1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS AN UNPUBLISHED WORK AND CONTAINS CONFIDENTIAL PROPRIETARY
  AND TRADE SECRET INFORMATION OF NOVELL, INC. ACCESS  TO  THIS  WORK IS
  RESTRICTED TO (I) NOVELL, INC.  EMPLOYEES WHO HAVE A NEED TO  KNOW HOW
  TO  PERFORM  TASKS WITHIN  THE SCOPE  OF  THEIR   ASSIGNMENTS AND (II)
  ENTITIES OTHER  THAN  NOVELL, INC.  WHO  HAVE ENTERED INTO APPROPRIATE
  LICENSE   AGREEMENTS.  NO  PART  OF  THIS WORK MAY BE USED, PRACTICED,
  PERFORMED COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED, ABRIDGED,
  CONDENSED, EXPANDED, COLLECTED, COMPILED, LINKED,  RECAST, TRANSFORMED
  OR ADAPTED  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC.  ANY USE
  OR EXPLOITATION  OF  THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE
  PERPETRATOR  TO CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.service.security;

import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;

import com.novell.java.security.Identity;
import com.novell.java.security.IdentityScope;
import com.novell.java.security.KeyManagementException;
import com.novell.java.security.PublicKey;

/**
 * This class represents an NDS identity with a password.
 *
 * @see BinderyPasswordIdentity
 * @see NdsIdentityScope
 * @see PasswordIdentityFactory
 */
public class NdsPasswordIdentity
   extends NdsIdentity
   implements PasswordIdentity
{
	private Password password;
	private Password newPassword;

   /**
	 * Construct an identity with the specified user name and no scope.
	 *
	 * @param name                The user name of the identity.
	 */
   public NdsPasswordIdentity (
         String name)
   {
      super (name);
	} // NDSPasswordIdentity ()

   /**
	 * Construct an identity with the specified user name and scope as Strings.
	 *
	 * @param name                The user name of the identity.
	 * @param scope               The scope of the identity (the domain).
    * @exception KeyManagementException When an error occurs.
	 */
   public NdsPasswordIdentity (
         String name,
         String scope)
      throws KeyManagementException
   {
      super (name, new NdsIdentityScope (scope));
	} // NDSPasswordIdentity ()

   /**
	 * Construct an identity with the specified user name as a String and scope
    * as an IdentityScope.
	 *
	 * @param name                The user name of the identity.
	 * @param scope               The scope of the identity (the domain).
    * @exception KeyManagementException When an error occurs.
	 */
   public NdsPasswordIdentity (
         String name,
         IdentityScope scope)
      throws KeyManagementException
   {
      super (name, scope);
	} // NDSPasswordIdentity ()

   /**
    * Constructs a password identity based on an existing identity.
    *
    * <p>The name and parent scope are copied from the existing identity.
    * If the identity is an XplatIdentity, the session manager is also
    * copied.
    *
    * <p>Note: If the identity is an NDS identity, its context handle is
    * copied, and if the identity is a password identity, its passwords
    * are also copied.
    * </p>
    *
    * @param identity            The identity from which to build the copy.
    * @exception KeyManagementException When an error occurs.
    */
	public NdsPasswordIdentity (
         Identity identity)
		throws KeyManagementException
	{
		super (identity);
      if (identity instanceof PasswordIdentity)
      {
         setPassword (((PasswordIdentity) identity).getPassword ());
         setNewPassword (((PasswordIdentity) identity).getNewPassword ());
      }
	} // NDSPasswordIdentity ()

   // PasswordIdentity methods ===============================================
   /**
    * Set the password for this identity.
    *
    * <p>The password case is preserved. Consequently, it is up to the
    * caller to uppercase the password if needed. This set request should
    * not be confused with the createTokens request which alters a user
    * object's password. This request only sets the memory variable for this
    * identity so that when the login request is made, the identity will
    * already have the password and will not need to prompt the user for one.
    * </p>
    *
    * @param password            The password for this identity.
    * @see #getPassword
    * @see #setNewPassword
    */
   public void setPassword (
         Password password)
   {
      this.password = password;
   } // setPassword ()

   /**
    * Return the password for this identity.
    *
    * @return The current password set in this identity (may be NULL).
    * @see #setPassword
    * @see #getNewPassword
    */
   public Password getPassword ()
   {
      return (password);
   } // getPassword ()

   /**
    * Set the new password for this identity.
    *
    * <p>This is used when a modifyTokens (i.e. change password) request
    * is going to be made. This new password will be used as the object's
    * new password once the modifyTokens request is completed.
    * </p>
    *
    * @param newPassword         The new password for this identity.
    * @see #getNewPassword
    * @see #setPassword
    */
	public void setNewPassword (
         Password newPassword)
	{
	   this.newPassword = newPassword;
	} // setNewPassword ()

   /**
    * Return the new password for this identity.
    *
    * @return The new password set in this identity (may be NULL).
    * @see #setNewPassword
    * @see #getPassword
    */
	public Password getNewPassword ()
	{
	   return (newPassword);
	} // getNewPassword ()

} // class NdsPasswordIdentity
