/* ***************************************************************************

  $Archive: /njcl_v2/src/com/novell/service/security/PasswordIdentity.java $
  $Revision: 4 $
  $Modtime: 10/18/99 2:24p $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

 ****************************************************************************/

package com.novell.service.security;

/**
 * This interface identifies an object that can have a password set without
 * using the authentication GUI. It is intended that an object implementing
 * this interface also extend the Identity class.
 *
 * @see NdsPasswordIdentity
 * @see BinderyPasswordIdentity
 */
public interface PasswordIdentity
{
   /**
    * Set the password for this identity.
    *
    * <p>The password case is preserved. Consequently, it is up to the
    * caller to uppercase the password if needed. This set request should
    * not be confused with the createTokens request which alters a user
    * object's password. This request only sets the memory variable for this
    * identity so that when the login request is made, the identity will
    * already have the password and will not need to prompt the user for one.
    * </p>
    *
    * @param password            The password for this identity.
    * @see #getPassword
    * @see #setNewPassword
    */
   public void setPassword (Password password);
   
   /**
    * Return the password for this identity.
    *
    * @return The current password set in this identity (may be NULL).
    * @see #setPassword
    * @see #getNewPassword
    */
   public Password getPassword ();

   /**
    * Set the new password for this identity.
    *
    * <p>This is used when a modifyTokens (i.e. change password) request
    * is going to be made. This new password will be used as the object's
    * new password once the modifyTokens request is completed.
    * </p>
    *
    * @param newPassword         The new password for this identity.
    * @see #getNewPassword
    * @see #setPassword
    */
	public void setNewPassword (Password newPassword);
   
   /**
    * Return the new password for this identity.
    *
    * @return The new password set in this identity (may be NULL).
    * @see #setNewPassword
    * @see #getPassword
    */
	public Password getNewPassword ();
   
} /* interface PasswordIdentity */
