/* **************************************************************************

  $Archive: /njcl/src/com/novell/service/security/XplatIdentityScope.java $
  $Revision: 2 $
  $Modtime: 12/04/98 3:44p $

  Copyright (c) 1997-1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS AN UNPUBLISHED WORK AND CONTAINS CONFIDENTIAL PROPRIETARY
  AND TRADE SECRET INFORMATION OF NOVELL, INC. ACCESS  TO  THIS  WORK IS
  RESTRICTED TO (I) NOVELL, INC.  EMPLOYEES WHO HAVE A NEED TO  KNOW HOW
  TO  PERFORM  TASKS WITHIN  THE SCOPE  OF  THEIR   ASSIGNMENTS AND (II)
  ENTITIES OTHER  THAN  NOVELL, INC.  WHO  HAVE ENTERED INTO APPROPRIATE
  LICENSE   AGREEMENTS.  NO  PART  OF  THIS WORK MAY BE USED, PRACTICED,
  PERFORMED COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED, ABRIDGED,
  CONDENSED, EXPANDED, COLLECTED, COMPILED, LINKED,  RECAST, TRANSFORMED
  OR ADAPTED  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC.  ANY USE
  OR EXPLOITATION  OF  THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE
  PERPETRATOR  TO CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/
package com.novell.service.security;

import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;

import com.novell.java.security.Identity;
import com.novell.java.security.IdentityScope;
import com.novell.java.security.KeyManagementException;
import com.novell.java.security.PublicKey;
import com.novell.java.util.Debug;

/**
 * Represents an authenticatable container in a Xplat system, such
 * as a server. Every XplatIdentity is associated with a server
 * identity scope which, in turn, is associated with the Xplat
 * administrative domain scope. The server domain scope is a child of
 * the administrative domain scope, and a user identity is a child of
 * the server domain scope.
 *
 * <p>For example, to construct a user named Karah on a bindery
 * server called Jaeger you could do the following:
 * <code>
 * <pre>
 * IdentityScope administrativeDomain  = new XplatIdentityScope();
 * IdentityScope server                = new XplatIdentityScope("Jaeger",administrativeDomain);
 * Identity      user                  = new XplatIdentity("Karah",server);
 * </pre>
 * </code>
 *
 * @see XplatIdentity
 * @see com.novell.java.security.Identity
 * @see com.novell.java.security.IdentityScope
 * @see NdsIdentity
 * @see NdsIdentityScope
 *
 * @author Jan Sture Nielsen
 * @version 1.00.00 98/01/23
 */
public class XplatIdentityScope extends IdentityScope
{
	final static boolean DEBUG = false;

   /**
    * The administrative domain name.
    */
   public static String ADMINISTRATIVE_DOMAIN_NAME = "[BINDERY]";

   /**
    * Container of identities in this scope.
    */
   Vector identities = new Vector();

   /**
	 * Constructs the root-most identity scope with the
	 * ADMINISTRATIVE_DOMAIN_NAME name.
	 */
   public XplatIdentityScope()
   {
      this(ADMINISTRATIVE_DOMAIN_NAME);
   }
	
   /**
	 * Constructs an identity scope with the specified name and no scope.
	 *
	 * @param name The name of the identity.
	 */
   public XplatIdentityScope(String name)
   {
      super(name);
   }

   /**
	 * Constructs an identity scope with the specified name passed-in
	 * as a String and the scope passed-in as an IdentityScope.
	 *
	 * @param name  The name of the IdentityScope.
	 * @param scope The scope of the IdentityScope.
	 *
	 * @exception KeyManagementException Thrown when an IdentityScope
	 * cannot be constructed due to key management issues.
	 */
   public XplatIdentityScope(String name, IdentityScope scope)
      throws KeyManagementException
   {
      super(name,scope);
   }

   /**
	 * Constructs an identity scope from another scope.
	 *
	 * @param scope The scope to copy.
	 *
	 * @exception KeyManagementException Thrown when an IdentityScope
	 * cannot be constructed due to key management issues.
	 */
	public XplatIdentityScope(IdentityScope identity)
		throws KeyManagementException
	{
		this(identity.getName(),identity.getScope());
	}

   /**@internal
	 * Allow the Authenticator to configure the idenitity.
	 *
	 * @param properties <code>java.util.Properties</code> to be
	 * used to configure the identity
	 * @param baseKey point in the properties that configuration
	 * should start
    */
   public void configure(Properties properties, String baseKey)
   {
      if(DEBUG)
         Debug.println("XplatIdentity.configure("+properties+","+baseKey+")");
   }

   /**
    * Adds an identity to this scope.
    *
    * @param identity The identity to be added to this scope.
    */
   public void addIdentity(Identity identity)
   {
      identities.addElement(identity);
   }

   /**
    * Removes an identity from this identity scope.
    *
    * @param identity The identity to remove from this scope.
    */
   public void removeIdentity(Identity identity)
   {
      int index = identities.indexOf(identity);
      if(index == -1)
         return;

      identities.removeElementAt(index);
   }

   /**
    * Returns the identity in this scope identified by the
    * passed-in string name.
    *
    * @param name The name of the identity to be returned.
    *
    * @return The Identity for the name requested, or NULL
    *         if no name is passed in.
    */
   public Identity getIdentity(String name)
   {
      Enumeration e = identities();
      while(e.hasMoreElements())
      {
         Identity entry = (Identity)e.nextElement();
         if(entry.getName().equals(name))
            return entry;

         // if identity scope, recurse into it
         if(entry instanceof IdentityScope)
         {  Identity i = ((IdentityScope)entry).getIdentity(name);
            if(i != null)
               return i;
         }
      }
      return null;
   }

   /**@internal
    * Return an identity in this scope which matches the key.
    *
    * @param key <code>PublicKey</code> of identity to be returned
    *
    * @return <code>Identity</code> with the key requested or <code>null</code>
    */
   public Identity getIdentity(PublicKey key)
   {
      return null;
   }

   /**
    * Returns an enumeration of all identities in this identity scope.
    *
    * @return An Enumeration of all identities in this identity scope.
    */
   public Enumeration identities()
   {
      return identities.elements();
   }

   /**
    * Returns the number of identities within this identity scope.
    *
    * @return The number of identities within this identity scope.
    */
   public int size()
   {
      return identities.size();
   }
}
