/* **************************************************************************

  $Archive: /njcl/src/com/novell/service/server/ReferenceFactoryImpl.java $
  $Revision: 3 $
  $Modtime: 4/27/98 12:12p $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.service.server;

import com.novell.utility.naming.Environment;
import com.novell.utility.naming.URLParser;
import javax.naming.*;
import java.util.*;

/** @internal
*  Implements the ReferenceFactory interface to construct a reference
*  for a ServerDirContext
*/
public class ReferenceFactoryImpl
implements com.novell.utility.naming.spi.ReferenceFactory
{
   /**
   * Uses Context.PROVIDER_URL to construct reference.
   */
   public Reference createReference(
         Hashtable hash)
      throws NamingException
   {
      String serverName;

		String url = (String)hash.get(Context.PROVIDER_URL);
		serverName = new URLParser(url).getHost();
      if(serverName != null)
      {
         StringRefAddr refAddr =
            new StringRefAddr(Context.PROVIDER_URL, serverName);

         return new Reference(
            ServerStrings.SERVERDIRCONTEXT_FULLNAME,
            refAddr,
            ServerStrings.SERVER_OBJECTFACTORY_FULLNAME,
            "");
      }
      throw new InvalidNameException();
   }
}
