/* **************************************************************************

  $Archive: /njcl_v2/src/com/novell/service/server/ServerSchemaContext.java $
  $Revision: 9 $
  $Modtime: 11/03/99 3:05p $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.service.server;


import javax.naming.*;

import  com.sun.jndi.toolkit.*;

import com.novell.utility.naming.*;
import com.novell.utility.naming.directory.*;


/** @internal
 * Schema context object for the Server name space schema.  Can either be the
 * root schema context or one of the first layer children depending on the
 * way it is constructed.
 */
public class ServerSchemaContext extends StaticSchemaContext
{
   private static final int NumOfChildren = 5;
   private static final int NumOfAttributes = 3;
   
   NameParser parser = null;
   String serverName;

   /**
   * This constuctor is the root schema context constructor or a first layer
   * constructor depending on the isRootContext flag. If flag is true, this
   * method constructs and initializes the entire schema subtree.
   */
   public ServerSchemaContext (
         String name,
         boolean isRootContext,
         String serverName)
   {
      super (name);

      this.serverName = serverName;

      if(isRootContext)
      {
         //construct and set up the root schemas bindings
         ServerSchemaContext ctx1, ctx2;
         ServerSchemaDefContext serverDesc;
         String childNames[] = { ServerStrings.CLASS_DEFINITION,
            ServerStrings.ATTRIBUTE_DEFINITION };
         String childClasses[] = { ServerStrings.SCHEMA_CLASS, ServerStrings.SCHEMA_CLASS };
         ctx1 = new ServerSchemaContext (ServerStrings.CLASS_DEFINITION, false, serverName);
         ctx2 = new ServerSchemaContext (ServerStrings.ATTRIBUTE_DEFINITION, false, serverName);
         Object childObjects[] = { ctx1, ctx2 };
         initBindingsAndPairs(childNames, childClasses, childObjects);

         //construct and set up the class definition schema object bindings
         childNames = new String[1];
         childNames[0] = ServerStrings.SERVER;
         childClasses = new String[1];
         childClasses[0] = ServerStrings.SERVER_SCHEMADEF_CONTEXT_FULLNAME;
         childObjects = new Object[1];
         serverDesc = new ServerSchemaDefContext(ServerStrings.CLASS_DEFINITION + "/" + ServerStrings.SERVER, serverName);
         childObjects[0] = serverDesc;
         ctx1.initBindingsAndPairs(childNames, childClasses, childObjects);

         //construct and set up the attribute definition schema object bindings
         String attrIDS[] = { ServerDescription.ATTR_ID,
            ServerVersions.ATTR_ID,
            ServerDiagnostics.ATTR_ID,
            ServerCounts.ATTR_ID,
            ServerLoginStatus.ATTR_ID };
         ServerSchemaDefContext tempObjects[]
            = new ServerSchemaDefContext[NumOfChildren];
         childNames = new String[NumOfChildren];
         childClasses = new String[NumOfChildren];
         childObjects = new Object[NumOfChildren];
         for(int x=0; x<NumOfChildren; x++)
         {
            childNames[x] = attrIDS[x];
            childClasses[x] =
               new String(ServerStrings.SERVER_SCHEMADEF_CONTEXT_FULLNAME);
            tempObjects[x] = new ServerSchemaDefContext(ServerStrings.CLASS_DEFINITION + "/" + attrIDS[x], serverName);
            childObjects[x] = tempObjects[x];
         }
         ctx2.initBindingsAndPairs(childNames, childClasses, childObjects);

         //set up the server class definition attributes
         childNames = new String[0];
         childClasses = new String[0];
         childObjects = new Object[0];
         serverDesc.initBindingsAndPairs(childNames, childClasses, childObjects);
         String attrNames[] = { ServerStrings.ATTRIBUTES };
         Object attrValues[][] = { {ServerDescription.ATTR_ID,
            ServerVersions.ATTR_ID,
            ServerDiagnostics.ATTR_ID,
            ServerCounts.ATTR_ID,
            ServerLoginStatus.ATTR_ID} };
         serverDesc.initAttributes(attrNames, attrValues);

         //for each individiual attribute definition, set up it's attributes
         String attrValueTypes[] = { 
            ServerStrings.SERVER_DESCRIPTION_ATTRIBUTE_VALUE_TYPE,
            ServerStrings.SERVER_VERSIONS_ATTRIBUTE_VALUE_TYPE,
            ServerStrings.SERVER_DIAGNOSTICS_ATTRIBUTE_VALUE_TYPE,
            ServerStrings.SERVER_COUNTS_ATTRIBUTE_VALUE_TYPE,
            ServerStrings.SERVER_LOGIN_STATUS_ATTRIBUTE_VALUE_TYPE };
         attrNames = new String[NumOfAttributes];
         attrNames[0] = ServerStrings.MODIFIABLE;
         attrNames[1] = ServerStrings.MULTI_SINGLE_VALUED;
         attrNames[2] = ServerStrings.VALUE_TYPE;
         attrValues = new String[NumOfAttributes][1];
         attrValues[0][0] = ServerStrings.NO;
         attrValues[1][0] = ServerStrings.SINGLE;
         for(int x=0; x<NumOfChildren; x++)
         {
            tempObjects[x].initBindingsAndPairs(
               childNames, childClasses, childObjects);
            attrValues[2][0] = attrValueTypes[x];
            tempObjects[x].initAttributes(attrNames, attrValues);
         }
      }
   }

/*
   protected NameParser c_getNameParser(Name name, Continuation cont)
   {
      if (name.isEmpty())
      {
         cont.setSuccess();

         if (parser == null)
            parser = new FlatNameParser("server+schema+" + serverName);

         return (parser);
      }
      else
      {
         Object obj = c_lookup(name, cont);
         cont.setContinue(obj, name, this);
         return (null);
      }
   }
*/

} /* ServerSchemaContext */


