/* **************************************************************************

  $Archive: /njcl_v2rmi/src/com/novell/service/session/InvalidDomainNameException.java $
  $Revision: 15 $
  $Modtime: 1/05/01 4:03p $

  Copyright (c) 1997 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/
package com.novell.service.session;

import java.util.Enumeration;
import java.util.Vector;
import com.novell.service.jncpv2r.clx.*;
import com.novell.java.lang.HasRootCauses;

/**
 * Thrown when a passed-in name is not valid in the context of the
 * method throwing the exception.
 */
public class InvalidDomainNameException
extends SessionException
implements HasRootCauses
{
 /**
  * @internal
  */
   protected Vector rootExceptions = new Vector(0, 1);

   /**
    * Constructs an InvalidDomainNameException with the specified detail
    * message. A detail message is a String that describes this particular
    * exception.
    *
    * @param s The detail message describing this exception.
    */
   public InvalidDomainNameException
   (
      String s
   )
   {
      super(s);
   }

   /**
    * Constructs an InvalidDomainNameException with a specified detail
    * message and a root-cause exception. The root cause exception can
    * be retrieved using getRootCause() method.
    *
    * @param s The detail message describing the exception.
    * @param rootException The root cause exception.
    */
   public InvalidDomainNameException
   (
      String s,
      Throwable rootException
   )
   {
      super(s, rootException);
   }

   /**
    * Retrieves the root cause exception. It is inherited from
    * HasRootCauses.
    *
    * @return Enumeration The root cause exception.
    */
   public Enumeration getRootCauses
   (
   )
   {
      return rootExceptions.elements();
   }

   /**
    * Sets the root causes for this exception.
    *
    */
   public void setRootCauses
   (
      Vector rootCauses
   )
   {
      if (null == rootCauses)
         throw new NullPointerException("rootCauses");
      rootExceptions = (Vector)rootCauses.clone();
   }

   /**
    * Returns a short description of this throwable object.
    *
    * @return A string representation of this Throwable.
    */
   public String toString()
   {
      String s = super.toString();
      if (!rootExceptions.isEmpty())
         s += "; check root causes";
      return s;
   }
}


