/* **************************************************************************

  $Archive: /njcl_v2rmi/src/com/novell/service/session/SessionEnumerator.java $
  $Revision: 12 $
  $Modtime: 1/05/01 4:03p $

  Copyright (c) 1997 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/
package com.novell.service.session;

import com.novell.service.jncpv2r.clx.*;
import com.novell.service.session.*;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import com.novell.service.session.util.Debug;

/**
 * Provides an implementation of Enumeration that contains only Sessions.
 */
public class SessionEnumerator implements Enumeration, Serializable
{
   // Always access debug via final static...hopefully a final static of
   // false will be optimized out by the compiler
   final static private boolean DEBUG = false;
   final static private boolean I_DEBUG = false; // Ignore exception
   final static private boolean S_DEBUG = false; // May have side effects

  /**
   * @internal
   */
   protected Enumeration enum;

  /**
   * Constructs a SessionEnumerator object that specifies an Enumeration
   * of sessions for convenience.
   *
   * @param sessionEnum The passed-in Session enumeration.
   *
   * @exception SessionException Thrown by Session objects.
   */
   public SessionEnumerator
   (
      Enumeration sessionEnum
   )
   throws SessionException
   {
      this.enum = sessionEnum;
   }

   /**
    * @internal
    *
    * Determines if this enumeration contains more elements. The
    * hasMoreElements method is inherited from java.util.Enumeration.
    *
    * @return A boolean set to TRUE if this enumeration contains more
    *         elements, otherwise set to FALSE.
    */
   public boolean hasMoreElements
   (
   )
   {
      return this.enum.hasMoreElements();
   }

   /**
    * @internal
    *
    * Returns the next element of this enumeration. The nextElement
    * method is inherited from java.util.Enumeration.
    *
    * @return The next element of this enumeration.
    *
    * @exception NoSuchElementException Thrown if no more elements exist.  
    */
   public Object nextElement
   (
   )
   throws NoSuchElementException
   {
      return this.enum.nextElement();
   }

   /**
    * @internal
    *
    * Returns a Session for the next object in the enumeration.
    *
    * @return A Session for the next object in the enumeration.
    *
    * @exception NoSuchElementException Thrown if no more elements exist.
    */
   public Session next
   (
   )
   throws NoSuchElementException
   {
      return ((Session)nextElement());
   }

   /**
    * @internal
    *
    * Returns an array of Sessions for the next batchSize elements in the
    * enumeration. If there are no batchSize elements in the enumeration,
    * only those elements retrieved will be returned.
    *
    * @param batchSize The number of elements to return.
    *
    * @return An array of Sessions for the next batchSize elements in
    *         the enumeration.
    *
    * @exception  NoSuchElementException Thrown if no more elements exist.
    */
   public Session[] next
   (
      int batchSize
   )
   {
      Session[] batch = new Session[(int) batchSize];

      try
      {
         for (int i = 0; i < batchSize; i++)
            batch[i] = next();
      }
      catch (NoSuchElementException e)
      {
         if (I_DEBUG)
         {
            Debug.ignoreException(e);
         }
      }


      return batch;
   }
}

