/* **************************************************************************

  $Archive: /njcl_v2rmi/src/com/novell/service/session/bindery/BinderyInitialSessionFactory.java $
  $Revision: 20 $
  $Modtime: 1/12/01 1:00p $

  Copyright (c) 1997 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/
package com.novell.service.session.bindery;

import java.rmi.RemoteException;
import com.novell.service.session.xplat.*;
import com.novell.service.session.*;
import com.novell.service.session.util.Debug;
import com.novell.service.session.spi.*;

/** @internal
 * Default provided InitialSessionFactory, supporting Bindery sessions.
 */
public class BinderyInitialSessionFactory implements InitialSessionFactory
{
   // Always access debug via final static...hopefully a final static of
   // false will be optimized out by the compiler
	final static private boolean DEBUG = false;
	final static private boolean ENTRY_DEBUG = false;
	final static private boolean S_DEBUG = false; // May have side effects

   private SessionImpl initialSession;

   /**
    * Inherited from InitialSessionFactory
    *
    * @see InitialSessionFactory#getInitialSession
    */
   public SessionImpl getInitialSession
   (
      SessionManager sessionManager
   )
   throws SessionException, RemoteException
   {
      if (DEBUG || ENTRY_DEBUG)
      {
         Debug.println("Entry");
      }
      if (null == this.initialSession)
      {
         if(((SessionManagerImpl)sessionManager).useCustomSockets())
            initialSession = new SessionImpl(sessionManager, Bindery.INITIAL_SESSION,
               null, ((SessionManagerImpl)sessionManager).getCustomSocketFactories());
         else
            initialSession = new SessionImpl(sessionManager, Bindery.INITIAL_SESSION);
         
         new BinderyInitialSessionState(this.initialSession);
      }
      if (DEBUG || ENTRY_DEBUG)
      {
         Debug.println("Exit");
      }
      return this.initialSession;
   }
}

