/* **************************************************************************

  $Archive: /njcl_v2rmi/src/com/novell/service/session/bindery/BinderyServerPersistenceService.java $
  $Revision: 14 $
  $Modtime: 1/12/01 3:42p $

  Copyright (c) 1997 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/
package com.novell.service.session.bindery;

import java.rmi.*;
import java.rmi.server.UnicastRemoteObject;
import com.novell.service.session.Session;
import com.novell.service.session.xplat.PersistenceService;
import com.novell.service.session.xplat.Connection;
import com.novell.service.session.spi.*;
import com.novell.service.session.SessionException;

/**@internal
 *
 */
public class BinderyServerPersistenceService extends UnicastRemoteObject
implements PersistenceService
{
   SessionImpl session;

   BinderyServerPersistenceService
   (
      SessionImpl session,
      RMISocketFactories x
   )
   throws RemoteException
   {
      super(x.getPort(), x.getClientSocketFactory(), x.getServerSocketFactory());
      this.session = session;
   }

   BinderyServerPersistenceService
   (
      SessionImpl session
   )
   throws RemoteException
   {
      this.session = session;
   }

   public void persist
   (
   )
   throws SessionException, RemoteException
   {
      BinderyServerSessionState state = (BinderyServerSessionState)session.getState();
      state.connection.keep();
   }

/* This method is commented out in the interface and thus is not available from a remote object
   private void desist
   (
   )
   throws SessionException, java.rmi.RemoteException
   {
      BinderyServerSessionState state = (BinderyServerSessionState)session.getState();
      Session parent = session.getParent();
      InvalidSessionState.makeInvalid(
         (SessionImpl)session,
         new SessionException("BinderyServerPersistenceService.desist() called"));
//      parent.invalidate(session);
      Connection connection = state.connection;
      session.close();
      connection.closeRef();
      parent.validateLinks();
   }
*/
}
