/* **************************************************************************

  $Archive: /njcl_v2rmi/src/com/novell/service/session/spi/InitialSessionFactory.java $
  $Revision: 7 $
  $Modtime: 11/13/00 1:01p $

  Copyright (c) 1997 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/
package com.novell.service.session.spi;

import java.rmi.RemoteException;
import com.novell.service.session.*;

/** @internal
 * Interface to session providers, providing state initialization mechanism
 * for domain-specific providers.
 *
 * Each InitialSessionFactory implementation should provide only
 * one (Singleton) instance of it's initial session.
 *
 */
public interface InitialSessionFactory
{
   /**
    * Return singleton instance of initial session.
    */
   public SessionImpl getInitialSession
   (
      SessionManager sessionManager
   )
   throws SessionException, RemoteException;
}
