/* **************************************************************************

  $Archive: /njcl_v2rmi/src/com/novell/service/session/util/TwoWayHashtable.java $
  $Revision: 7 $
  $Modtime: 11/15/00 3:43p $

  Copyright (c) 1997 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/
package com.novell.service.session.util;

import com.novell.service.session.SessionException;
import java.util.Hashtable;
import java.io.*;

/** @internal
 */
public class TwoWayHashtable extends Hashtable
{
   Hashtable second;

   public TwoWayHashtable(int initialCapacity,
                  float loadFactor)
   {
      super(initialCapacity, loadFactor);
      second = new Hashtable(initialCapacity, loadFactor);
   }

   public TwoWayHashtable(int initialCapacity)
   {
      super(initialCapacity);
      second = new Hashtable(initialCapacity);
   }

   public TwoWayHashtable()
   {
      super();
      second = new Hashtable();
   }

   synchronized public boolean contains(Object value)
   {
      return second.containsKey(value);
   }

   synchronized public Object getKey(Object value)
   {
      return second.get(value);
   }

   synchronized public Object put
   (
      Object key,
      Object value
   )
   {
      second.put(value, key);
      return super.put(key, value);
   }

   synchronized public Object remove(Object key)
   {
      Object value = super.get(key);
      second.remove(value);
      return super.remove(key);
   }

   synchronized public Object removeByValue(Object value)
   {
      Object key = second.get(value);
      super.remove(key);
      return second.remove(value);
   }

   synchronized public void clear()
   {
      super.clear();
      second.clear();
   }
}


