/* **************************************************************************
  $Archive: /njcl_v2rmi/src/com/novell/service/session/xplat/BasicNCPService.java $
  $Revision: 5 $
  $Modtime: 1/12/01 3:53p $

  Copyright (c) 1997 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/
package com.novell.service.session.xplat;

import java.rmi.*;
import java.rmi.server.UnicastRemoteObject;
import com.novell.service.session.*;
import com.novell.service.session.spi.RMISocketFactories;
import com.novell.service.jncp.NSIException;
import com.novell.service.jncpv2r.clx.ClxJNI;
import com.novell.service.session.xplat.NCPServiceRemote.*;

/** @internal
 * Object returned by Session.getService()
 */
public class BasicNCPService extends UnicastRemoteObject
implements NCPServiceRemote
{
   Connection conn;

   public BasicNCPService(Connection connection, RMISocketFactories x)
   throws SessionException, RemoteException
   {
      super(x.getPort(), x.getClientSocketFactory(), x.getServerSocketFactory());
      conn = connection;
   }
   
   public BasicNCPService(Connection connection)
   throws SessionException, RemoteException
   {
      conn = connection;
   }
   
   public FragReqStruct fragmentRequest
   (
      int function,
      int verb,
      int reserved,
      byte[][] reqFrags,
      /*inout*/ byte[][] replyFrags
   )
   throws NSIException, SessionException, RemoteException
   {
      int connHandle = conn.getHandle();
      FragReqStruct reply = new FragReqStruct();
      reply.replyFrags = replyFrags;
      reply.numOfBytes = ClxJNI.NWCCFragmentRequest(
         connHandle, function, verb, reserved, reqFrags, replyFrags);
      return reply;
   }
}
