/* **************************************************************************

  $Archive: /njcl_v2rmi/src/com/novell/service/session/xplat/CallsServiceImpl.java $
  $Revision: 27 $
  $Modtime: 1/19/01 1:57p $

  Copyright (c) 1997 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/
package com.novell.service.session.xplat;

import com.novell.service.jncpv2r.cal.*;
import com.novell.service.session.*;
import com.novell.service.jncp.*;
import com.novell.java.lang.IntegerBuffer;
import com.novell.java.lang.BooleanBuffer;
import com.novell.service.file.nw.*;
import com.novell.service.server.*;
import com.novell.service.ncpext.*;
import com.novell.service.file.nw.calls.*;
import com.novell.service.qms.*;
import java.io.Serializable;
import com.novell.service.session.spi.RMISocketFactories;
import com.novell.service.session.xplat.CallsServiceRemote.*;

/** @internal
 */
public class CallsServiceImpl extends java.rmi.server.UnicastRemoteObject
implements CallsServiceRemote
{
   Connection conn;
   int connection;

   /**
    */
   public CallsServiceImpl
   (
      Connection conn,
      RMISocketFactories x
   )
   throws SessionException, java.rmi.RemoteException
   {
      super(x.getPort(), x.getClientSocketFactory(), x.getServerSocketFactory());

      // Important: get connection for performance but also keep
      // conn so object doesn't go out of scope.
      this.conn = conn;
      connection = conn.getHandle();
   }

   public CallsServiceImpl
   (
      Connection conn
   )
   throws SessionException, java.rmi.RemoteException
   {
      // Important: get connection for performance but also keep
      // conn so object doesn't go out of scope.
      this.conn = conn;
      connection = conn.getHandle();
   }

   public boolean areSLPCallsAvailable()
   throws NSIException, java.rmi.RemoteException
   {
      return CalJNI.areSLPCallsAvailable();
   }

   public int getObjectNamesBeginA
   (
      int type
   )
   throws NSIException, java.rmi.RemoteException
   {
      IntegerBuffer handle = new IntegerBuffer();
      int ccode = CalJNI.NWGetObjectNamesBeginA(type, handle);
      if (0 != ccode)
         throw NSIExceptionBuilder.build(ccode);
      return handle.intValue();
   }

   public NextObjectName getObjectNamesNextA
   (
      int handle,
      int bufLen
   )
   throws NSIException, java.rmi.RemoteException
   {
      NextObjectName x = new NextObjectName();
      x.length.setValue(bufLen);
      int ccode = CalJNI.NWGetObjectNamesNextA(
         new IntegerBuffer(handle),
         x.length,
         x.name);
      if (0 != ccode)
         throw NSIExceptionBuilder.build(ccode);
      return x;
   }

   public void getObjectNamesEndA
   (
      int handle
   )
   throws NSIException, java.rmi.RemoteException
   {
      int ccode = CalJNI.NWGetObjectNamesEndA(new IntegerBuffer(handle));
      if (0 != ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   /**
    */
   public ObjectNameAndType getObjectName
   (
      int objectId
   )
   throws SessionException, java.rmi.RemoteException
   {
      ObjectNameAndType x = new ObjectNameAndType();
      int ccode = CalJNI.NWGetObjectName(
         connection,
         objectId,
         x.name,
         x.type);

      if (0 != ccode)
         throw NSIExceptionBuilder.build(ccode);
      return x;
   }

   /**
    */
   public void freePtr(int mallocedPtr)
   throws SessionException, java.rmi.RemoteException
   {
      CalJNI.freePtr(mallocedPtr);
   }

   /**
    */
   public int allocEAHandle()
   throws SessionException, java.rmi.RemoteException
   {
      return CalJNI.allocEAHandle();
   }

   /**
    */
   public int allocEAFFStruct()
   throws SessionException, java.rmi.RemoteException
   {
      return CalJNI.allocEAFFStruct();
   }

   /**
    */
   public void addObjectToSet
   (
      /*in*/   String   objName,
      /*in*/   int      objType,
      /*in*/   String   propertyName,
      /*in*/   String   memberName,
      /*in*/   int      memberType
   )
   throws SessionException, java.rmi.RemoteException
   {
      int ccode = CalJNI.NWAddObjectToSet(
         connection,
         objName,
         objType,
         propertyName,
         memberName,
         memberType);

      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   /**
    */
   public void changeObjectSecurity
   (
      /*in*/   String objName,
      /*in*/   int objType,
      /*in*/   int newObjSecurity
   )
   throws SessionException, java.rmi.RemoteException
   {
      int ccode = CalJNI.NWChangeObjectSecurity(
         connection,
         objName,
         objType,
         newObjSecurity);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   /**
    */
   public void changePropertySecurity
   (
      /*in*/   String   objName,
      /*in*/   int      objType,
      /*in*/   String   propertyName,
      /*in*/   int      newPropertySecurity
   )
   throws SessionException, java.rmi.RemoteException
   {
      int ccode = CalJNI.NWChangePropertySecurity(
         connection,
         objName,
         objType,
         propertyName,
         newPropertySecurity);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   /**
    */
   public void closeBindery ()
   throws SessionException, java.rmi.RemoteException
   {
      int ccode = CalJNI.NWCloseBindery(connection);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   /**
    */
   public void createObject
   (
      /*in*/   String   objName,
      /*in*/   int      objType,
      /*in*/   int      objFlags,
      /*in*/   int      objSecurity
   )
   throws SessionException, java.rmi.RemoteException
   {
      int ccode = CalJNI.NWCreateObject (
         connection,
         objName,
         objType,
         objFlags,
         objSecurity);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   /**
    */
   public void createProperty
   (
      /*in*/   String   objName,
      /*in*/   int      objType,
      /*in*/   String   propertyName,
      /*in*/   int      propertyFlags,
      /*in*/   int      propertySecurity
   )
   throws SessionException, java.rmi.RemoteException
   {
      int ccode = CalJNI.NWCreateProperty (
         connection,
         objName,
         objType,
         propertyName,
         propertyFlags,
         propertySecurity);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }
   /**
    */
   public void deleteObject
   (
      /*in*/   String   objName,
      /*in*/   int      objType
   )
   throws SessionException, java.rmi.RemoteException
   {
      int ccode = CalJNI.NWDeleteObject(
         connection,
         objName,
         objType);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   /**
    */
   public void deleteObjectFromSet
   (
      /*in*/   String   objName,
      /*in*/   int      objType,
      /*in*/   String   propertyName,
      /*in*/   String   memberName,
      /*in*/   int      memberType
   )
   throws SessionException, java.rmi.RemoteException
   {
      int ccode = CalJNI.NWDeleteObjectFromSet (
         connection,
         objName,
         objType,
         propertyName,
         memberName,
         memberType);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   /**
    */
   public void deleteProperty
   (
      /*in*/   String   objName,
      /*in*/   int      objType,
      /*in*/   String   propertyName
   )
   throws SessionException, java.rmi.RemoteException
   {
      int ccode = CalJNI.NWDeleteProperty (
         connection,
         objName,
         objType,
         propertyName);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   /**
    */
   public void disallowObjectPassword
   (
      /*in*/   String objName,
      /*in*/   int objType,
      /*in*/   String disallowedPassword
   )
   throws SessionException, java.rmi.RemoteException
   {
      int ccode = CalJNI.NWDisallowObjectPassword (
         connection,
         objName,
         objType,
         disallowedPassword);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   /**
    */
   public BinderyAccessLevel getBinderyAccessLevel
   (
   )
   throws SessionException, java.rmi.RemoteException
   {
      BinderyAccessLevel x = new BinderyAccessLevel();
      int ccode = CalJNI.NWGetBinderyAccessLevel (
         connection,
         x.accessLevel,
         x.objID);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
      return x;
   }

   /**
    */
   public ObjectDiskSpaceLeft getObjectDiskSpaceLeft
   (
      /*in*/   int           objID
   )
   throws SessionException, java.rmi.RemoteException
   {
      ObjectDiskSpaceLeft x = new ObjectDiskSpaceLeft();
      int ccode = CalJNI.NWGetObjectDiskSpaceLeft (
         connection,
         objID,
         x.systemElapsedTime,
         x.unusedDiskBlocks,
         x.restrictionEnforced);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
      return x;
   }

   /**
    */
   public int getObjectID
   (
      /*in*/   String   objName,
      /*in*/   int      objType
   )
   throws SessionException, java.rmi.RemoteException
   {
      IntegerBuffer objID = new IntegerBuffer();
      int ccode = CalJNI.NWGetObjectID (
         connection,
         objName,
         objType,
         objID);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
      return objID.intValue();
   }

   /**
    */
   public void isObjectInSet
   (
      /*in*/   String   objName,
      /*in*/   int      objType,
      /*in*/   String   propertyName,
      /*in*/   String   memberName,
      /*in*/   int      memberType
   )
   throws SessionException, java.rmi.RemoteException
   {
      int ccode = CalJNI.NWIsObjectInSet (
         connection,
         objName,
         objType,
         propertyName,
         memberName,
         memberType);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   /**
    */
   public void openBindery
   (
   )
   throws SessionException, java.rmi.RemoteException
   {
      int ccode = CalJNI.NWOpenBindery(connection);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   /**
    */
   public PropertyValue readPropertyValue
   (
      /*in*/   String         objName,
      /*in*/   int            objType,
      /*in*/   String         propertyName,
      /*in*/   int            segmentNum
   )
   throws SessionException, java.rmi.RemoteException
   {
      PropertyValue x = new PropertyValue();
      int ccode = CalJNI.NWReadPropertyValue(
         connection,
         objName,
         objType,
         propertyName,
         segmentNum,
         x.segmentData,
         x.moreSegments,
         x.flags);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
      return x;
   }

   /**
    */
   public void renameObject
   (
      /*in*/   String   oldObjName,
      /*in*/   String   newObjName,
      /*in*/   int      objType
   )
   throws SessionException, java.rmi.RemoteException
   {
      int ccode = CalJNI.NWRenameObject(
         connection,
         oldObjName,
         newObjName,
         objType);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   /**
    */
   public BinderyObject scanObject
   (
      /*in*/      String         searchName,
      /*in*/      int            searchType,
      /*in*/      int            objID
   )
   // the rights are not returned through this API because the NCP does
   //   not support the rights because it was written for the 2.x rights
   //   scheme.  To get a valid rights mask for the path, call the
   //   NWScanForTrustees method in this class.
   throws SessionException, java.rmi.RemoteException
   {
      IntegerBuffer  objectID           = new IntegerBuffer(objID);
      StringBuffer   objName            = new StringBuffer();
      IntegerBuffer  objType            = new IntegerBuffer();
      IntegerBuffer  hasPropertiesFlag  = new IntegerBuffer();
      IntegerBuffer  objFlags           = new IntegerBuffer();
      IntegerBuffer  objSecurity        = new IntegerBuffer();

      int ccode = CalJNI.NWScanObject(
         connection,
         searchName,
         searchType,
         objectID,
         objName,
         objType,
         hasPropertiesFlag,
         objFlags,
         objSecurity);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
      return new BinderyObject(
         objectID.intValue(),
         objName.toString(),
         objType.intValue(),
         hasPropertiesFlag.intValue(),
         objFlags.intValue(),
         objSecurity.intValue());
   }

   /**
    */
   public BinderyObjectProperty scanProperty
   (
      /*in*/   String         objName,
      /*in*/   int            objType,
      /*in*/   String         searchPropertyName,
      /*in*/   int            iterHandle
   )
   throws SessionException, java.rmi.RemoteException
   {
      BinderyObjectProperty x = new BinderyObjectProperty();
      x.iterHandle.setValue(iterHandle);
      int ccode = CalJNI.NWScanProperty(
         connection,
         objName,
         objType,
         searchPropertyName,
         x.iterHandle,
         x.propertyName,
         x.propertyFlags,
         x.propertySecurity,
         x.valueAvailable,
         x.moreFlag);
      if(ccode != 0)
      {
         //Hack to get around problem that moreFlag must be changed even though an
         //exception is thrown. When running remote x.moreFlag is a copy
         //See BinderyObjectDirContext for an explanation
         if(ccode == ServerErrors.NWE_BIND_NO_SUCH_PROP && x.moreFlag.intValue() == 0)
            throw NSIExceptionBuilder.build(ccode, new Exception("HACK for scanProperty"));
         else
            throw NSIExceptionBuilder.build(ccode);
      }
      return x;
   }

   /**
    */
   public void writePropertyValue
   (
      /*in*/   String   objName,
      /*in*/   int      objType,
      /*in*/   String   propertyName,
      /*in*/   int      segmentNum,
      /*in*/   byte[]  segmentData, //128 byte buffer.
      /*in*/   boolean  moreSegments
   )
   throws SessionException, java.rmi.RemoteException
   {
      int ccode = CalJNI.NWWritePropertyValue(
         connection,
         objName,
         objType,
         propertyName,
         segmentNum,
         segmentData, //128 byte bu
         moreSegments);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   /**
    */
   public DirectoryEntryInformation getNSEntryInfo
   (
      int dirHandle,
      String path,
      int srcNamSpc,
      int dstNamSpc,
      int attributes,
      int retInfoMask
   )
   throws SessionException, java.rmi.RemoteException
   {
      DirectoryEntryInformation dei = new DirectoryEntryInformation();
      int ccode = CalJNI.NWGetNSEntryInfo(
         connection,
         dirHandle,
         path,
         srcNamSpc,
         dstNamSpc,
         attributes,
         retInfoMask,
         dei);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
      return dei;
   }

   /**
    */
   public DirectoryEntryInformationPlus scanNSEntryInfo
   (
      int dirHandle,
      int nameSpace,
      int attr,
      int[] volNumber,
      int[] dirNumber,
      int[] searchDirNumber,
      String pattern,
      int retInfoMask
   )
   throws SessionException, java.rmi.RemoteException
   {
      DirectoryEntryInformation dei = new DirectoryEntryInformation();
      int ccode = CalJNI.NWScanNSEntryInfo(
         connection,
         dirHandle,
         nameSpace,
         attr,
         volNumber,
         dirNumber,
         searchDirNumber,
         pattern,
         retInfoMask,
         dei);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
      DirectoryEntryInformationPlus deip = new DirectoryEntryInformationPlus();
      deip.dei = dei;
      deip.volNumber = volNumber;
      deip.dirNumber = dirNumber;
      deip.searchDirNumber = searchDirNumber;
      return deip;
   }

   /**
    */
   public String getVolumeName
   (
      int volNumber
   )
   throws SessionException, java.rmi.RemoteException
   {
      String[] volName = new String[1];
      int ccode = CalJNI.NWGetVolumeName(
         connection,
         volNumber,
         volName);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
      return volName[0];
   }

   /**
    */
   public int getVolumeNumber
   (
      String volName
   )
   throws SessionException, java.rmi.RemoteException
   {
      int[] volNum = new int[1];
      int ccode = CalJNI.NWGetVolumeNumber(
         connection,
         volName,
         volNum);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
      return volNum[0];
   }

   /**
    */
   public int[] getNSLoadedList
   (
      int volNumber
   )
   throws SessionException, java.rmi.RemoteException
   {
      int[][] NSLoadedList = new int[1][];
      int ccode = CalJNI.NWGetNSLoadedList(
         connection,
         volNumber,
         NSLoadedList);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
      return NSLoadedList[0];
   }

   /**
    */
   public int openCreateNSEntry
   (
      int dirHandle,
      String path,
      int nameSpace,
      int openCreateMode,
      int searchSessionAttrSet,
      int createSessionAttrSet,
      int accessRights
   )
   throws SessionException, java.rmi.RemoteException
   {
      int[] fileHandle = new int[1];
      int ccode = CalJNI.NWOpenCreateNSEntry(
         connection,
         dirHandle,
         path,
         nameSpace,
         openCreateMode,
         searchSessionAttrSet,
         createSessionAttrSet,
         accessRights,
         fileHandle);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
      return fileHandle[0];
   }

   /**
    */
   public int openNSEntry
   (
      int dirHandle,
      int nameSpace,
      int dataStream,
      String path,
      int openCreateMode,
      int searchSessionAttrSet,
      int createSessionAttrSet,
      int accessRights
   )
   throws SessionException, java.rmi.RemoteException
   {
      int[] fileHandle = new int[1];
      int ccode = CalJNI.NWOpenNSEntry(
         connection,
         dirHandle,
         nameSpace,
         dataStream,
         path,
         openCreateMode,
         searchSessionAttrSet,
         createSessionAttrSet,
         accessRights,
         fileHandle);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
      return fileHandle[0];
   }

   /**
    */
   public void deleteNSEntry
   (
      int dirHandle,
      String filePath,
      int nameSpace,
      int searchAttr
   )

   throws SessionException, java.rmi.RemoteException
   {
      int ccode = CalJNI.NWDeleteNSEntry(
         connection,
         dirHandle,
         filePath,
         nameSpace,
         searchAttr);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   /**
    */
   public void NSRename
   (
      int dirHandle,
      int nameSpace,
      String oldName,
      boolean isFile,
      String newName,
      boolean renameInAllNS
   )

   throws SessionException, java.rmi.RemoteException
   {
      int ccode = CalJNI.NWNSRename(
         connection,
         dirHandle,
         nameSpace,
         oldName,
         isFile,
         newName,
         renameInAllNS);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   /**
    */
   public void openEA
   (
      int dirHandle,
      String path,
      String EAName,
      int nameSpace,
      int EAHandle
   )

   throws SessionException, java.rmi.RemoteException
   {
      int ccode = CalJNI.NWOpenEA(
         connection,
         dirHandle,
         path,
         EAName,
         nameSpace,
         EAHandle);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   /**
    */
   public void closeEA
   (
      int EAHandle
   )
   throws SessionException, java.rmi.RemoteException
   {
      int ccode = CalJNI.NWCloseEA(EAHandle);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   /**
    */
   public ReadEA readEA
   (
      int EAHandle,
      int off,
      int len
   )
   throws SessionException, java.rmi.RemoteException
   {
      ReadEA x = new ReadEA(len);
      int ccode = CalJNI.NWReadEA(
         EAHandle,
         x.buf,
         off,
         len,
         x.totalEASize,
         x.bytesRead);
      if(ccode == 1) //Special case where the information in "x" must be returned even though there is a non-zero ccode
      {
         x.ccode = ccode;
         ccode = 0;
      }
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
      return x;
   }

   /**
    */
   public int writeEA
   (
      int EAHandle,
      int totalWriteSize,
      byte[] buf,
      int off,
      int len
   )
   throws SessionException, java.rmi.RemoteException
   {
      int[] bytesWritten = new int[1];
      int ccode = CalJNI.NWWriteEA(
         EAHandle,
         totalWriteSize,
         buf,
         off,
         len,
         bytesWritten);
      if(ccode == 1) //Special case where bytesWritten must be returned even though there is a non-zero ccode
         throw NSIExceptionBuilder.build(ccode, NSIExceptionBuilder.build(bytesWritten[0]));
      if(ccode != 0)
         throw NSIExceptionBuilder.build(ccode);
      return bytesWritten[0];
   }

   public String findFirstEA
   (
      int dirHandle,
      String path,
      int dstNamSpc,
      int EAFFStruct,
      int EAHandle
   )
   throws SessionException, java.rmi.RemoteException
   {
      StringBuffer EAName = new StringBuffer();
      int ccode = CalJNI.NWFindFirstEA(connection, dirHandle, path, dstNamSpc,
         EAFFStruct, EAHandle, EAName);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
      return EAName.toString();
   }

   /**
    */
   public String findNextEA
   (
      int EAFFStruct,
      int EAHandle
   )
   throws SessionException, java.rmi.RemoteException
   {
      StringBuffer EAName = new StringBuffer();
      int ccode = CalJNI.NWFindNextEA(EAFFStruct, EAHandle, EAName);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
      return EAName.toString();
   }


   // assumes that there are already 20 elements allocated in the
   //   'trusteeList' member of 'tEnum'
   /**
    */
   public TrusteeEnumeratorStruct scanForTrustees
   (
      int dirHandle,
      String path,
      int nameSpace,
      int iterHandle
   )
   throws SessionException, java.rmi.RemoteException
   {
      TrusteeEnumeratorStruct x = new TrusteeEnumeratorStruct();
      x.iterHandle = iterHandle;
      int ccode = CalJNI.NWScanForTrustees(
         connection,
         dirHandle,
         path,
         nameSpace,
         x);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
      return x;
   }

   /**
    */
   public DirSpaceLimit getDirSpaceLimitList
   (
      int dirHandle,
      String path,
      int nameSpace
   )
   throws SessionException, java.rmi.RemoteException
   {
      DirSpaceLimit x = new DirSpaceLimit();
      int ccode = CalJNI.NWGetDirSpaceLimitList(
         connection,
         dirHandle,
         path,
         nameSpace,
         x.maxAvailable,
         x.currentUse);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
      return x;
   }

   /**
    */
   public void setDirSpaceLimit
   (
      int dirHandle,
      String path,
      int nameSpace,
      int limit
   )
   throws SessionException, java.rmi.RemoteException
   {
      int ccode = CalJNI.NWSetDirSpaceLimit(
         connection,
         dirHandle,
         path,
         nameSpace,
         limit);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   /**
    */
   public int setCompressedFileSize
   (
      int OSFileHandle,
      int desiredSize
   )
   throws SessionException, java.rmi.RemoteException
   {
      int[] actualSize = new int[1];
      int ccode = CalJNI.NWSetCompressedFileSize(
         connection,
         OSFileHandle,
         desiredSize,
         actualSize);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
      return actualSize[0];
   }

   /**
    */
   public void addTrustee
   (
      int dirHandle,
      String path,
      int nameSpace,
      int objID,
      int rightsMask
   )
   throws SessionException, java.rmi.RemoteException
   {
      int ccode = CalJNI.NWAddTrustee(
         connection,
         dirHandle,
         path,
         nameSpace,
         objID,
         rightsMask);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   /**
    */
   public void deleteTrustee
   (
      int dirHandle,
      String path,
      int nameSpace,
      int objID
   )
   throws SessionException, java.rmi.RemoteException
   {
      int ccode = CalJNI.NWDeleteTrustee(
         connection,
         dirHandle,
         path,
         nameSpace,
         objID);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   /**
    */
   public void getNSInfo
   (
      int volume,
      int nameSpace
//      NSInformation info
   )
   throws SessionException, java.rmi.RemoteException
   {
/*
      int ccode = CalJNI.NWGetNSInfo(
         connection,
         volume,
         nameSpace,
         info);
      if (0!= ccode)
*/
      throw new SessionRuntimeException("Not implemented");
//      int ccode = 0;
//         throw NSIExceptionBuilder.build(ccode);
   }

   // the 'data' array must be 512 bytes long
   /**
    */
   public byte[] readNSInfo
   (
      int dirHandle,
      String path,
      int nameSpace,
      int dstNameSpace,
      int NSInfoBitMask
   )
   throws SessionException, java.rmi.RemoteException
   {
      byte[] data = new byte[512];
      int ccode = CalJNI.NWReadNSInfo(
         connection,
         dirHandle,
         path,
         nameSpace,
         dstNameSpace,
         NSInfoBitMask,
         data);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
      return data;
   }

   // the 'data' array must be 512 bytes long
   /**
    */
   public void writeNSInfo
   (
      int dirHandle,
      String path,
      int nameSpace,
      int dstNameSpace,
      int NSInfoBitMask,
      byte[] data       // input parameter
   )
   throws SessionException, java.rmi.RemoteException
   {
      int ccode = CalJNI.NWWriteNSInfo(
         connection,
         dirHandle,
         path,
         nameSpace,
         dstNameSpace,
         NSInfoBitMask,
         data);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   // the 'hugeData' array must be big enough to hold any huge data that the
   //   server may choose to send -- it's not doc'd in the NCP doc how big
   // the 'hugeStateInfo' is a 16-byte iter handle
   /**
    */
   public void readExtendedNSInfo
   (
      int dirHandle,
      String path,
      int nameSpace,
      int dstNameSpace,
      int extendedBitMask,
      byte[] hugeStateInfo,
      int[] hugeDataLength,   // output parameter
      byte[] hugeData         // output parameter
   )
   throws SessionException, java.rmi.RemoteException
   {
      throw new SessionRuntimeException("Not implemented");
/*
      int ccode = CalJNI.NWReadExtendedNSInfo(
         connection,
         dirHandle,
         path,
         nameSpace,
         dstNameSpace,
         extendedBitMask,
         hugeStateInfo,
         hugeDataLength,   // output paramete
         hugeData );        // output paramete


      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
*/
   }

   // the 'hugeStateInfo' is a 16-byte iter handle
   // when this function returns, 'hugeDataLength' will contain an int
   //   that is returned from the server specifying how much of the huge
   //   data was consumed by the name space module
   /**
    */
   public void writeExtendedNSInfo
   (
      int dirHandle,
      String path,
      int nameSpace,
      int dstNameSpace,
      int extendedBitMask,
      byte[] hugeStateInfo,
      int[] hugeDataLength,   // input/output parameter
      byte[] hugeData,        // input parameter
      int offset
   )
   throws SessionException, java.rmi.RemoteException
   {
      throw new SessionRuntimeException("Not implemented");
/*
      int ccode = CalJNI.NWWriteExtendedNSInfo(
         connection,
         dirHandle,
         path,
         nameSpace,
         dstNameSpace,
         extendedBitMask,
         hugeStateInfo,
         hugeDataLength,
         hugeData,
         offset);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
*/
   }

   // the C code underneath really uses the MODIFY_DOS_INFO struct
   //   we're just passing in a DirectoryEntryInformation , because it has
   //   all the information in it that we need.
   // the modifyMask that we pass in here is passed straight to the lib,
   //   and does NOT correspond with the IM_... constants.
   /**
    */
   public void setNSEntryDOSInfo
   (
      int dirHandle,
      String path,
      int nameSpace,
      int searchAttr,
      int modifyMask,
      DirectoryEntryInformation info
   )
   throws SessionException, java.rmi.RemoteException
   {
      int ccode = CalJNI.NWSetNSEntryDOSInfo(
         connection,
         dirHandle,
         path,
         nameSpace,
         searchAttr,
         modifyMask,
         info);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   /**
    */
   public VolumeInformationBase getVolumeInfoWithNumber
   (
      int volNumber
   )
   throws SessionException, java.rmi.RemoteException
   {
      VolumeInformationBase info = new VolumeInformationBase();
      int ccode = CalJNI.NWGetVolumeInfoWithNumber(
         connection,
         volNumber,
         info);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
      return info;
   }

   /**
    */
   public VolumeInformationExtended getExtendedVolumeInfo
   (
      int volNumber
   )
   throws SessionException, java.rmi.RemoteException
   {
      VolumeInformationExtended info = new VolumeInformationExtended();
      int ccode = CalJNI.NWGetExtendedVolumeInfo(
         connection,
         volNumber,
         info);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
      return info;
   }

   /**
    */
   public DirectorySpaceInformation getDirSpaceInfo
   (
      int volNumber,
      String path,
      int nameSpace
   )
   throws SessionException, java.rmi.RemoteException
   {
      DirectorySpaceInformation info = new DirectorySpaceInformation();
      int ccode = CalJNI.NWGetDirSpaceInfo(
         connection,
         volNumber,
         path,
         nameSpace,
         info);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
      return info;
   }
   /**
    */
   public VolumeUtilization getDiskUtilization
   (
      int objID,
      int volNum
   )
   throws SessionException, java.rmi.RemoteException
   {
      VolumeUtilization data = new VolumeUtilization();
      int ccode = CalJNI.NWGetDiskUtilization(
         connection,
         objID,
         volNum,
         data);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
      return data;
   }

   /**
    */
   public VolumeRestriction getObjDiskRestrictions
   (
      int volNumber,
      int objectId
   )
   throws SessionException, java.rmi.RemoteException
   {
      VolumeRestriction data = new VolumeRestriction();
      int ccode = CalJNI.NWGetObjDiskRestrictions(
         connection,
         volNumber,
         objectId,
         data);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
      return data;
   }

   /**
    */
   public VolumeRestrictionEnumeratorStruct scanVolDiskRestrictions2
   (
      int volNumber,
      int iterHandle
   )
   throws SessionException, java.rmi.RemoteException
   {
      VolumeRestrictionEnumeratorStruct data =
         new VolumeRestrictionEnumeratorStruct(iterHandle);
      int ccode = CalJNI.NWScanVolDiskRestrictions2(
         connection,
         volNumber,
         data);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
      return data;
   }

   /**
    */
   public void removeObjectDiskRestrictions
   (
      int volNumber,
      int objectId
   )
   throws SessionException, java.rmi.RemoteException
   {
      int ccode = CalJNI.NWRemoveObjectDiskRestrictions(
         connection,
         volNumber,
         objectId);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   /**
    */
   public void setObjectVolSpaceLimit
   (
      int volNumber,
      int objectId,
      int restriction
   )
   throws SessionException, java.rmi.RemoteException
   {
      int ccode = CalJNI.NWSetObjectVolSpaceLimit(
         connection,
         volNumber,
         objectId,
         restriction);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   /**
    */
   public void smMountVolume
   (
      String volName,
      int[] volNumber
   )
   throws SessionException, java.rmi.RemoteException
   {
      int ccode = CalJNI.NWSMMountVolume(
         connection,
         volName,
         volNumber);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   /**
    */
   public void smDismountVolumeByName
   (
      String volName
   )
   throws SessionException, java.rmi.RemoteException
   {
      int ccode = CalJNI.NWSMDismountVolumeByName(
         connection,
         volName);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   /**
    */
   public MountedVolumes scanMountedVolumes
   (
      int startVolNumber
   )
   throws SessionException, java.rmi.RemoteException
   {
      MountedVolumes x = new MountedVolumes();
      int ccode = CalJNI.NWScanMountedVolumes(
            this.connection,
            startVolNumber,
            x.numbers,
            x.names,
            x.nextVolNumber);
      if (ccode != 0)
         throw NSIExceptionBuilder.build(ccode);
      return x;
   }

   /**
    */
   public int allocTempNSDirHandle
   (
      int dirHandle,
      String path,
      int srcNameSpace,
      int dstNameSpace
   )
   throws SessionException, java.rmi.RemoteException
   {
      int[] newDirHandle = new int[1];
      int ccode = CalJNI.NWAllocTempNSDirHandle(
            this.connection,
            dirHandle,
            path,
            srcNameSpace,
            dstNameSpace,
            newDirHandle);

      if (ccode != 0)
         throw NSIExceptionBuilder.build(ccode);
      return newDirHandle[0];
   }

   /**
    */
   public void deallocateDirectoryHandle
   (
      int dirHandle
   )
   throws SessionException, java.rmi.RemoteException
   {
      int ccode = CalJNI.NWDeallocateDirectoryHandle(
            this.connection,
            dirHandle);

      if (ccode != 0)
         throw NSIExceptionBuilder.build(ccode);
   }

   /**
    */
   public void scanForDeletedFiles
   (
      int dirHandle,
      int[] iterHandle,
      int[] volNum,
      int[] dirBase,
      DeletedFileInfoImpl info
   )
   throws SessionException, java.rmi.RemoteException
   {
      throw new SessionRuntimeException("Not implemented");
/*
      int ccode = CalJNI.NWScanForDeletedFiles(
            this.connection,
            dirHandle,
            iterHandle,
            volNum,
            dirBase,
            info);

      if (ccode != 0)
         throw NSIExceptionBuilder.build(ccode);
*/
   }

   /**
    */
   public void purgeDeletedFile
   (
      int dirHandle,
      int iterHandle,
      int volNum,
      int dirBase,
      String delFileName
   )
   throws SessionException, java.rmi.RemoteException
   {
      int ccode = CalJNI.NWPurgeDeletedFile(
            this.connection,
            dirHandle,
            iterHandle,
            volNum,
            dirBase,
            delFileName);

      if (ccode != 0)
         throw NSIExceptionBuilder.build(ccode);
   }

   //
   // does not support the 2.x variant of NWRecoverDeletedFile
   //

   /**
    */
   public void recoverDeletedFile
   (
      int dirHandle,
      int iterHandle,
      int volNum,
      int dirBase,
      String delFileName,
      String newFileName
   )
   throws SessionException, java.rmi.RemoteException
   {
      int ccode = CalJNI.NWRecoverDeletedFile(
            this.connection,
            dirHandle,
            iterHandle,
            volNum,
            dirBase,
            delFileName,
            newFileName);

      if (ccode != 0)
         throw NSIExceptionBuilder.build(ccode);
   }

   /**
    */
   public int getEffectiveRights
   (
      int dirHandle,
      String path,
      int nameSpace
   )
   throws SessionException, java.rmi.RemoteException
   {
      int[] effectiveRights = new int[1];
      int ccode = CalJNI.NWGetEffectiveRights(
            this.connection,
            dirHandle,
            path,
            nameSpace,
            effectiveRights);

      if (ccode != 0)
         throw NSIExceptionBuilder.build(ccode);
      return effectiveRights[0];
   }

   /**
    */
   public int getObjectEffectiveRights
   (
      int objID,
      int dirHandle,
      String path,
      int nameSpace
   )
   throws SessionException, java.rmi.RemoteException
   {
      int[] rights = new int[1];
      int ccode = CalJNI.NWGetObjectEffectiveRights(
            connection,
            objID,
            dirHandle,
            path,
            nameSpace,
            rights);

      if (0 != ccode)
         throw NSIExceptionBuilder.build(ccode);
      return rights[0];
   }

   /**
    */
   public TrusteePath scanObjectTrusteePaths
   (
      int objID,
      int volNumber,
      int nameSpace,
      int iterHandle
   )
   throws SessionException, java.rmi.RemoteException
   {
      TrusteePath x = new TrusteePath();
      x.iterHandle[0] = iterHandle;
      int ccode = CalJNI.NWScanObjectTrusteePaths(
            connection,
            objID,
            volNumber,
            nameSpace,
            x.iterHandle,
            x.rights,
            x.path);

      if (0 != ccode)
         throw NSIExceptionBuilder.build(ccode);

      return x;
   }

/* *************************************************************************
* NCP extension natives
****************************************************************************/

   /**
    */
   public NCPExtensionInfoImpl getNCPExtensionInfo
   (
      String extensionName
   )
   throws SessionException, java.rmi.RemoteException
   {
      NCPExtensionInfoImpl extension =
         new NCPExtensionInfoImpl(extensionName);
      int ccode = CalJNI.NWGetNCPExtensionInfoByName(
         connection,
         extension);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
      return extension;
   }

   /**
    */
   public NCPExtensionInfoImpl getNCPExtensionInfo
   (
      int id
   )
   throws SessionException, java.rmi.RemoteException
   {
      NCPExtensionInfoImpl extension =
         new NCPExtensionInfoImpl(id);
      int ccode = CalJNI.NWGetNCPExtensionInfoByName(
         connection,
         extension);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
      return extension;
   }

   /**
    */
   public Object ncpExtensionRequest
   (
      /*in*/   int      extensionID,
      /*in*/   byte[]   request,
      /*in*/   short    maxReplyLength
   )
   throws SessionException, java.rmi.RemoteException
   {
      Object[] replyHolder = new Object[1];
      int ccode = CalJNI.NWNCPExtensionRequest(
         connection,
         extensionID,
         request,
         maxReplyLength,
         replyHolder);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
      return replyHolder[0];
   }

   /**
    */
   synchronized public NCPExtensionInfoImpl scanNCPExtensions
   (
      int id
   )
   throws SessionException, java.rmi.RemoteException
   {
      NCPExtensionInfoImpl extension =
         new NCPExtensionInfoImpl(id);
      int ccode = CalJNI.NWScanNCPExtensions(
         connection,
         extension);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
      return(extension);
   }

   /**
    */
   public NWQueueJob createQueueFile2
   (
      int            queueID,
      NWQueueJob     job
   )
   throws SessionException, java.rmi.RemoteException
   {
      IntegerBuffer  fileHandle = new IntegerBuffer();

      int ccode = CalJNI.NWCreateQueueFile2(
         connection,
         queueID,
         job,
         fileHandle);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
      job.setLocalFileHandle(fileHandle.intValue());
      return job;
   }

   /**
    */
   public void closeFileAndAbortQueueJob2
   (
      int   queueID,
      int   jobNumber,
      int   fileHandle
   )

   throws SessionException, java.rmi.RemoteException
   {
      int ccode = CalJNI.NWCloseFileAndAbortQueueJob2(
         connection,
         queueID,
         jobNumber,
         fileHandle);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   /**
    */
   public void closeFileAndStartQueueJob2
   (
      int   queueID,
      int   jobNumber,
      int   fileHandle
   )

   throws SessionException, java.rmi.RemoteException
   {
      int ccode = CalJNI.NWCloseFileAndStartQueueJob2(
         connection,
         queueID,
         jobNumber,
         fileHandle);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   /**
    */
   public void abortServicingQueueJob2
   (
      int   queueID,
      int   jobNumber,
      int   fileHandle
   )
   throws SessionException, java.rmi.RemoteException
   {
      int ccode = CalJNI.NWAbortServicingQueueJob2(
         connection,
         queueID,
         jobNumber,
         fileHandle);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   public void attachQueueServerToQueue
   (
      int   queueID
   )
   throws SessionException, java.rmi.RemoteException
   {
      int ccode = CalJNI.NWAttachQueueServerToQueue(
         this.connection,
         queueID);
      if(0 != ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   /**
    */
   public NWQueueJob changeQueueJobEntry2
   (
      int queueID,
      NWQueueJob   job
   )
   throws SessionException, java.rmi.RemoteException
   {
      int ccode = CalJNI.NWChangeQueueJobEntry2(
         connection,
         queueID,
         job);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
      return job;
   }

   /**
    */
   public void changeQueueJobPosition2
   (
      int queueID,
      int jobNumber,
      int newJobPos
   )

   throws SessionException, java.rmi.RemoteException
   {
      int ccode = CalJNI.NWChangeQueueJobPosition2(
         connection,
         queueID,
         jobNumber,
         newJobPos);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }
   /**
    */
   public void changeToClientRights2
   (
      int   queueID,
      int   jobNumber
   )
   throws SessionException, java.rmi.RemoteException
   {
      int ccode = CalJNI.NWChangeToClientRights2(
         this.connection,
         queueID,
         jobNumber);
      if(0 != ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   public QueueJobListReply getQueueJobList2
   (
      int               queueID,
      int               queueStartPos,
      QueueJobListReply job
   )
   throws SessionException, java.rmi.RemoteException
   {
      int ccode = CalJNI.NWGetQueueJobList2(
         connection,
         queueID,
         queueStartPos,
         job);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
      return job;
   }

/*
   public void readQueueCurrentSessionAttrSet2
   (
      int queueID,
      IntegerBuffer queueSessionAttrSet,
      IntegerBuffer numberOfJobs,
      IntegerBuffer numberOfServers,
      int[] serverIDlist,
      int[] serverConnList
   )
   throws SessionException, java.rmi.RemoteException
   {
      int ccode = CalJNI.NWReadQueueCurrentSessionAttrSet2(
                                                  connection,
                                                  queueID,
                                                  queueSessionAttrSet,
                                                  numberOfJobs,
                                                  numberOfServers,
                                                  serverIDlist,
                                                  serverConnList);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }
*/

   /**
    */
   public QueueCurrentStatus readQueueCurrentStatus2
   (
         /*in*/   int   queueID
   )
   throws SessionException, java.rmi.RemoteException
   {
      QueueCurrentStatus x = new QueueCurrentStatus();
      int ccode = CalJNI.NWReadQueueCurrentStatus2 (
         connection,
         queueID,
         x.queueStatus,
         x.numberOfJobs,
         x.numberOfServers,
         x.serverIDlist,
         x.serverConnList);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
      return x;
   }


   /**
    */
   public NWQueueJob readQueueJobEntry2
   (
      int               queueID,
      int               jobNumber,
      NWQueueJob        job
   )
   throws SessionException, java.rmi.RemoteException
   {
      int ccode = CalJNI.NWReadQueueJobEntry2(
         connection,
         queueID,
         jobNumber,
         job);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
      return job;
   }

   /**
    */
   public void removeJobFromQueue2
   (
      int queueID,
      int jobNumber
   )
   throws SessionException, java.rmi.RemoteException
   {
      int ccode = CalJNI.NWRemoveJobFromQueue2(
         connection,
         queueID,
         jobNumber);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   public NWQueueJob serviceQueueJob2
   (
      int   queueID,
      int   targetJobType,
      NWQueueJob job
   )
   throws SessionException, java.rmi.RemoteException
   {
      IntegerBuffer  fileHandle = new IntegerBuffer();

      int ccode = CalJNI.NWServiceQueueJob2(
         this.connection,
         queueID,
         targetJobType,
         job,
         fileHandle);
      if(0 != ccode)
         throw NSIExceptionBuilder.build(ccode);
      job.setLocalFileHandle(fileHandle.intValue());
      return job;
   }

/*
   public void setQueueCurrentSessionAttrSet2
   (
      int queueID,
      int queueSessionAttrSet
   )
   throws SessionException, java.rmi.RemoteException
   {
      int ccode = CalJNI.NWSetQueueCurrentSessionAttrSet2(
                                                 connection,
                                                 queueID,
                                                 queueSessionAttrSet);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }
*/

   /**
    */
   public void setQueueCurrentStatus2 (
         /*in*/   int queueID,
         /*in*/   int queueStatus)
   throws SessionException, java.rmi.RemoteException
   {
      int ccode = CalJNI.NWSetQueueCurrentStatus2(
         connection,
         queueID,
         queueStatus);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   /**
    */
   public int createQueue
   (
      String   queueName,
      int      queueType,
      int      dirPath,
      String   path
   )
   throws SessionException, java.rmi.RemoteException
   {
      IntegerBuffer queueID = new IntegerBuffer();
      int ccode = CalJNI.NWCreateQueue(
         connection,
         queueName,
         queueType,
         dirPath,
         path,
         queueID);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
      return queueID.intValue();
   }

   /**
    */
   public void destroyQueue
   (
      int queueID
   )
   throws SessionException, java.rmi.RemoteException
   {
      int ccode = CalJNI.NWDestroyQueue(
         connection,
         queueID);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   public void detachQueueServerFromQueue
   (
      int   queueID
   )
   throws SessionException, java.rmi.RemoteException
   {
      int ccode = CalJNI.NWDetachQueueServerFromQueue(
         this.connection, queueID);
      if(0 != ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   public void finishServicingQueueJob2
   (
      int   queueID,
      int   jobNumber,
      int   fileHandle
   )
   throws SessionException, java.rmi.RemoteException
   {
      int ccode = CalJNI.NWFinishServicingQueueJob2(
         this.connection,
         queueID,
         jobNumber,
         fileHandle);
      if(0 != ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   /**
    */
   public int getQueueJobFileSize2
   (
      int queueID,
      int jobNumber
   )
   throws SessionException, java.rmi.RemoteException
   {
      IntegerBuffer fileSize = new IntegerBuffer();
      int ccode = CalJNI.NWGetQueueJobFileSize2(
         connection,
         queueID,
         jobNumber,
         fileSize);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
      return fileSize.intValue();
   }


/* *************************************************************************
* Server natives
****************************************************************************/

   /**
    */
   public CVersionInfo getFileServerVersionInfo
   (
   )
   throws SessionException, java.rmi.RemoteException
   {
      CVersionInfo info = new CVersionInfo();
      int ccode = CalJNI.NWGetFileServerVersionInfo(
         connection,
         info);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
      return info;
   }

   /**
    */
   public CNWFSEFileServerInfo getFileServerInfo
   (
   )
   throws SessionException, java.rmi.RemoteException
   {
      CNWFSEFileServerInfo info = new CNWFSEFileServerInfo();
      int ccode = CalJNI.NWGetFileServerInfo(
         connection,
         info);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
      return info;
   }

   /**
    */
   public boolean getFileServerLoginStatus
   (
   )
   throws SessionException, java.rmi.RemoteException
   {
      BooleanBuffer info = new BooleanBuffer(false);
      int ccode = CalJNI.NWGetFileServerLoginStatus(
         connection, info);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
      return info.booleanValue();
   }

   /**
    */
   public void loadNLM(String loadCommand)
   throws SessionException, java.rmi.RemoteException
   {
      int ccode = CalJNI.NWSMLoadNLM(connection, loadCommand);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   /**
    */
   public void unloadNLM(String NLMName)
   throws SessionException, java.rmi.RemoteException
   {
      int ccode = CalJNI.NWSMUnloadNLM(connection, NLMName);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   /**
    */
   public FileServerDescription getFileServerDescription
   (
   )
   throws SessionException, java.rmi.RemoteException
   {
      FileServerDescription x = new FileServerDescription();
      int ccode = CalJNI.NWGetFileServerDescription(
         connection,
         x.companyName,
         x.revision,
         x.revisionDate,
         x.copyrightNotice);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
      return x;
   }

   /**
    */
   public Object getFileServerDateAndTime
   (
   )
   throws SessionException, java.rmi.RemoteException
   {
      Object[] holder = new Object[1];
      int ccode = CalJNI.NWGetFileServerDateAndTime(
         connection,
         holder);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
      return holder[0];
   }

   /**
    */
   public void setFileServerDateAndTime
   (
      int year,
      int month,
      int day,
      int hour,
      int minute,
      int second
   )
   throws SessionException, java.rmi.RemoteException
   {
      int ccode = CalJNI.NWSetFileServerDateAndTime(
         connection,
         year,
         month,
         day,
         hour,
         minute,
         second);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }
}



