/* **************************************************************************

  $Archive: /njcl_v2rmi/src/com/novell/service/session/xplat/DeviceAccessServiceImpl.java $
  $Revision: 11 $
  $Modtime: 1/12/01 4:44p $

  Copyright (c) 1997 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/
package com.novell.service.session.xplat;

import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import com.novell.service.jncpv2r.cal.*;
import com.novell.service.session.*;
import com.novell.service.session.spi.RMISocketFactories;
import com.novell.service.session.util.Debug;
import com.novell.service.jncp.NSIException;
import com.novell.service.jncp.NSIExceptionBuilder;
import com.novell.java.lang.IntegerBuffer;
import com.novell.java.lang.BooleanBuffer;
import com.novell.service.file.nw.*;
import com.novell.service.server.*;
import com.novell.service.ncpext.*;
import com.novell.service.file.nw.calls.*;
import com.novell.service.qms.*;


/** @internal
 * Object returned by Session.getService() that wraps all NWCALLS
 * native services (via DeviceAccessJNI).
 */
public class DeviceAccessServiceImpl extends UnicastRemoteObject
implements DeviceAccessService
{
   // Always access debug via final static...hopefully a final static of
   // false will be optimized out by the compiler
   final static private boolean DEBUG = false;
   final static private boolean S_DEBUG = false; // May have side effects

   public DeviceAccessServiceImpl(RMISocketFactories x)
   throws SessionException, RemoteException
   {
      super(x.getPort(), x.getClientSocketFactory(), x.getServerSocketFactory());
   }

   public DeviceAccessServiceImpl()
   throws SessionException, RemoteException
   {
   }

   /**
    *
    */
   public void close (
         /*in*/   int         handle)
      throws SessionException, RemoteException
   {
      int ccode;

      ccode = DeviceAccessJNI.JDAClose (handle);

      if (ccode != 0)
      {
         throw (NSIExceptionBuilder.build (ccode));
      }

   } /* close () */

   /**
    *
    */
   public void flush (
         /*in*/   int         handle)
      throws SessionException, RemoteException
   {
      int ccode;

      ccode = DeviceAccessJNI.JDAFlush (handle);

      if (ccode != 0)
      {
         throw (NSIExceptionBuilder.build (ccode));
      }

   } /* flush () */

   /**
    *
    */
   public int getLength (
         /*in*/   int            handle)
      throws SessionException, RemoteException
   {
      int ccode;
      int[] length = new int[1];

      ccode = DeviceAccessJNI.JDAGetLength (handle, length);

      if (ccode != 0)
      {
         throw (NSIExceptionBuilder.build (ccode));
      }

      return (length[0]);

   } /* getLength () */

   /**
    *
    */
   public void setLength (
         /*in*/   int            handle,
         /*in*/   int            length)
      throws SessionException, RemoteException
   {
      int ccode;

      ccode = DeviceAccessJNI.JDASetLength (handle, length);

      if (ccode != 0)
      {
         throw (NSIExceptionBuilder.build (ccode));
      }

   } /* setLength () */

   /**
    *
    */
   public int getPosition (
         /*in*/   int            handle)
      throws SessionException, RemoteException
   {
      int ccode;
      int[] length = new int[1];

      ccode = DeviceAccessJNI.JDAGetPosition (handle, length);

      if (ccode != 0)
      {
         throw (NSIExceptionBuilder.build (ccode));
      }

      return (length[0]);

   } /* getPosition () */

   /**
    *
    */
   public void setPosition (
         /*in*/   int               handle,
         /*in*/   int               mode,
         /*in*/   int               position)
      throws SessionException, RemoteException
   {
      int ccode;

      ccode = DeviceAccessJNI.JDASetPosition (handle, mode, position);

      if (ccode != 0)
      {
         throw (NSIExceptionBuilder.build (ccode));
      }

   } /* setPosition () */

   /**
    *
    */
   public byte[] read (
         /*in*/   int         handle,
         /*in*/   int         length)
      throws SessionException, RemoteException
   {
      int ccode;
      byte[][] buffer = new byte[1][];

      ccode = DeviceAccessJNI.JDARead (handle, length, buffer);

      if (ccode != 0)
      {
         throw (NSIExceptionBuilder.build (ccode));
      }

      return (buffer[0]);

   } /* read () */

   /**
    *
    */
   public void write (
         /*in*/   int         handle,
         /*in*/   byte[]      buffer)
      throws SessionException, RemoteException
   {
      int ccode;

      ccode = DeviceAccessJNI.JDAWrite (handle, buffer);

      if (ccode != 0)
      {
         throw (NSIExceptionBuilder.build (ccode));
      }

   } /* write () */

} /* DeviceAccessServiceImpl */


