/* **************************************************************************
  $Archive: /njcl_v2rmi/src/com/novell/service/session/xplat/NCPService.java $
  $Revision: 7 $
  $Modtime: 12/06/00 1:37p $

  Copyright (c) 1997 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/
package com.novell.service.session.xplat;

import java.rmi.RemoteException;
import com.novell.service.session.*;
import com.novell.service.jncp.NSIException;

/**
 * Provides the object returned by Session.getService().
 */
public interface NCPService extends SessionService
{
   /**
    * The key used to generate an object of this type via the
    * Session.getService() method.
    *
    * <p>(KEY = "com.novell.service.session.xplat.NCPService.493049483")</p>
    */
   public static final String KEY =
      "com.novell.service.session.xplat.NCPService.493049483";

  /** Exposes the "C" NWCCFragmentRequest function.
   *
   * @param function   The "C" NWCCFragmentRequest function.
   * @param verb 
   * @param reserved   Pass in 0.
   * @param reqFrags   The byte arrays that the function is to extract 
   *                   and send.
   * @param replyFrags The byte arrays that the function will fill
   *                   with the return data.
   *
   * @return The number of bytes returned by the NCP.
   *
   * @exception NSIException When there is a failure. You can check
   *            the embedded ccode via the getCCode() method.
   */
   public int fragmentRequest
   (
      int function,
      int verb,
      int reserved,
      byte[][] reqFrags,
      /*inout*/ byte[][] replyFrags
   )
   throws NSIException, SessionException, RemoteException;
}
