/* **************************************************************************

  $Archive: /njcl_v2rmi/src/com/novell/service/session/xplat/NativeContextMaster.java $
  $Revision: 7 $
  $Modtime: 11/15/00 3:43p $

  Copyright (c) 1997 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/
package com.novell.service.session.xplat;

import java.util.Enumeration;
import java.util.Vector;
import com.novell.service.session.util.Debug;

/** @internal
 * Class which contains both a native context handle and a native thread group
 * id for use in nlm thread-group switching.
 *
 * Intended to be returned by ClxJNI.NWDSCreateContextHandle().
 */
public class NativeContextMaster extends NativeContext
{
   // Always access debug via final static...hopefully a final static of
   // false will be optimized out by the compiler
	final static private boolean DEBUG = false;
	final static private boolean CLOSE_DEBUG = false;

   Vector children = new Vector();
   String tree;
   NativeContexts owner;

   public NativeContextMaster(
      int threadGroup,
      int contextHandle,
      String tree
   )
   {
      super(threadGroup, contextHandle);
      this.tree = tree;
   }

   public void setOwner(
      NativeContexts owner)
   {
      this.owner = owner;
   }

   public String getTree()
   {
      return this.tree;
   }

   public void addChild(NativeContextDuplicate child)
   {
      children.addElement(child);
   }

   public void removeChild(NativeContextDuplicate child)
   {
      children.removeElement(child);
   }

   public void close()
   {
      // Need 'fixed' array of children so they can be removed from
      // original children vector...enum would be effected by removal.
      int size = this.children.size();
      NativeContext[] children = new NativeContext[size];
      this.children.copyInto(children);
      for (int i = 0; i < size; i++)
      {
         NativeContext child = children[i];
         if (DEBUG || CLOSE_DEBUG)
         {
            Debug.printlnOnly("Closing: " + child.toString());
         }
         child.close();
      }
      owner.remove(this);
      free();
   }

   public String toString()
   {
      StringBuffer out = new StringBuffer();
      out.append("NativeContext$");
      out.append(
         ":C=0x" + Integer.toHexString(this.contextHandle));
      out.append(
         ":TG=0x" + Integer.toHexString(this.threadGroup));

      return (out.toString());
   }
}

